/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.equivalence.EquivalentHashMap;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.FastCopyHashMap;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.distribution.util.ReadOnlySegmentAwareMap;
import org.jboss.marshalling.util.IdentityIntMap;

public class MapExternalizer
extends AbstractExternalizer<Map> {
    private static final int HASHMAP = 0;
    private static final int TREEMAP = 1;
    private static final int FASTCOPYHASHMAP = 2;
    private static final int EQUIVALENTHASHMAP = 3;
    private static final int CONCURRENTHASHMAP = 4;
    private static final int ENTRYVERSIONMAP = 5;
    private static final int SINGLETONMAP = 6;
    private static final int EMPTYMAP = 7;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(9);

    public MapExternalizer() {
        this.numbers.put(HashMap.class, 0);
        this.numbers.put(ReadOnlySegmentAwareMap.class, 0);
        this.numbers.put(TreeMap.class, 1);
        this.numbers.put(FastCopyHashMap.class, 2);
        this.numbers.put(EquivalentHashMap.class, 3);
        this.numbers.put(ConcurrentHashMap.class, 4);
        this.numbers.put(EntryVersionsMap.class, 5);
        this.numbers.put(MapExternalizer.getPrivateSingletonMapClass(), 6);
        this.numbers.put(MapExternalizer.getPrivateEmptyMapClass(), 7);
    }

    public void writeObject(ObjectOutput output, Map map) throws IOException {
        int number = this.numbers.get(map.getClass(), -1);
        output.write(number);
        switch (number) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                MarshallUtil.marshallMap((Map)map, (ObjectOutput)output);
                break;
            }
            case 3: {
                EquivalentHashMap equivalentMap = (EquivalentHashMap)map;
                output.writeObject(equivalentMap.getKeyEquivalence());
                output.writeObject(equivalentMap.getValueEquivalence());
                MarshallUtil.marshallMap((Map)map, (ObjectOutput)output);
                break;
            }
            case 2: {
                MarshallUtil.marshallMap((Map)((FastCopyHashMap)map).clone(), (ObjectOutput)output);
                break;
            }
            case 6: {
                Map.Entry singleton = map.entrySet().iterator().next();
                output.writeObject(singleton.getKey());
                output.writeObject(singleton.getValue());
                break;
            }
        }
    }

    public Map readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        switch (magicNumber) {
            case 0: {
                return MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new);
            }
            case 1: {
                return MarshallUtil.unmarshallMap((ObjectInput)input, size -> new TreeMap());
            }
            case 2: {
                return MarshallUtil.unmarshallMap((ObjectInput)input, FastCopyHashMap::new);
            }
            case 3: {
                Equivalence keyEq = (Equivalence)input.readObject();
                Equivalence valueEq = (Equivalence)input.readObject();
                return MarshallUtil.unmarshallMap((ObjectInput)input, size -> new EquivalentHashMap(keyEq, valueEq));
            }
            case 4: {
                return MarshallUtil.unmarshallMap((ObjectInput)input, ConcurrentHashMap::new);
            }
            case 5: {
                return MarshallUtil.unmarshallMap((ObjectInput)input, EntryVersionsMap::new);
            }
            case 6: {
                return Collections.singletonMap(input.readObject(), input.readObject());
            }
            case 7: {
                return Collections.emptyMap();
            }
        }
        throw new IllegalStateException("Unknown Map type: " + magicNumber);
    }

    public Integer getId() {
        return 1;
    }

    public Set<Class<? extends Map>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{HashMap.class, TreeMap.class, FastCopyHashMap.class, EquivalentHashMap.class, ReadOnlySegmentAwareMap.class, ConcurrentHashMap.class, EntryVersionsMap.class, MapExternalizer.getPrivateSingletonMapClass(), MapExternalizer.getPrivateEmptyMapClass()});
    }

    private static Class<? extends Map> getPrivateSingletonMapClass() {
        return MapExternalizer.getMapClass("java.util.Collections$SingletonMap");
    }

    private static Class<? extends Map> getPrivateEmptyMapClass() {
        return MapExternalizer.getMapClass("java.util.Collections$EmptyMap");
    }

    private static Class<? extends Map> getMapClass(String className) {
        return Util.loadClass((String)className, (ClassLoader)Map.class.getClassLoader());
    }
}

