/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.encoding.CDRInputObject;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.oa.poa.Policies;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.transport.EventHandlerBase;
import com.sun.corba.se.impl.transport.SocketOrChannelConnectionImpl;
import com.sun.corba.se.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.se.pept.broker.Broker;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.EventHandler;
import com.sun.corba.se.pept.transport.InboundConnectionCache;
import com.sun.corba.se.pept.transport.Selector;
import com.sun.corba.se.spi.extension.RequestPartitioningPolicy;
import com.sun.corba.se.spi.ior.IORTemplate;
import com.sun.corba.se.spi.ior.TaggedProfileTemplate;
import com.sun.corba.se.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPFactories;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.transport.CorbaAcceptor;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.SocketInfo;
import com.sun.corba.se.spi.transport.SocketOrChannelAcceptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import sun.corba.OutputStreamFactory;

public class SocketOrChannelAcceptorImpl
extends EventHandlerBase
implements CorbaAcceptor,
SocketOrChannelAcceptor,
Work,
SocketInfo,
LegacyServerSocketEndPointInfo {
    protected ServerSocketChannel serverSocketChannel;
    protected ServerSocket serverSocket;
    protected int port;
    protected long enqueueTime;
    protected boolean initialized;
    protected ORBUtilSystemException wrapper;
    protected InboundConnectionCache connectionCache;
    protected String type = "";
    protected String name = "";
    protected String hostname;
    protected int locatorPort;

    public SocketOrChannelAcceptorImpl(ORB orb) {
        this.orb = orb;
        this.wrapper = ORBUtilSystemException.get(orb, "rpc.transport");
        this.setWork(this);
        this.initialized = false;
        this.hostname = orb.getORBData().getORBServerHost();
        this.name = "NO_NAME";
        this.locatorPort = -1;
    }

    public SocketOrChannelAcceptorImpl(ORB orb, int port) {
        this(orb);
        this.port = port;
    }

    public SocketOrChannelAcceptorImpl(ORB orb, int port, String name, String type) {
        this(orb, port);
        this.name = name;
        this.type = type;
    }

    @Override
    public boolean initialize() {
        if (this.initialized) {
            return false;
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".initialize: " + this);
        }
        InetSocketAddress inetSocketAddress = null;
        try {
            if (this.orb.getORBData().getListenOnAllInterfaces()) {
                inetSocketAddress = new InetSocketAddress(this.port);
            } else {
                String host = this.orb.getORBData().getORBServerHost();
                inetSocketAddress = new InetSocketAddress(host, this.port);
            }
            this.serverSocket = this.orb.getORBData().getSocketFactory().createServerSocket(this.type, inetSocketAddress);
            this.internalInitialize();
        }
        catch (Throwable t) {
            throw this.wrapper.createListenerFailed(t, (Object)Integer.toString(this.port));
        }
        this.initialized = true;
        return true;
    }

    protected void internalInitialize() throws Exception {
        this.port = this.serverSocket.getLocalPort();
        this.orb.getCorbaTransportManager().getInboundConnectionCache(this);
        this.serverSocketChannel = this.serverSocket.getChannel();
        if (this.serverSocketChannel != null) {
            this.setUseSelectThreadToWait(this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
            this.serverSocketChannel.configureBlocking(!this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
        } else {
            this.setUseSelectThreadToWait(false);
        }
        this.setUseWorkerThreadForEvent(this.orb.getORBData().acceptorSocketUseWorkerThreadForEvent());
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public String getConnectionCacheType() {
        return this.getClass().toString();
    }

    @Override
    public void setConnectionCache(InboundConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }

    @Override
    public InboundConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    @Override
    public boolean shouldRegisterAcceptEvent() {
        return true;
    }

    @Override
    public void accept() {
        block9: {
            try {
                Selector selector;
                SocketChannel socketChannel = null;
                Socket socket = null;
                if (this.serverSocketChannel == null) {
                    socket = this.serverSocket.accept();
                } else {
                    socketChannel = this.serverSocketChannel.accept();
                    socket = socketChannel.socket();
                }
                this.orb.getORBData().getSocketFactory().setAcceptedSocketOptions(this, this.serverSocket, socket);
                if (this.orb.transportDebugFlag) {
                    this.dprint(".accept: " + (this.serverSocketChannel == null ? this.serverSocket.toString() : this.serverSocketChannel.toString()));
                }
                SocketOrChannelConnectionImpl connection = new SocketOrChannelConnectionImpl(this.orb, this, socket);
                if (this.orb.transportDebugFlag) {
                    this.dprint(".accept: new: " + connection);
                }
                this.getConnectionCache().stampTime(connection);
                this.getConnectionCache().add(connection);
                if (connection.shouldRegisterServerReadEvent() && (selector = this.orb.getTransportManager().getSelector(0)) != null) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".accept: registerForEvent: " + connection);
                    }
                    selector.registerForEvent(connection.getEventHandler());
                }
                this.getConnectionCache().reclaim();
            }
            catch (IOException e) {
                Selector selector;
                if (this.orb.transportDebugFlag) {
                    this.dprint(".accept:", e);
                }
                if ((selector = this.orb.getTransportManager().getSelector(0)) == null) break block9;
                selector.unregisterForEvent(this);
                selector.registerForEvent(this);
            }
        }
    }

    @Override
    public void close() {
        try {
            Selector selector;
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->:");
            }
            if ((selector = this.orb.getTransportManager().getSelector(0)) != null) {
                selector.unregisterForEvent(this);
            }
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close:", e);
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-:");
            }
        }
    }

    @Override
    public EventHandler getEventHandler() {
        return this;
    }

    @Override
    public String getObjectAdapterId() {
        return null;
    }

    @Override
    public String getObjectAdapterManagerId() {
        return null;
    }

    @Override
    public void addToIORTemplate(IORTemplate iorTemplate, Policies policies, String codebase) {
        Iterator iterator = iorTemplate.iteratorById(0);
        String hostname = this.orb.getORBData().getORBServerHost();
        if (iterator.hasNext()) {
            IIOPAddress iiopAddress = IIOPFactories.makeIIOPAddress(this.orb, hostname, this.port);
            AlternateIIOPAddressComponent iiopAddressComponent = IIOPFactories.makeAlternateIIOPAddressComponent(iiopAddress);
            while (iterator.hasNext()) {
                TaggedProfileTemplate taggedProfileTemplate = (TaggedProfileTemplate)iterator.next();
                taggedProfileTemplate.add(iiopAddressComponent);
            }
        } else {
            GIOPVersion version = this.orb.getORBData().getGIOPVersion();
            int templatePort = policies.forceZeroPort() ? 0 : (policies.isTransient() ? this.port : this.orb.getLegacyServerSocketManager().legacyGetPersistentServerPort("IIOP_CLEAR_TEXT"));
            IIOPAddress addr = IIOPFactories.makeIIOPAddress(this.orb, hostname, templatePort);
            IIOPProfileTemplate iiopProfile = IIOPFactories.makeIIOPProfileTemplate(this.orb, version, addr);
            if (version.supportsIORIIOPProfileComponents()) {
                iiopProfile.add(IIOPFactories.makeCodeSetsComponent(this.orb));
                iiopProfile.add(IIOPFactories.makeMaxStreamFormatVersionComponent());
                RequestPartitioningPolicy rpPolicy = (RequestPartitioningPolicy)policies.get_effective_policy(0x53550003);
                if (rpPolicy != null) {
                    iiopProfile.add(IIOPFactories.makeRequestPartitioningComponent(rpPolicy.getValue()));
                }
                if (codebase != null && codebase != "") {
                    iiopProfile.add(IIOPFactories.makeJavaCodebaseComponent(codebase));
                }
                if (this.orb.getORBData().isJavaSerializationEnabled()) {
                    iiopProfile.add(IIOPFactories.makeJavaSerializationComponent());
                }
            }
            iorTemplate.add(iiopProfile);
        }
    }

    @Override
    public String getMonitoringName() {
        return "AcceptedConnections";
    }

    @Override
    public SelectableChannel getChannel() {
        return this.serverSocketChannel;
    }

    @Override
    public int getInterestOps() {
        return 16;
    }

    @Override
    public Acceptor getAcceptor() {
        return this;
    }

    @Override
    public Connection getConnection() {
        throw new RuntimeException("Should not happen.");
    }

    @Override
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork->: " + this);
            }
            if (this.selectionKey.isAcceptable()) {
                this.accept();
            } else if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ! selectionKey.isAcceptable: " + this);
            }
        }
        catch (SecurityException se) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring SecurityException: " + se + " " + this);
            }
            String permissionStr = ORBUtility.getClassSecurityInfo(this.getClass());
            this.wrapper.securityExceptionInAccept(se, permissionStr);
        }
        catch (Exception ex) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Exception: " + ex + " " + this);
            }
            this.wrapper.exceptionInAccept(ex);
        }
        catch (Throwable t) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Throwable: " + t + " " + this);
            }
        }
        finally {
            Selector selector = this.orb.getTransportManager().getSelector(0);
            if (selector != null) {
                selector.registerInterestOps(this);
            }
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork<-:" + this);
            }
        }
    }

    @Override
    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    @Override
    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public MessageMediator createMessageMediator(Broker broker, Connection connection) {
        SocketOrChannelContactInfoImpl contactInfo = new SocketOrChannelContactInfoImpl();
        return contactInfo.createMessageMediator(broker, connection);
    }

    @Override
    public MessageMediator finishCreatingMessageMediator(Broker broker, Connection connection, MessageMediator messageMediator) {
        SocketOrChannelContactInfoImpl contactInfo = new SocketOrChannelContactInfoImpl();
        return contactInfo.finishCreatingMessageMediator(broker, connection, messageMediator);
    }

    @Override
    public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return new CDRInputObject((ORB)broker, (CorbaConnection)messageMediator.getConnection(), corbaMessageMediator.getDispatchBuffer(), corbaMessageMediator.getDispatchHeader());
    }

    @Override
    public OutputObject createOutputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return OutputStreamFactory.newCDROutputObject((ORB)broker, corbaMessageMediator, corbaMessageMediator.getReplyHeader(), corbaMessageMediator.getStreamFormatVersion());
    }

    @Override
    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public String toString() {
        String sock = this.serverSocketChannel == null ? (this.serverSocket == null ? "(not initialized)" : this.serverSocket.toString()) : this.serverSocketChannel.toString();
        return this.toStringName() + "[" + sock + " " + this.type + " " + this.shouldUseSelectThreadToWait() + " " + this.shouldUseWorkerThreadForEvent() + "]";
    }

    protected String toStringName() {
        return "SocketOrChannelAcceptorImpl";
    }

    protected void dprint(String msg) {
        ORBUtility.dprint(this.toStringName(), msg);
    }

    protected void dprint(String msg, Throwable t) {
        this.dprint(msg);
        t.printStackTrace(System.out);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public String getHost() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getLocatorPort() {
        return this.locatorPort;
    }

    @Override
    public void setLocatorPort(int port) {
        this.locatorPort = port;
    }

    @Override
    public String getName() {
        String result = this.name.equals("NO_NAME") ? this.toString() : this.name;
        return result;
    }
}

