/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.BinaryMemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.OffHeapMemoryResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;

public class MemoryServiceConfigurator
extends ComponentServiceConfigurator<MemoryConfiguration> {
    private final StorageType storageType;
    private volatile long size;
    private volatile int capacity;
    private volatile EvictionType evictionType;

    MemoryServiceConfigurator(StorageType storageType, PathAddress address) {
        super(CacheComponent.MEMORY, address);
        this.storageType = storageType;
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.size = MemoryResourceDefinition.Attribute.SIZE.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.evictionType = (EvictionType)ModelNodes.asEnum((ModelNode)BinaryMemoryResourceDefinition.Attribute.EVICTION_TYPE.resolveModelAttribute((ExpressionResolver)context, model), EvictionType.class);
        this.capacity = OffHeapMemoryResourceDefinition.Attribute.CAPACITY.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        return this;
    }

    @Override
    public MemoryConfiguration get() {
        return new ConfigurationBuilder().memory().size(this.size).storageType(this.storageType).evictionStrategy(this.size > 0L ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL).evictionType(this.evictionType).addressCount(this.capacity).create();
    }
}

