/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.TxAwareLDAPUserModelDelegate;

public class UserAttributeLDAPStorageMapper
extends AbstractLDAPStorageMapper {
    private static final Logger logger = Logger.getLogger(UserAttributeLDAPStorageMapper.class);
    private static final Map<String, Property<Object>> userModelProperties = LDAPUtils.getUserModelProperties();
    public static final String USER_MODEL_ATTRIBUTE = "user.model.attribute";
    public static final String LDAP_ATTRIBUTE = "ldap.attribute";
    public static final String READ_ONLY = "read.only";
    public static final String ALWAYS_READ_VALUE_FROM_LDAP = "always.read.value.from.ldap";
    public static final String IS_MANDATORY_IN_LDAP = "is.mandatory.in.ldap";
    public static final String IS_BINARY_ATTRIBUTE = "is.binary.attribute";

    public UserAttributeLDAPStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        String userModelAttrName = this.getUserModelAttribute();
        String ldapAttrName = this.getLdapAttributeName();
        if (this.isBinaryAttribute()) {
            return;
        }
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName.toLowerCase());
        if (userModelProperty != null) {
            String ldapAttrValue = ldapUser.getAttributeAsString(ldapAttrName);
            this.checkDuplicateEmail(userModelAttrName, ldapAttrValue, realm, this.ldapProvider.getSession(), user);
            this.setPropertyOnUserModel(userModelProperty, user, ldapAttrValue);
        } else {
            Set<String> ldapAttrValue = ldapUser.getAttributeAsSet(ldapAttrName);
            if (ldapAttrValue != null) {
                user.setAttribute(userModelAttrName, new ArrayList<String>(ldapAttrValue));
            } else {
                user.removeAttribute(userModelAttrName);
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        String userModelAttrName = this.getUserModelAttribute();
        String ldapAttrName = this.getLdapAttributeName();
        boolean isMandatoryInLdap = UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, IS_MANDATORY_IN_LDAP);
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName.toLowerCase());
        if (userModelProperty != null) {
            Object attrValue = userModelProperty.getValue((Object)localUser);
            if (attrValue == null) {
                if (isMandatoryInLdap) {
                    ldapUser.setSingleAttribute(ldapAttrName, " ");
                } else {
                    ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>());
                }
            } else {
                ldapUser.setSingleAttribute(ldapAttrName, attrValue.toString());
            }
        } else {
            List attrValues = localUser.getAttribute(userModelAttrName);
            if (attrValues.size() == 0) {
                if (isMandatoryInLdap) {
                    ldapUser.setSingleAttribute(ldapAttrName, " ");
                } else {
                    ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>());
                }
            } else {
                ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>(attrValues));
            }
        }
        if (this.isReadOnly()) {
            ldapUser.addReadOnlyAttributeName(ldapAttrName);
        }
    }

    protected void checkDuplicateEmail(String userModelAttrName, String email, RealmModel realm, KeycloakSession session, UserModel user) {
        if (email == null || realm.isDuplicateEmailsAllowed()) {
            return;
        }
        if ("email".equalsIgnoreCase(userModelAttrName)) {
            email = KeycloakModelUtils.toLowerCaseSafe((String)email);
            UserModel that = session.userLocalStorage().getUserByEmail(email, realm);
            if (that != null && !that.getId().equals(user.getId())) {
                session.getTransactionManager().setRollbackOnly();
                String exceptionMessage = String.format("Can't import user '%s' from LDAP because email '%s' already exists in Keycloak. Existing user with this email is '%s'", user.getUsername(), email, that.getUsername());
                throw new ModelDuplicateException(exceptionMessage, "email");
            }
        }
    }

    protected void checkDuplicateUsername(String userModelAttrName, String username, RealmModel realm, KeycloakSession session, UserModel user) {
        if ("username".equalsIgnoreCase(userModelAttrName)) {
            boolean usernameChanged;
            if (username == null || username.isEmpty()) {
                throw new ModelException("Cannot set an empty username");
            }
            boolean bl = usernameChanged = !username.equals(user.getUsername());
            if (realm.isEditUsernameAllowed() && usernameChanged) {
                UserModel that = session.users().getUserByUsername(username, realm);
                if (that != null && !that.getId().equals(user.getId())) {
                    throw new ModelDuplicateException(String.format("Cannot change the username to '%s' because the username already exists in keycloak", username), "username");
                }
            } else if (usernameChanged) {
                throw new ModelException("Cannot change username if the realm is not configured to allow edit the usernames");
            }
        }
    }

    @Override
    public UserModel proxy(final LDAPObject ldapUser, UserModel delegate, final RealmModel realm) {
        final String userModelAttrName = this.getUserModelAttribute();
        final String ldapAttrName = this.getLdapAttributeName();
        boolean isAlwaysReadValueFromLDAP = UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, ALWAYS_READ_VALUE_FROM_LDAP);
        final boolean isMandatoryInLdap = UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, IS_MANDATORY_IN_LDAP);
        final boolean isBinaryAttribute = UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, IS_BINARY_ATTRIBUTE);
        if (this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && !this.isReadOnly()) {
            delegate = new TxAwareLDAPUserModelDelegate((UserModel)delegate, this.ldapProvider, ldapUser){

                public void setSingleAttribute(String name, String value) {
                    if (this.setLDAPAttribute(name, value)) {
                        super.setSingleAttribute(name, value);
                    }
                }

                public void setAttribute(String name, List<String> values) {
                    if (this.setLDAPAttribute(name, values)) {
                        super.setAttribute(name, values);
                    }
                }

                public void removeAttribute(String name) {
                    if (this.setLDAPAttribute(name, null)) {
                        super.removeAttribute(name);
                    }
                }

                public void setUsername(String username) {
                    UserAttributeLDAPStorageMapper.this.checkDuplicateUsername(userModelAttrName, username, realm, UserAttributeLDAPStorageMapper.this.ldapProvider.getSession(), (UserModel)this);
                    this.setLDAPAttribute("username", username);
                    super.setUsername(username);
                }

                public void setEmail(String email) {
                    UserAttributeLDAPStorageMapper.this.checkDuplicateEmail(userModelAttrName, email, realm, UserAttributeLDAPStorageMapper.this.ldapProvider.getSession(), (UserModel)this);
                    this.setLDAPAttribute("email", email);
                    super.setEmail(email);
                }

                public void setLastName(String lastName) {
                    this.setLDAPAttribute("lastName", lastName);
                    super.setLastName(lastName);
                }

                public void setFirstName(String firstName) {
                    this.setLDAPAttribute("firstName", firstName);
                    super.setFirstName(firstName);
                }

                protected boolean setLDAPAttribute(String modelAttrName, Object value) {
                    if (modelAttrName.equalsIgnoreCase(userModelAttrName)) {
                        if (logger.isTraceEnabled()) {
                            logger.tracef("Pushing user attribute to LDAP. username: %s, Model attribute name: %s, LDAP attribute name: %s, Attribute value: %s", new Object[]{this.getUsername(), modelAttrName, ldapAttrName, value});
                        }
                        this.ensureTransactionStarted();
                        if (value == null) {
                            if (isMandatoryInLdap) {
                                this.ldapUser.setSingleAttribute(ldapAttrName, " ");
                            } else {
                                this.ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>());
                            }
                        } else if (value instanceof String) {
                            this.ldapUser.setSingleAttribute(ldapAttrName, (String)value);
                        } else {
                            List asList = (List)value;
                            if (asList.isEmpty() && isMandatoryInLdap) {
                                this.ldapUser.setSingleAttribute(ldapAttrName, " ");
                            } else {
                                this.ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>(asList));
                            }
                        }
                        if (isBinaryAttribute) {
                            logger.debugf("Skip writing model attribute '%s' to DB for user '%s' as it is mapped to binary LDAP attribute.", (Object)userModelAttrName, (Object)this.getUsername());
                            return false;
                        }
                        return true;
                    }
                    return true;
                }
            };
        } else if (isBinaryAttribute) {
            delegate = new UserModelDelegate((UserModel)delegate){

                public void setSingleAttribute(String name, String value) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        this.logSkipDBWrite();
                    } else {
                        super.setSingleAttribute(name, value);
                    }
                }

                public void setAttribute(String name, List<String> values) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        this.logSkipDBWrite();
                    } else {
                        super.setAttribute(name, values);
                    }
                }

                public void removeAttribute(String name) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        this.logSkipDBWrite();
                    } else {
                        super.removeAttribute(name);
                    }
                }

                private void logSkipDBWrite() {
                    logger.debugf("Skip writing model attribute '%s' to DB for user '%s' as it is mapped to binary LDAP attribute", (Object)userModelAttrName, (Object)this.getUsername());
                }
            };
        }
        if (isAlwaysReadValueFromLDAP) {
            delegate = new UserModelDelegate((UserModel)delegate){

                public String getFirstAttribute(String name) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getFirstAttribute(name);
                }

                public List<String> getAttribute(String name) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        Set<String> ldapAttrValue = ldapUser.getAttributeAsSet(ldapAttrName);
                        if (ldapAttrValue == null) {
                            return Collections.emptyList();
                        }
                        return new ArrayList<String>(ldapAttrValue);
                    }
                    return super.getAttribute(name);
                }

                public Map<String, List<String>> getAttributes() {
                    HashMap<String, List<String>> attrs = new HashMap<String, List<String>>(super.getAttributes());
                    if (userModelProperties.get(userModelAttrName.toLowerCase()) != null) {
                        return attrs;
                    }
                    Set<String> allLdapAttrValues = ldapUser.getAttributeAsSet(ldapAttrName);
                    if (allLdapAttrValues != null) {
                        attrs.put(userModelAttrName, new ArrayList<String>(allLdapAttrValues));
                    }
                    return attrs;
                }

                public String getEmail() {
                    if ("email".equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getEmail();
                }

                public String getLastName() {
                    if ("lastName".equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getLastName();
                }

                public String getFirstName() {
                    if ("firstName".equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getFirstName();
                }
            };
        }
        return delegate;
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        String userModelAttrName = this.getUserModelAttribute();
        String ldapAttrName = this.getLdapAttributeName();
        query.addReturningLdapAttribute(ldapAttrName);
        if (this.isReadOnly()) {
            query.addReturningReadOnlyLdapAttribute(ldapAttrName);
        }
        for (Condition condition : query.getConditions()) {
            condition.updateParameterName(userModelAttrName, ldapAttrName);
            String parameterName = condition.getParameterName();
            if (parameterName == null || !parameterName.equalsIgnoreCase(userModelAttrName) && !parameterName.equalsIgnoreCase(ldapAttrName)) continue;
            condition.setBinary(this.isBinaryAttribute());
        }
    }

    private String getUserModelAttribute() {
        return (String)this.mapperModel.getConfig().getFirst((Object)USER_MODEL_ATTRIBUTE);
    }

    String getLdapAttributeName() {
        return (String)this.mapperModel.getConfig().getFirst((Object)LDAP_ATTRIBUTE);
    }

    private boolean isBinaryAttribute() {
        return this.mapperModel.get(IS_BINARY_ATTRIBUTE, false);
    }

    private boolean isReadOnly() {
        return UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, READ_ONLY);
    }

    protected void setPropertyOnUserModel(Property<Object> userModelProperty, UserModel user, String ldapAttrValue) {
        if (ldapAttrValue == null) {
            userModelProperty.setValue((Object)user, null);
        } else {
            Class clazz = userModelProperty.getJavaClass();
            if (String.class.equals((Object)clazz)) {
                userModelProperty.setValue((Object)user, (Object)ldapAttrValue);
            } else if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
                Boolean boolVal = Boolean.valueOf(ldapAttrValue);
                userModelProperty.setValue((Object)user, (Object)boolVal);
            } else {
                logger.warnf("Don't know how to set the property '%s' on user '%s' . Value of LDAP attribute is '%s' ", (Object)userModelProperty.getName(), (Object)user.getUsername(), (Object)ldapAttrValue.toString());
            }
        }
    }
}

