/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.Attribute;
import org.infinispan.persistence.jdbc.configuration.Element;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;

@Namespaces(value={@Namespace(root="string-keyed-jdbc-store"), @Namespace(root="binary-keyed-jdbc-store"), @Namespace(root="mixed-keyed-jdbc-store"), @Namespace(uri="urn:infinispan:config:store:jdbc:*", root="string-keyed-jdbc-store"), @Namespace(uri="urn:infinispan:config:store:jdbc:*", root="binary-keyed-jdbc-store", until="9.0"), @Namespace(uri="urn:infinispan:config:store:jdbc:*", root="mixed-keyed-jdbc-store", until="9.0")})
public class JdbcStoreConfigurationParser
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case STRING_KEYED_JDBC_STORE: {
                this.parseStringKeyedJdbcStore(reader, builder.persistence());
                break;
            }
            case BINARY_KEYED_JDBC_STORE: 
            case MIXED_KEYED_JDBC_STORE: {
                throw new CacheConfigurationException("Binary and Mixed Keyed JDBC stores were removed in 9.0. Please use JdbcStringBasedStore instead");
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseStringKeyedJdbcStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder) throws XMLStreamException {
        JdbcStringBasedStoreConfigurationBuilder builder = new JdbcStringBasedStoreConfigurationBuilder(persistenceBuilder);
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_TO_STRING_MAPPER: {
                    builder.key2StringMapper(value);
                    continue block12;
                }
                case DIALECT: {
                    builder.dialect(DatabaseType.valueOf(value));
                    continue block12;
                }
                case DB_MAJOR_VERSION: {
                    builder.dbMajorVersion(Integer.parseInt(value));
                    continue block12;
                }
                case DB_MINOR_VERSION: {
                    builder.dbMinorVersion(Integer.parseInt(value));
                    continue block12;
                }
                default: {
                    Parser.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseTable(reader, builder.table());
                    continue block13;
                }
                case CONNECTION_POOL: {
                    this.parseConnectionPoolAttributes(reader, builder.connectionPool());
                    continue block13;
                }
                case DATA_SOURCE: {
                    this.parseDataSourceAttributes(reader, builder.dataSource());
                    continue block13;
                }
                case SIMPLE_CONNECTION: {
                    this.parseSimpleConnectionAttributes(reader, builder.simpleConnection());
                    continue block13;
                }
            }
            Parser.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        persistenceBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseDataSourceAttributes(XMLExtendedStreamReader reader, ManagedConnectionFactoryConfigurationBuilder<?> builder) throws XMLStreamException {
        String jndiUrl = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (String)Attribute.JNDI_URL.getLocalName());
        builder.jndiUrl(jndiUrl);
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseConnectionPoolAttributes(XMLExtendedStreamReader reader, PooledConnectionFactoryConfigurationBuilder<?> builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROPERTIES_FILE: {
                    builder.propertyFile(value);
                    continue block7;
                }
                case CONNECTION_URL: {
                    builder.connectionUrl(value);
                    continue block7;
                }
                case DRIVER_CLASS: {
                    builder.driverClass(value);
                    continue block7;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block7;
                }
                case USERNAME: {
                    builder.username(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseSimpleConnectionAttributes(XMLExtendedStreamReader reader, SimpleConnectionFactoryConfigurationBuilder<?> builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONNECTION_URL: {
                    builder.connectionUrl(value);
                    continue block6;
                }
                case DRIVER_CLASS: {
                    builder.driverClass(value);
                    continue block6;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block6;
                }
                case USERNAME: {
                    builder.username(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseTable(XMLExtendedStreamReader reader, TableManipulationConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BATCH_SIZE: {
                    builder.batchSize(Integer.parseInt(value));
                    continue block7;
                }
                case CREATE_ON_START: {
                    builder.createOnStart(Boolean.parseBoolean(value));
                    continue block7;
                }
                case DROP_ON_EXIT: {
                    builder.dropOnExit(Boolean.parseBoolean(value));
                    continue block7;
                }
                case FETCH_SIZE: {
                    builder.fetchSize(Integer.parseInt(value));
                    continue block7;
                }
                case PREFIX: {
                    builder.tableNamePrefix(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        this.parseTableElements(reader, builder);
    }

    private void parseTableElements(XMLExtendedStreamReader reader, TableManipulationConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.idColumnName(column.name);
                    builder.idColumnType(column.type);
                    continue block6;
                }
                case DATA_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.dataColumnName(column.name);
                    builder.dataColumnType(column.type);
                    continue block6;
                }
                case TIMESTAMP_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.timestampColumnName(column.name);
                    builder.timestampColumnType(column.type);
                    continue block6;
                }
                case SEGMENT_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.segmentColumnName(column.name);
                    builder.segmentColumnType(column.type);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private Column parseTableElementAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        Column column = new Column();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    column.name = value;
                    continue block4;
                }
                case TYPE: {
                    column.type = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        return column;
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    class Column {
        String name;
        String type;

        Column() {
        }
    }
}

