/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.PageCache;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;

class PageCacheImpl
implements PageCache {
    private PagedMessage[] messages;
    private final long pageId;

    PageCacheImpl(long pageId) {
        this.pageId = pageId;
    }

    @Override
    public PagedMessage getMessage(PagePosition pagePosition) {
        if (pagePosition.getMessageNr() < this.messages.length) {
            return this.messages[pagePosition.getMessageNr()];
        }
        return null;
    }

    @Override
    public long getPageId() {
        return this.pageId;
    }

    @Override
    public void setMessages(PagedMessage[] messages) {
        this.messages = messages;
    }

    @Override
    public int getNumberOfMessages() {
        return this.messages.length;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isLive() {
        return false;
    }

    public String toString() {
        return "PageCacheImpl::page=" + this.pageId + " numberOfMessages = " + this.messages.length;
    }

    @Override
    public PagedMessage[] getMessages() {
        return this.messages;
    }
}

