/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.wildfly.core.launcher.Jvm;
import org.wildfly.core.launcher.logger.LauncherMessages;

class Environment {
    private static final boolean MAC;
    private static final boolean WINDOWS;
    static final String HOME_DIR = "jboss.home.dir";
    static final String MODULES_JAR_NAME = "jboss-modules.jar";
    private final Path wildflyHome;
    private Jvm jvm;
    private final List<String> modulesDirs;
    private boolean addDefaultModuleDir;

    Environment(String wildflyHome) {
        this(Environment.validateWildFlyDir(wildflyHome));
    }

    Environment(Path wildflyHome) {
        this.wildflyHome = Environment.validateWildFlyDir(wildflyHome);
        this.modulesDirs = new ArrayList<String>();
        this.addDefaultModuleDir = true;
        this.jvm = Jvm.current();
    }

    public Path getWildflyHome() {
        return this.wildflyHome;
    }

    public Path getModuleJar() {
        return this.resolvePath(MODULES_JAR_NAME);
    }

    public void addModuleDir(String moduleDir) {
        if (moduleDir == null) {
            throw LauncherMessages.MESSAGES.nullParam("moduleDir");
        }
        Path path = Paths.get(moduleDir, new String[0]).normalize();
        this.modulesDirs.add(path.toString());
    }

    public void addModuleDirs(String ... moduleDirs) {
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
    }

    public void addModuleDirs(Iterable<String> moduleDirs) {
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
    }

    public void setModuleDirs(Iterable<String> moduleDirs) {
        this.modulesDirs.clear();
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
        this.addDefaultModuleDir = false;
    }

    public void setModuleDirs(String ... moduleDirs) {
        this.modulesDirs.clear();
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
        this.addDefaultModuleDir = false;
    }

    public String getModulePaths() {
        StringBuilder result = new StringBuilder();
        if (this.addDefaultModuleDir) {
            result.append(this.wildflyHome.resolve("modules").toString());
        }
        if (!this.modulesDirs.isEmpty()) {
            if (this.addDefaultModuleDir) {
                result.append(File.pathSeparator);
            }
            Iterator<String> iterator = this.modulesDirs.iterator();
            while (iterator.hasNext()) {
                result.append(iterator.next());
                if (!iterator.hasNext()) continue;
                result.append(File.pathSeparator);
            }
        }
        return result.toString();
    }

    Jvm getJvm() {
        return this.jvm;
    }

    Environment setJvm(Jvm jvm) {
        this.jvm = jvm == null ? Jvm.current() : jvm;
        return this;
    }

    public Path resolvePath(String ... paths) {
        Path result = this.wildflyHome;
        for (String path : paths) {
            result = result.resolve(path);
        }
        return result;
    }

    public static boolean isMac() {
        return MAC;
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    static Path validateWildFlyDir(String wildflyHome) {
        if (wildflyHome == null) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(null);
        }
        return Environment.validateWildFlyDir(Paths.get(wildflyHome, new String[0]));
    }

    static Path validateWildFlyDir(Path wildflyHome) {
        if (wildflyHome == null || Files.notExists(wildflyHome, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(wildflyHome);
        }
        if (!Files.isDirectory(wildflyHome, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(wildflyHome);
        }
        Path result = wildflyHome.toAbsolutePath().normalize();
        if (Files.notExists(result.resolve(MODULES_JAR_NAME), new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(MODULES_JAR_NAME, wildflyHome);
        }
        return result;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        MAC = os.startsWith("mac");
        WINDOWS = os.contains("win");
    }
}

