/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityRolesAddingInterceptor
implements Interceptor {
    private final String category;
    private final Map<String, Set<String>> principalVsRolesMap;

    public SecurityRolesAddingInterceptor(String category, Map<String, Set<String>> principalVsRolesMap) {
        this.category = category;
        this.principalVsRolesMap = principalVsRolesMap;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        SecurityDomain securityDomain = (SecurityDomain)context.getPrivateData(SecurityDomain.class);
        Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        SecurityIdentity currentIdentity = securityDomain.getCurrentSecurityIdentity();
        Set<String> securityRoles = this.principalVsRolesMap.get(currentIdentity.getPrincipal().getName());
        if (securityRoles != null && !securityRoles.isEmpty()) {
            RoleMapper roleMapper = RoleMapper.constant((Roles)Roles.fromSet(securityRoles));
            RoleMapper mergeMapper = roleMapper.or(roles -> currentIdentity.getRoles(this.category));
            SecurityIdentity newIdentity = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(() -> currentIdentity.withRoleMapper(this.category, mergeMapper)) : currentIdentity.withRoleMapper(this.category, mergeMapper);
            try {
                return newIdentity.runAs((PrivilegedExceptionAction)context);
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    throw new RuntimeException(e);
                }
                throw e;
            }
        }
        return context.proceed();
    }
}

