/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.operations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import org.keycloak.client.admin.cli.util.Headers;
import org.keycloak.client.admin.cli.util.HeadersBody;
import org.keycloak.client.admin.cli.util.HeadersBodyStatus;
import org.keycloak.client.admin.cli.util.HttpUtil;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.util.JsonSerialization;

public class UserOperations {
    public static void addRealmRoles(String rootUrl, String realm, String auth, String userid, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/realm");
        HttpUtil.doPostJSON(resourceUrl, auth, roles);
    }

    public static void addClientRoles(String rootUrl, String realm, String auth, String userid, String idOfClient, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/clients/" + idOfClient);
        HttpUtil.doPostJSON(resourceUrl, auth, roles);
    }

    public static void removeRealmRoles(String rootUrl, String realm, String auth, String userid, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/realm");
        HttpUtil.doDeleteJSON(resourceUrl, auth, roles);
    }

    public static void removeClientRoles(String rootUrl, String realm, String auth, String userid, String idOfClient, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/clients/" + idOfClient);
        HttpUtil.doDeleteJSON(resourceUrl, auth, roles);
    }

    public static void resetUserPassword(String rootUrl, String realm, String auth, String userid, String password, boolean temporary) {
        HeadersBodyStatus response;
        byte[] body;
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/reset-password");
        Headers headers = new Headers();
        if (auth != null) {
            headers.add("Authorization", auth);
        }
        headers.add("Content-Type", "application/json");
        CredentialRepresentation credentials = new CredentialRepresentation();
        credentials.setType("password");
        credentials.setTemporary(temporary);
        credentials.setValue(password);
        try {
            body = JsonSerialization.writeValueAsBytes(credentials);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize JSON", e);
        }
        try {
            response = HttpUtil.doRequest("put", resourceUrl, new HeadersBody(headers, new ByteArrayInputStream(body)));
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP request failed: PUT " + resourceUrl + "\n" + new String(body), e);
        }
        response.checkSuccess();
    }

    public static String getIdFromUsername(String rootUrl, String realm, String auth, String username) {
        return HttpUtil.getIdForType(rootUrl, realm, auth, "users", "username", username, "username");
    }
}

