/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OIDCResponseType {
    public static final String CODE = "code";
    public static final String TOKEN = "token";
    public static final String ID_TOKEN = "id_token";
    public static final String NONE = "none";
    private static final List<String> ALLOWED_RESPONSE_TYPES = Arrays.asList("code", "token", "id_token", "none");
    private final List<String> responseTypes;

    private OIDCResponseType(List<String> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public static OIDCResponseType parse(String responseTypeParam) {
        if (responseTypeParam == null) {
            throw new IllegalArgumentException("response_type is null");
        }
        String[] responseTypes = responseTypeParam.trim().split(" ");
        ArrayList<String> allowedTypes = new ArrayList<String>();
        for (String current : responseTypes) {
            if (!ALLOWED_RESPONSE_TYPES.contains(current)) {
                throw new IllegalArgumentException("Unsupported response_type");
            }
            allowedTypes.add(current);
        }
        OIDCResponseType.validateAllowedTypes(allowedTypes);
        return new OIDCResponseType(allowedTypes);
    }

    public static OIDCResponseType parse(List<String> responseTypes) {
        OIDCResponseType result = new OIDCResponseType(new ArrayList<String>());
        for (String respType : responseTypes) {
            OIDCResponseType responseType = OIDCResponseType.parse(respType);
            result.responseTypes.addAll(responseType.responseTypes);
        }
        return result;
    }

    private static void validateAllowedTypes(List<String> responseTypes) {
        if (responseTypes.size() == 0) {
            throw new IllegalStateException("No responseType provided");
        }
        if (responseTypes.contains(NONE) && responseTypes.size() > 1) {
            throw new IllegalArgumentException("'None' not allowed with some other response_type");
        }
    }

    public boolean hasResponseType(String responseType) {
        return this.responseTypes.contains(responseType);
    }

    public boolean isImplicitOrHybridFlow() {
        return this.hasResponseType(TOKEN) || this.hasResponseType(ID_TOKEN);
    }

    public boolean isImplicitFlow() {
        return (this.hasResponseType(TOKEN) || this.hasResponseType(ID_TOKEN)) && !this.hasResponseType(CODE);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String responseType : this.responseTypes) {
            if (!first) {
                builder.append(" ");
            } else {
                first = false;
            }
            builder.append(responseType);
        }
        return builder.toString();
    }
}

