/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;

public class ClientScopesClientRegistrationPolicy
implements ClientRegistrationPolicy {
    private static final Logger logger = Logger.getLogger(ClientScopesClientRegistrationPolicy.class);
    private final KeycloakSession session;
    private final RealmModel realm;
    private final ComponentModel componentModel;

    public ClientScopesClientRegistrationPolicy(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
        this.realm = session.realms().getRealm(componentModel.getParentId());
    }

    @Override
    public void beforeRegister(ClientRegistrationContext context) throws ClientRegistrationPolicyException {
        List requestedDefaultScopeNames = context.getClient().getDefaultClientScopes();
        List requestedOptionalScopeNames = context.getClient().getOptionalClientScopes();
        List<String> allowedDefaultScopeNames = this.getAllowedScopeNames(this.realm, true);
        List<String> allowedOptionalScopeNames = this.getAllowedScopeNames(this.realm, false);
        this.checkClientScopesAllowed(requestedDefaultScopeNames, allowedDefaultScopeNames);
        this.checkClientScopesAllowed(requestedOptionalScopeNames, allowedOptionalScopeNames);
    }

    @Override
    public void afterRegister(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeUpdate(ClientRegistrationContext context, ClientModel clientModel) throws ClientRegistrationPolicyException {
        List requestedDefaultScopeNames = context.getClient().getDefaultClientScopes();
        List requestedOptionalScopeNames = context.getClient().getOptionalClientScopes();
        if (requestedDefaultScopeNames != null) {
            requestedDefaultScopeNames.removeAll(clientModel.getClientScopes(true, false).keySet());
        }
        if (requestedOptionalScopeNames != null) {
            requestedOptionalScopeNames.removeAll(clientModel.getClientScopes(false, false).keySet());
        }
        List<String> allowedDefaultScopeNames = this.getAllowedScopeNames(this.realm, true);
        List<String> allowedOptionalScopeNames = this.getAllowedScopeNames(this.realm, false);
        this.checkClientScopesAllowed(requestedDefaultScopeNames, allowedDefaultScopeNames);
        this.checkClientScopesAllowed(requestedOptionalScopeNames, allowedOptionalScopeNames);
    }

    @Override
    public void afterUpdate(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeView(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }

    @Override
    public void beforeDelete(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }

    private void checkClientScopesAllowed(List<String> requestedScopes, List<String> allowedScopes) throws ClientRegistrationPolicyException {
        if (requestedScopes != null) {
            for (String requested : requestedScopes) {
                if (allowedScopes.contains(requested)) continue;
                logger.warnf("Requested scope '%s' not trusted in the list: %s", (Object)requested, (Object)allowedScopes.toString());
                throw new ClientRegistrationPolicyException("Not permitted to use specified clientScope");
            }
        }
    }

    private List<String> getAllowedScopeNames(RealmModel realm, boolean defaultScopes) {
        boolean allowDefaultScopes;
        LinkedList<String> allAllowed = new LinkedList<String>();
        List allowedScopesConfig = this.componentModel.getConfig().getList((Object)"allowed-client-scopes");
        if (allowedScopesConfig != null) {
            allAllowed.addAll(allowedScopesConfig);
        }
        if (allowDefaultScopes = this.componentModel.get("allow-default-scopes", true)) {
            allAllowed.addAll(realm.getDefaultClientScopesStream(defaultScopes).map(ClientScopeModel::getName).collect(Collectors.toList()));
        }
        return allAllowed;
    }
}

