/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.ClientModelIdentity;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.common.UserModelIdentity;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.resources.admin.permissions.Helper;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;
import org.keycloak.services.resources.admin.permissions.UserPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.UserPermissionManagement;

class UserPermissions
implements UserPermissionEvaluator,
UserPermissionManagement {
    private static final String MAP_ROLES_SCOPE = "map-roles";
    private static final String IMPERSONATE_SCOPE = "impersonate";
    private static final String USER_IMPERSONATED_SCOPE = "user-impersonated";
    private static final String MANAGE_GROUP_MEMBERSHIP_SCOPE = "manage-group-membership";
    private static final String MAP_ROLES_PERMISSION_USERS = "map-roles.permission.users";
    private static final String ADMIN_IMPERSONATING_PERMISSION = "admin-impersonating.permission.users";
    private static final String USER_IMPERSONATED_PERMISSION = "user-impersonated.permission.users";
    private static final String MANAGE_GROUP_MEMBERSHIP_PERMISSION_USERS = "manage-group-membership.permission.users";
    private static final String MANAGE_PERMISSION_USERS = "manage.permission.users";
    private static final String VIEW_PERMISSION_USERS = "view.permission.users";
    private static final String USERS_RESOURCE = "Users";
    private final KeycloakSession session;
    private final AuthorizationProvider authz;
    private final MgmtPermissions root;
    private final PolicyStore policyStore;
    private final ResourceStore resourceStore;
    private boolean grantIfNoPermission = false;

    UserPermissions(KeycloakSession session, AuthorizationProvider authz, MgmtPermissions root) {
        this.session = session;
        this.authz = authz;
        this.root = root;
        this.policyStore = authz.getStoreFactory().getPolicyStore();
        this.resourceStore = authz.getStoreFactory().getResourceStore();
    }

    private void initialize() {
        Policy impersonatePermission;
        Policy membershipPermission;
        Policy mapRolesPermission;
        Policy viewPermission;
        Policy managePermission;
        this.root.initializeRealmResourceServer();
        this.root.initializeRealmDefaultScopes();
        ResourceServer server = this.root.realmResourceServer();
        Scope manageScope = this.root.realmManageScope();
        Scope viewScope = this.root.realmViewScope();
        Scope mapRolesScope = this.root.initializeRealmScope(MAP_ROLES_SCOPE);
        Scope impersonateScope = this.root.initializeRealmScope(IMPERSONATE_SCOPE);
        Scope userImpersonatedScope = this.root.initializeRealmScope(USER_IMPERSONATED_SCOPE);
        Scope manageGroupMembershipScope = this.root.initializeRealmScope(MANAGE_GROUP_MEMBERSHIP_SCOPE);
        Resource usersResource = this.resourceStore.findByName(USERS_RESOURCE, server.getId());
        if (usersResource == null) {
            usersResource = this.resourceStore.create(USERS_RESOURCE, server, server.getId());
            HashSet<Scope> scopeset = new HashSet<Scope>();
            scopeset.add(manageScope);
            scopeset.add(viewScope);
            scopeset.add(mapRolesScope);
            scopeset.add(impersonateScope);
            scopeset.add(manageGroupMembershipScope);
            scopeset.add(userImpersonatedScope);
            usersResource.updateScopes(scopeset);
        }
        if ((managePermission = this.policyStore.findByName(MANAGE_PERMISSION_USERS, server.getId())) == null) {
            Helper.addEmptyScopePermission(this.authz, server, MANAGE_PERMISSION_USERS, usersResource, manageScope);
        }
        if ((viewPermission = this.policyStore.findByName(VIEW_PERMISSION_USERS, server.getId())) == null) {
            Helper.addEmptyScopePermission(this.authz, server, VIEW_PERMISSION_USERS, usersResource, viewScope);
        }
        if ((mapRolesPermission = this.policyStore.findByName(MAP_ROLES_PERMISSION_USERS, server.getId())) == null) {
            Helper.addEmptyScopePermission(this.authz, server, MAP_ROLES_PERMISSION_USERS, usersResource, mapRolesScope);
        }
        if ((membershipPermission = this.policyStore.findByName(MANAGE_GROUP_MEMBERSHIP_PERMISSION_USERS, server.getId())) == null) {
            Helper.addEmptyScopePermission(this.authz, server, MANAGE_GROUP_MEMBERSHIP_PERMISSION_USERS, usersResource, manageGroupMembershipScope);
        }
        if ((impersonatePermission = this.policyStore.findByName(ADMIN_IMPERSONATING_PERMISSION, server.getId())) == null) {
            Helper.addEmptyScopePermission(this.authz, server, ADMIN_IMPERSONATING_PERMISSION, usersResource, impersonateScope);
        }
        if ((impersonatePermission = this.policyStore.findByName(USER_IMPERSONATED_PERMISSION, server.getId())) == null) {
            Helper.addEmptyScopePermission(this.authz, server, USER_IMPERSONATED_PERMISSION, usersResource, userImpersonatedScope);
        }
    }

    @Override
    public Map<String, String> getPermissions() {
        this.initialize();
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        scopes.put("view", this.viewPermission().getId());
        scopes.put("manage", this.managePermission().getId());
        scopes.put(MAP_ROLES_SCOPE, this.mapRolesPermission().getId());
        scopes.put(MANAGE_GROUP_MEMBERSHIP_SCOPE, this.manageGroupMembershipPermission().getId());
        scopes.put(IMPERSONATE_SCOPE, this.adminImpersonatingPermission().getId());
        scopes.put(USER_IMPERSONATED_SCOPE, this.userImpersonatedPermission().getId());
        return scopes;
    }

    @Override
    public boolean isPermissionsEnabled() {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resource = this.resourceStore.findByName(USERS_RESOURCE, server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.managePermission();
        return policy != null;
    }

    @Override
    public void setPermissionsEnabled(boolean enable) {
        if (enable) {
            this.initialize();
        } else {
            this.deletePermissionSetup();
        }
    }

    public boolean canManageDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS);
    }

    @Override
    public Resource resource() {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        return this.resourceStore.findByName(USERS_RESOURCE, server.getId());
    }

    @Override
    public Policy managePermission() {
        return this.policyStore.findByName(MANAGE_PERMISSION_USERS, this.root.realmResourceServer().getId());
    }

    @Override
    public Policy viewPermission() {
        return this.policyStore.findByName(VIEW_PERMISSION_USERS, this.root.realmResourceServer().getId());
    }

    @Override
    public Policy manageGroupMembershipPermission() {
        return this.policyStore.findByName(MANAGE_GROUP_MEMBERSHIP_PERMISSION_USERS, this.root.realmResourceServer().getId());
    }

    @Override
    public Policy mapRolesPermission() {
        return this.policyStore.findByName(MAP_ROLES_PERMISSION_USERS, this.root.realmResourceServer().getId());
    }

    @Override
    public Policy adminImpersonatingPermission() {
        return this.policyStore.findByName(ADMIN_IMPERSONATING_PERMISSION, this.root.realmResourceServer().getId());
    }

    @Override
    public Policy userImpersonatedPermission() {
        return this.policyStore.findByName(USER_IMPERSONATED_PERMISSION, this.root.realmResourceServer().getId());
    }

    @Override
    public boolean canManage() {
        if (this.canManageDefault()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        return this.hasPermission("manage");
    }

    @Override
    public void requireManage() {
        if (!this.canManage()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManage(UserModel user) {
        return this.canManage() || this.canManageByGroup(user);
    }

    @Override
    public void requireManage(UserModel user) {
        if (!this.canManage(user)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canQuery() {
        return this.canView() || this.root.hasOneAdminRole(AdminRoles.QUERY_USERS);
    }

    @Override
    public void requireQuery() {
        if (!this.canQuery()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView() {
        if (this.canViewDefault() || this.canManageDefault()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        return this.hasPermission("view", "manage");
    }

    @Override
    public boolean canView(UserModel user) {
        return this.canView() || this.canViewByGroup(user);
    }

    @Override
    public void requireView(UserModel user) {
        if (!this.canView(user)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireView() {
        if (!this.canView()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canClientImpersonate(final ClientModel client, UserModel user) {
        ClientModelIdentity identity = new ClientModelIdentity(this.session, client);
        DefaultEvaluationContext context = new DefaultEvaluationContext(identity, this.session){

            @Override
            public Map<String, Collection<String>> getBaseAttributes() {
                Map<String, Collection<String>> attributes = super.getBaseAttributes();
                attributes.put("kc.client.id", Arrays.asList(client.getClientId()));
                return attributes;
            }
        };
        return this.canImpersonate(context) && this.isImpersonatable(user);
    }

    @Override
    public boolean canImpersonate(UserModel user) {
        if (!this.canImpersonate()) {
            return false;
        }
        return this.isImpersonatable(user);
    }

    @Override
    public boolean isImpersonatable(UserModel user) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return true;
        }
        Resource resource = this.resourceStore.findByName(USERS_RESOURCE, server.getId());
        if (resource == null) {
            return true;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(USER_IMPERSONATED_PERMISSION, server.getId());
        if (policy == null) {
            return true;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return true;
        }
        return this.hasPermission(new DefaultEvaluationContext(new UserModelIdentity(this.root.realm, user), this.session), USER_IMPERSONATED_SCOPE);
    }

    @Override
    public boolean canImpersonate() {
        if (this.root.hasOneAdminRole(ImpersonationConstants.IMPERSONATION_ROLE)) {
            return true;
        }
        Identity identity = this.root.identity;
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        return this.canImpersonate(new DefaultEvaluationContext(identity, this.session));
    }

    @Override
    public void requireImpersonate(UserModel user) {
        if (!this.canImpersonate(user)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public Map<String, Boolean> getAccess(UserModel user) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("view", this.canView(user));
        map.put("manage", this.canManage(user));
        map.put("mapRoles", this.canMapRoles(user));
        map.put("manageGroupMembership", this.canManageGroupMembership(user));
        map.put(IMPERSONATE_SCOPE, this.canImpersonate(user));
        return map;
    }

    @Override
    public boolean canMapRoles(UserModel user) {
        if (this.canManage(user)) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        return this.hasPermission(MAP_ROLES_SCOPE);
    }

    @Override
    public void requireMapRoles(UserModel user) {
        if (!this.canMapRoles(user)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageGroupMembership(UserModel user) {
        if (this.canManage(user)) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        return this.hasPermission(MANAGE_GROUP_MEMBERSHIP_SCOPE);
    }

    @Override
    public void grantIfNoPermission(boolean grantIfNoPermission) {
        this.grantIfNoPermission = grantIfNoPermission;
    }

    @Override
    public void requireManageGroupMembership(UserModel user) {
        if (!this.canManageGroupMembership(user)) {
            throw new ForbiddenException();
        }
    }

    private boolean hasPermission(String ... scopes) {
        return this.hasPermission((EvaluationContext)null, scopes);
    }

    private boolean hasPermission(EvaluationContext context, String ... scopes) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resource = this.resourceStore.findByName(USERS_RESOURCE, server.getId());
        List<String> expectedScopes = Arrays.asList(scopes);
        if (resource == null) {
            return this.grantIfNoPermission && expectedScopes.contains("manage") && expectedScopes.contains("view");
        }
        Collection<Permission> permissions = context == null ? this.root.evaluatePermission(new ResourcePermission(resource, (Collection)resource.getScopes(), server), server) : this.root.evaluatePermission(new ResourcePermission(resource, (Collection)resource.getScopes(), server), server, context);
        for (Permission permission : permissions) {
            for (String scope : permission.getScopes()) {
                if (!expectedScopes.contains(scope)) continue;
                return true;
            }
        }
        return false;
    }

    private void deletePermissionSetup() {
        Resource usersResource;
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return;
        }
        Policy policy = this.managePermission();
        if (policy != null) {
            this.policyStore.delete(policy.getId());
        }
        if ((policy = this.viewPermission()) != null) {
            this.policyStore.delete(policy.getId());
        }
        if ((policy = this.mapRolesPermission()) != null) {
            this.policyStore.delete(policy.getId());
        }
        if ((policy = this.manageGroupMembershipPermission()) != null) {
            this.policyStore.delete(policy.getId());
        }
        if ((policy = this.adminImpersonatingPermission()) != null) {
            this.policyStore.delete(policy.getId());
        }
        if ((policy = this.userImpersonatedPermission()) != null) {
            this.policyStore.delete(policy.getId());
        }
        if ((usersResource = this.resourceStore.findByName(USERS_RESOURCE, server.getId())) != null) {
            this.resourceStore.delete(usersResource.getId());
        }
    }

    private boolean canImpersonate(EvaluationContext context) {
        return this.hasPermission(context, IMPERSONATE_SCOPE);
    }

    private boolean evaluateHierarchy(UserModel user, Predicate<GroupModel> eval) {
        HashSet visited = new HashSet();
        return user.getGroupsStream().anyMatch(group -> this.evaluateHierarchy(eval, (GroupModel)group, visited));
    }

    private boolean evaluateHierarchy(Predicate<GroupModel> eval, GroupModel group, Set<GroupModel> visited) {
        if (visited.contains(group)) {
            return false;
        }
        if (eval.test(group)) {
            return true;
        }
        visited.add(group);
        if (group.getParent() == null) {
            return false;
        }
        return this.evaluateHierarchy(eval, group.getParent(), visited);
    }

    private boolean canManageByGroup(UserModel user) {
        return this.evaluateHierarchy(user, group -> this.root.groups().canManageMembers((GroupModel)group));
    }

    private boolean canViewByGroup(UserModel user) {
        return this.evaluateHierarchy(user, group -> this.root.groups().getGroupsWithViewPermission((GroupModel)group));
    }

    public boolean canViewDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS, AdminRoles.VIEW_USERS);
    }
}

