/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class ClientAddedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String clientUuid;
    private String clientId;
    private String realmId;

    public static ClientAddedEvent create(String clientUuid, String clientId, String realmId) {
        ClientAddedEvent event = new ClientAddedEvent();
        event.clientUuid = clientUuid;
        event.clientId = clientId;
        event.realmId = realmId;
        return event;
    }

    @Override
    public String getId() {
        return this.clientUuid;
    }

    public String toString() {
        return String.format("ClientAddedEvent [ realmId=%s, clientUuid=%s, clientId=%s ]", this.realmId, this.clientUuid, this.clientId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.clientAdded(this.realmId, this.clientUuid, this.clientId, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<ClientAddedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ClientAddedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.clientUuid, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.clientId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
        }

        public ClientAddedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ClientAddedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ClientAddedEvent res = new ClientAddedEvent();
            res.clientUuid = MarshallUtil.unmarshallString((ObjectInput)input);
            res.clientId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

