/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.session.PersistentClientSessionEntity;
import org.keycloak.models.jpa.session.PersistentUserSessionEntity;
import org.keycloak.models.session.PersistentAuthenticatedClientSessionAdapter;
import org.keycloak.models.session.PersistentClientSessionModel;
import org.keycloak.models.session.PersistentUserSessionAdapter;
import org.keycloak.models.session.PersistentUserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.storage.StorageId;
import org.keycloak.utils.StreamsUtil;

public class JpaUserSessionPersisterProvider
implements UserSessionPersisterProvider {
    private static final Logger logger = Logger.getLogger(JpaUserSessionPersisterProvider.class);
    private final KeycloakSession session;
    private final EntityManager em;

    public JpaUserSessionPersisterProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void createUserSession(UserSessionModel userSession, boolean offline) {
        PersistentUserSessionAdapter adapter = new PersistentUserSessionAdapter(userSession);
        PersistentUserSessionModel model = adapter.getUpdatedModel();
        PersistentUserSessionEntity entity = new PersistentUserSessionEntity();
        entity.setUserSessionId(model.getUserSessionId());
        entity.setCreatedOn(model.getStarted());
        entity.setRealmId(adapter.getRealm().getId());
        entity.setUserId(adapter.getUser().getId());
        String offlineStr = this.offlineToString(offline);
        entity.setOffline(offlineStr);
        entity.setLastSessionRefresh(model.getLastSessionRefresh());
        entity.setData(model.getData());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void createClientSession(AuthenticatedClientSessionModel clientSession, boolean offline) {
        PersistentAuthenticatedClientSessionAdapter adapter = new PersistentAuthenticatedClientSessionAdapter(this.session, clientSession);
        PersistentClientSessionModel model = adapter.getUpdatedModel();
        PersistentClientSessionEntity entity = new PersistentClientSessionEntity();
        StorageId clientStorageId = new StorageId(clientSession.getClient().getId());
        if (clientStorageId.isLocal()) {
            entity.setClientId(clientStorageId.getId());
            entity.setClientStorageProvider("local");
            entity.setExternalClientId("local");
        } else {
            entity.setClientId("external");
            entity.setClientStorageProvider(clientStorageId.getProviderId());
            entity.setExternalClientId(clientStorageId.getExternalId());
        }
        entity.setTimestamp(clientSession.getTimestamp());
        String offlineStr = this.offlineToString(offline);
        entity.setOffline(offlineStr);
        entity.setUserSessionId(clientSession.getUserSession().getId());
        entity.setData(model.getData());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void removeUserSession(String userSessionId, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        this.em.createNamedQuery("deleteClientSessionsByUserSession").setParameter("userSessionId", (Object)userSessionId).setParameter("offline", (Object)offlineStr).executeUpdate();
        PersistentUserSessionEntity sessionEntity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(userSessionId, offlineStr), LockModeType.PESSIMISTIC_WRITE);
        if (sessionEntity != null) {
            this.em.remove((Object)sessionEntity);
            this.em.flush();
        }
    }

    public void removeClientSession(String userSessionId, String clientUUID, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        StorageId clientStorageId = new StorageId(clientUUID);
        String clientId = "external";
        String clientStorageProvider = "local";
        String externalId = "local";
        if (clientStorageId.isLocal()) {
            clientId = clientUUID;
        } else {
            clientStorageProvider = clientStorageId.getProviderId();
            externalId = clientStorageId.getExternalId();
        }
        PersistentClientSessionEntity sessionEntity = (PersistentClientSessionEntity)this.em.find(PersistentClientSessionEntity.class, (Object)new PersistentClientSessionEntity.Key(userSessionId, clientId, clientStorageProvider, externalId, offlineStr), LockModeType.PESSIMISTIC_WRITE);
        if (sessionEntity != null) {
            this.em.remove((Object)sessionEntity);
            List<PersistentClientSessionEntity> clientSessions = this.getClientSessionsByUserSession(sessionEntity.getUserSessionId(), offline);
            if (clientSessions.size() == 0) {
                offlineStr = this.offlineToString(offline);
                PersistentUserSessionEntity userSessionEntity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(sessionEntity.getUserSessionId(), offlineStr), LockModeType.PESSIMISTIC_WRITE);
                if (userSessionEntity != null) {
                    this.em.remove((Object)userSessionEntity);
                }
            }
            this.em.flush();
        }
    }

    private List<PersistentClientSessionEntity> getClientSessionsByUserSession(String userSessionId, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        TypedQuery query = this.em.createNamedQuery("findClientSessionsByUserSession", PersistentClientSessionEntity.class);
        query.setParameter("userSessionId", (Object)userSessionId);
        query.setParameter("offline", (Object)offlineStr);
        return query.getResultList();
    }

    public void onRealmRemoved(RealmModel realm) {
        int deletedClientSessions = this.em.createNamedQuery("deleteClientSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        int deletedUserSessions = this.em.createNamedQuery("deleteUserSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.onClientRemoved(client.getId());
    }

    private void onClientRemoved(String clientUUID) {
        int num = 0;
        StorageId clientStorageId = new StorageId(clientUUID);
        num = clientStorageId.isLocal() ? this.em.createNamedQuery("deleteClientSessionsByClient").setParameter("clientId", (Object)clientUUID).executeUpdate() : this.em.createNamedQuery("deleteClientSessionsByExternalClient").setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId()).setParameter("externalClientId", (Object)clientStorageId.getExternalId()).executeUpdate();
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.onUserRemoved(realm, user.getId());
    }

    private void onUserRemoved(RealmModel realm, String userId) {
        int num = this.em.createNamedQuery("deleteClientSessionsByUser").setParameter("userId", (Object)userId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserSessionsByUser").setParameter("userId", (Object)userId).executeUpdate();
    }

    public void updateLastSessionRefreshes(RealmModel realm, int lastSessionRefresh, Collection<String> userSessionIds, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        int us = this.em.createNamedQuery("updateUserSessionLastSessionRefresh").setParameter("lastSessionRefresh", (Object)lastSessionRefresh).setParameter("realmId", (Object)realm.getId()).setParameter("offline", (Object)offlineStr).setParameter("userSessionIds", userSessionIds).executeUpdate();
        logger.debugf("Updated lastSessionRefresh of %d user sessions in realm '%s'", us, (Object)realm.getName());
    }

    public void removeExpired(RealmModel realm) {
        int expiredOffline;
        int expiredClientOffline = expiredOffline = Time.currentTime() - realm.getOfflineSessionIdleTimeout() - 180;
        if (realm.getClientOfflineSessionIdleTimeout() > 0) {
            expiredClientOffline = Time.currentTime() - realm.getClientOfflineSessionIdleTimeout() - 180;
        }
        String offlineStr = this.offlineToString(true);
        logger.tracef("Trigger removing expired user sessions for realm '%s'", (Object)realm.getName());
        int cs = this.em.createNamedQuery("deleteExpiredClientSessions").setParameter("realmId", (Object)realm.getId()).setParameter("lastSessionRefresh", (Object)expiredClientOffline).setParameter("offline", (Object)offlineStr).executeUpdate();
        int us = this.em.createNamedQuery("deleteExpiredUserSessions").setParameter("realmId", (Object)realm.getId()).setParameter("lastSessionRefresh", (Object)expiredOffline).setParameter("offline", (Object)offlineStr).executeUpdate();
        logger.debugf("Removed %d expired user sessions and %d expired client sessions in realm '%s'", us, cs, (Object)realm.getName());
    }

    public Map<String, Long> getUserSessionsCountsByClients(RealmModel realm, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        Query query = this.em.createNamedQuery("findUserSessionsCountsByClientId");
        query.setParameter("offline", (Object)offlineStr);
        query.setParameter("realmId", (Object)realm.getId());
        HashMap<String, Long> offlineSessionsByClient = new HashMap<String, Long>();
        StreamsUtil.closing((Stream)query.getResultStream()).forEach(record -> {
            Object[] row = (Object[])record;
            String clientId = String.valueOf(row[0]);
            Long count = ((Number)row[1]).longValue();
            offlineSessionsByClient.put(clientId, count);
        });
        return offlineSessionsByClient;
    }

    public UserSessionModel loadUserSession(RealmModel realm, String userSessionId, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        TypedQuery userSessionQuery = this.em.createNamedQuery("findUserSession", PersistentUserSessionEntity.class);
        userSessionQuery.setParameter("realmId", (Object)realm.getId());
        userSessionQuery.setParameter("offline", (Object)offlineStr);
        userSessionQuery.setParameter("userSessionId", (Object)userSessionId);
        userSessionQuery.setMaxResults(1);
        Stream persistentUserSessions = StreamsUtil.closing(userSessionQuery.getResultStream().map(this::toAdapter));
        return persistentUserSessions.findAny().map(userSession -> {
            TypedQuery clientSessionQuery = this.em.createNamedQuery("findClientSessionsByUserSession", PersistentClientSessionEntity.class);
            clientSessionQuery.setParameter("userSessionId", Collections.singleton(userSessionId));
            clientSessionQuery.setParameter("offline", (Object)offlineStr);
            HashSet removedClientUUIDs = new HashSet();
            StreamsUtil.closing((Stream)clientSessionQuery.getResultStream()).forEach(clientSession -> {
                boolean added = this.addClientSessionToAuthenticatedClientSessionsIfPresent((PersistentUserSessionAdapter)userSession, (PersistentClientSessionEntity)clientSession);
                if (!added) {
                    removedClientUUIDs.add(clientSession.getClientId());
                }
            });
            removedClientUUIDs.forEach(this::onClientRemoved);
            return userSession;
        }).orElse(null);
    }

    public Stream<UserSessionModel> loadUserSessionsStream(RealmModel realm, ClientModel client, boolean offline, Integer firstResult, Integer maxResults) {
        String offlineStr = this.offlineToString(offline);
        TypedQuery query = PaginationUtils.paginateQuery(this.em.createNamedQuery("findUserSessionsByClientId", PersistentUserSessionEntity.class), firstResult, maxResults);
        query.setParameter("offline", (Object)offlineStr);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("clientId", (Object)client.getId());
        return this.loadUserSessionsWithClientSessions(query, offlineStr);
    }

    public Stream<UserSessionModel> loadUserSessionsStream(RealmModel realm, UserModel user, boolean offline, Integer firstResult, Integer maxResults) {
        String offlineStr = this.offlineToString(offline);
        TypedQuery query = PaginationUtils.paginateQuery(this.em.createNamedQuery("findUserSessionsByUserId", PersistentUserSessionEntity.class), firstResult, maxResults);
        query.setParameter("offline", (Object)offlineStr);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("userId", (Object)user.getId());
        return this.loadUserSessionsWithClientSessions(query, offlineStr);
    }

    public Stream<UserSessionModel> loadUserSessionsStream(Integer firstResult, Integer maxResults, boolean offline, String lastUserSessionId) {
        String offlineStr = this.offlineToString(offline);
        TypedQuery query = PaginationUtils.paginateQuery(this.em.createNamedQuery("findUserSessionsOrderedById", PersistentUserSessionEntity.class).setParameter("offline", (Object)offlineStr).setParameter("lastSessionId", (Object)lastUserSessionId), firstResult, maxResults);
        return this.loadUserSessionsWithClientSessions(query, offlineStr);
    }

    private Stream<UserSessionModel> loadUserSessionsWithClientSessions(TypedQuery<PersistentUserSessionEntity> query, String offlineStr) {
        List userSessionAdapters = StreamsUtil.closing(query.getResultStream().map(this::toAdapter).filter(Objects::nonNull)).collect(Collectors.toList());
        Map sessionsById = userSessionAdapters.stream().collect(Collectors.toMap(UserSessionModel::getId, Function.identity()));
        HashSet removedClientUUIDs = new HashSet();
        if (!sessionsById.isEmpty()) {
            String fromUserSessionId = ((PersistentUserSessionAdapter)userSessionAdapters.get(0)).getId();
            String toUserSessionId = ((PersistentUserSessionAdapter)userSessionAdapters.get(userSessionAdapters.size() - 1)).getId();
            TypedQuery queryClientSessions = this.em.createNamedQuery("findClientSessionsOrderedById", PersistentClientSessionEntity.class);
            queryClientSessions.setParameter("offline", (Object)offlineStr);
            queryClientSessions.setParameter("fromSessionId", (Object)fromUserSessionId);
            queryClientSessions.setParameter("toSessionId", (Object)toUserSessionId);
            StreamsUtil.closing((Stream)queryClientSessions.getResultStream()).forEach(clientSession -> {
                boolean added;
                PersistentUserSessionAdapter userSession = (PersistentUserSessionAdapter)sessionsById.get(clientSession.getUserSessionId());
                if (userSession != null && !(added = this.addClientSessionToAuthenticatedClientSessionsIfPresent(userSession, (PersistentClientSessionEntity)clientSession))) {
                    removedClientUUIDs.add(clientSession.getClientId());
                }
            });
        }
        for (String clientUUID : removedClientUUIDs) {
            this.onClientRemoved(clientUUID);
        }
        return userSessionAdapters.stream().map(UserSessionModel.class::cast);
    }

    private boolean addClientSessionToAuthenticatedClientSessionsIfPresent(PersistentUserSessionAdapter userSession, PersistentClientSessionEntity clientSessionEntity) {
        PersistentAuthenticatedClientSessionAdapter clientSessAdapter = this.toAdapter(userSession.getRealm(), userSession, clientSessionEntity);
        if (clientSessAdapter.getClient() == null) {
            return false;
        }
        userSession.getAuthenticatedClientSessions().put(clientSessionEntity.getClientId(), clientSessAdapter);
        return true;
    }

    private PersistentUserSessionAdapter toAdapter(PersistentUserSessionEntity entity) {
        RealmModel realm = this.session.realms().getRealm(entity.getRealmId());
        if (realm == null) {
            return null;
        }
        return this.toAdapter(realm, entity);
    }

    private PersistentUserSessionAdapter toAdapter(RealmModel realm, PersistentUserSessionEntity entity) {
        PersistentUserSessionModel model = new PersistentUserSessionModel();
        model.setUserSessionId(entity.getUserSessionId());
        model.setStarted(entity.getCreatedOn());
        model.setLastSessionRefresh(entity.getLastSessionRefresh());
        model.setData(entity.getData());
        model.setOffline(this.offlineFromString(entity.getOffline()));
        HashMap clientSessions = new HashMap();
        return new PersistentUserSessionAdapter(this.session, model, realm, entity.getUserId(), clientSessions);
    }

    private PersistentAuthenticatedClientSessionAdapter toAdapter(RealmModel realm, PersistentUserSessionAdapter userSession, PersistentClientSessionEntity entity) {
        String clientId = entity.getClientId();
        if (!entity.getExternalClientId().equals("local")) {
            clientId = new StorageId(entity.getClientStorageProvider(), entity.getExternalClientId()).getId();
        }
        ClientModel client = realm.getClientById(clientId);
        PersistentClientSessionModel model = new PersistentClientSessionModel();
        model.setClientId(clientId);
        model.setUserSessionId(userSession.getId());
        model.setUserId(userSession.getUserId());
        model.setTimestamp(entity.getTimestamp());
        model.setData(entity.getData());
        return new PersistentAuthenticatedClientSessionAdapter(this.session, model, realm, client, (UserSessionModel)userSession);
    }

    public int getUserSessionsCount(boolean offline) {
        String offlineStr = this.offlineToString(offline);
        Query query = this.em.createNamedQuery("findUserSessionsCount");
        query.setParameter("offline", (Object)offlineStr);
        Number n = (Number)query.getSingleResult();
        return n.intValue();
    }

    public int getUserSessionsCount(RealmModel realm, ClientModel clientModel, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        Query query = this.em.createNamedQuery("findClientSessionsCountByClient");
        query.setParameter("offline", (Object)offlineStr);
        query.setParameter("clientId", (Object)clientModel.getId());
        Number n = (Number)query.getSingleResult();
        return n.intValue();
    }

    public void close() {
    }

    private String offlineToString(boolean offline) {
        return offline ? "1" : "0";
    }

    private boolean offlineFromString(String offlineStr) {
        return "1".equals(offlineStr);
    }
}

