/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jboss.aesh.edit.KeyOperation;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.terminal.Key;

public class KeyOperationManager {
    private final List<KeyOperation> operations = new ArrayList<KeyOperation>();

    public KeyOperationManager() {
    }

    public KeyOperationManager(List<KeyOperation> operations) {
        this.operations.addAll(operations);
    }

    public List<KeyOperation> getOperations() {
        return this.operations;
    }

    public void clear() {
        this.operations.clear();
    }

    public void addOperations(List<KeyOperation> newOperations) {
        for (KeyOperation ko : newOperations) {
            this.checkAndRemove(ko);
            this.operations.add(ko);
        }
    }

    public void addOperation(KeyOperation operation) {
        this.checkAndRemove(operation);
        this.operations.add(operation);
    }

    public void addOperationIgnoreWorkingMode(KeyOperation operation) {
        this.checkAndRemoveIgnoreWorkingMode(operation);
        this.operations.add(operation);
    }

    private boolean exists(KeyOperation operation) {
        for (KeyOperation ko : this.operations) {
            if (!Arrays.equals(ko.getKeyValues(), operation.getKeyValues())) continue;
            return true;
        }
        return false;
    }

    private void checkAndRemoveIgnoreWorkingMode(KeyOperation ko) {
        this.checkAndRemove(ko, true);
    }

    private void checkAndRemove(KeyOperation ko) {
        this.checkAndRemove(ko, false);
    }

    private void checkAndRemove(KeyOperation ko, boolean ignoreWorkingMode) {
        Iterator<KeyOperation> iter = this.operations.iterator();
        while (iter.hasNext()) {
            KeyOperation operation = iter.next();
            if (ignoreWorkingMode) {
                if (!Arrays.equals(operation.getKeyValues(), ko.getKeyValues())) continue;
                iter.remove();
                return;
            }
            if (!Arrays.equals(operation.getKeyValues(), ko.getKeyValues()) || !operation.getWorkingMode().equals((Object)ko.getWorkingMode())) continue;
            iter.remove();
            return;
        }
    }

    public KeyOperation findOperation(Key key) {
        for (KeyOperation operation : this.operations) {
            if (operation.getKey() != key) continue;
            return operation;
        }
        return null;
    }

    public KeyOperation findOperation(int[] input) {
        for (KeyOperation operation : this.operations) {
            if (!operation.getKey().equalTo(input)) continue;
            return operation;
        }
        return this.findOtherOperations(input);
    }

    private KeyOperation findOtherOperations(int[] input) {
        if (Key.startsWithEscape(input)) {
            if (Key.UP.inputStartsWithKey(input) && input.length % Key.UP.getKeyValues().length == 0) {
                return this.findOperation(Key.UP);
            }
            if (Key.UP_2.inputStartsWithKey(input) && input.length % Key.UP_2.getKeyValues().length == 0) {
                return this.findOperation(Key.UP_2);
            }
            if (Key.DOWN.inputStartsWithKey(input) && input.length % Key.DOWN.getKeyValues().length == 0) {
                return this.findOperation(Key.DOWN);
            }
            if (Key.DOWN_2.inputStartsWithKey(input) && input.length % Key.DOWN_2.getKeyValues().length == 0) {
                return this.findOperation(Key.DOWN_2);
            }
            if (Key.LEFT.inputStartsWithKey(input) && input.length % Key.LEFT.getKeyValues().length == 0) {
                return this.findOperation(Key.LEFT);
            }
            if (Key.LEFT_2.inputStartsWithKey(input) && input.length % Key.LEFT_2.getKeyValues().length == 0) {
                return this.findOperation(Key.LEFT_2);
            }
            if (Key.RIGHT.inputStartsWithKey(input) && input.length % Key.RIGHT.getKeyValues().length == 0) {
                return this.findOperation(Key.RIGHT);
            }
            if (Key.RIGHT_2.inputStartsWithKey(input) && input.length % Key.RIGHT_2.getKeyValues().length == 0) {
                return this.findOperation(Key.RIGHT_2);
            }
            return new KeyOperation(Key.ESC, Operation.NO_ACTION);
        }
        return null;
    }
}

