/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceCodeModel;
import org.keycloak.models.OAuth2DeviceTokenStoreProvider;
import org.keycloak.models.OAuth2DeviceUserCodeModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanOAuth2DeviceTokenStoreProvider
implements OAuth2DeviceTokenStoreProvider {
    public static final Logger logger = Logger.getLogger(InfinispanOAuth2DeviceTokenStoreProvider.class);
    private final Supplier<BasicCache<String, ActionTokenValueEntity>> codeCache;
    private final KeycloakSession session;

    public InfinispanOAuth2DeviceTokenStoreProvider(KeycloakSession session, Supplier<BasicCache<String, ActionTokenValueEntity>> actionKeyCache) {
        this.session = session;
        this.codeCache = actionKeyCache;
    }

    public OAuth2DeviceCodeModel getByDeviceCode(RealmModel realm, String deviceCode) {
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.codeCache.get();
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.get((Object)OAuth2DeviceCodeModel.createKey((String)deviceCode));
            if (existing == null) {
                return null;
            }
            return OAuth2DeviceCodeModel.fromCache((RealmModel)realm, (String)deviceCode, existing.getNotes());
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when getting device code %s", (Object)deviceCode);
            }
            return null;
        }
    }

    public void close() {
    }

    public void put(OAuth2DeviceCodeModel deviceCode, OAuth2DeviceUserCodeModel userCode, int lifespanSeconds) {
        ActionTokenValueEntity deviceCodeValue = new ActionTokenValueEntity(deviceCode.toMap());
        ActionTokenValueEntity userCodeValue = new ActionTokenValueEntity(userCode.serializeValue());
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.codeCache.get();
            cache.put((Object)deviceCode.serializeKey(), (Object)deviceCodeValue, (long)lifespanSeconds, TimeUnit.SECONDS);
            cache.put((Object)userCode.serializeKey(), (Object)userCodeValue, (long)lifespanSeconds, TimeUnit.SECONDS);
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when adding device code %s and user code %s", (Object)deviceCode.getDeviceCode(), (Object)userCode.getUserCode());
            }
            throw re;
        }
    }

    public boolean isPollingAllowed(OAuth2DeviceCodeModel deviceCode) {
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.codeCache.get();
            String key = deviceCode.serializePollingKey();
            ActionTokenValueEntity value = new ActionTokenValueEntity(null);
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.putIfAbsent((Object)key, (Object)value, (long)deviceCode.getPollingInterval(), TimeUnit.SECONDS);
            return existing == null;
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when putting polling key for device code %s", (Object)deviceCode.getDeviceCode());
            }
            return false;
        }
    }

    public OAuth2DeviceCodeModel getByUserCode(RealmModel realm, String userCode) {
        try {
            OAuth2DeviceCodeModel deviceCode = this.findDeviceCodeByUserCode(realm, userCode);
            if (deviceCode == null) {
                return null;
            }
            return deviceCode;
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when getting device code by user code %s", (Object)userCode);
            }
            return null;
        }
    }

    private OAuth2DeviceCodeModel findDeviceCodeByUserCode(RealmModel realm, String userCode) throws HotRodClientException {
        String userCodeKey;
        BasicCache<String, ActionTokenValueEntity> cache = this.codeCache.get();
        ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.get((Object)(userCodeKey = OAuth2DeviceUserCodeModel.createKey((RealmModel)realm, (String)userCode)));
        if (existing == null) {
            return null;
        }
        OAuth2DeviceUserCodeModel data = OAuth2DeviceUserCodeModel.fromCache((RealmModel)realm, (String)userCode, existing.getNotes());
        String deviceCode = data.getDeviceCode();
        String deviceCodeKey = OAuth2DeviceCodeModel.createKey((String)deviceCode);
        ActionTokenValueEntity existingDeviceCode = (ActionTokenValueEntity)cache.get((Object)deviceCodeKey);
        if (existingDeviceCode == null) {
            return null;
        }
        return OAuth2DeviceCodeModel.fromCache((RealmModel)realm, (String)deviceCode, existingDeviceCode.getNotes());
    }

    public boolean approve(RealmModel realm, String userCode, String userSessionId, Map<String, String> additionalParams) {
        try {
            OAuth2DeviceCodeModel deviceCode = this.findDeviceCodeByUserCode(realm, userCode);
            if (deviceCode == null) {
                return false;
            }
            OAuth2DeviceCodeModel approved = deviceCode.approve(userSessionId, additionalParams);
            BasicCache<String, ActionTokenValueEntity> cache = this.codeCache.get();
            cache.replace((Object)approved.serializeKey(), (Object)new ActionTokenValueEntity(approved.toMap()));
            return true;
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when verifying device user code %s", (Object)userCode);
            }
            return false;
        }
    }

    public boolean deny(RealmModel realm, String userCode) {
        try {
            OAuth2DeviceCodeModel deviceCode = this.findDeviceCodeByUserCode(realm, userCode);
            if (deviceCode == null) {
                return false;
            }
            OAuth2DeviceCodeModel denied = deviceCode.deny();
            BasicCache<String, ActionTokenValueEntity> cache = this.codeCache.get();
            cache.replace((Object)denied.serializeKey(), (Object)new ActionTokenValueEntity(denied.toMap()));
            return true;
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when denying device user code %s", (Object)userCode);
            }
            return false;
        }
    }

    public boolean removeDeviceCode(RealmModel realm, String deviceCode) {
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.codeCache.get();
            String key = OAuth2DeviceCodeModel.createKey((String)deviceCode);
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.remove((Object)key);
            return existing != null;
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when removing device code %s", (Object)deviceCode);
            }
            return false;
        }
    }

    public boolean removeUserCode(RealmModel realm, String userCode) {
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.codeCache.get();
            String key = OAuth2DeviceUserCodeModel.createKey((RealmModel)realm, (String)userCode);
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.remove((Object)key);
            return existing != null;
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when removing user code %s", (Object)userCode);
            }
            return false;
        }
    }
}

