/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.SamlArtifactSessionMappingModel;
import org.keycloak.models.SamlArtifactSessionMappingStoreProvider;

public class InfinispanSamlArtifactSessionMappingStoreProvider
implements SamlArtifactSessionMappingStoreProvider {
    public static final Logger logger = Logger.getLogger(InfinispanSamlArtifactSessionMappingStoreProvider.class);
    private final Supplier<BasicCache<UUID, String[]>> cacheSupplier;

    public InfinispanSamlArtifactSessionMappingStoreProvider(Supplier<BasicCache<UUID, String[]>> actionKeyCache) {
        this.cacheSupplier = actionKeyCache;
    }

    public void put(String artifact, int lifespanSeconds, AuthenticatedClientSessionModel clientSessionModel) {
        try {
            BasicCache<UUID, String[]> cache = this.cacheSupplier.get();
            long lifespanMs = InfinispanUtil.toHotrodTimeMs(cache, Time.toMillis((long)lifespanSeconds));
            cache.put((Object)UUID.nameUUIDFromBytes(artifact.getBytes(StandardCharsets.UTF_8)), (Object)new String[]{artifact, clientSessionModel.getUserSession().getId(), clientSessionModel.getClient().getId()}, lifespanMs, TimeUnit.MILLISECONDS);
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed adding artifact %s", (Object)artifact);
            }
            throw re;
        }
    }

    public SamlArtifactSessionMappingModel get(String artifact) {
        try {
            BasicCache<UUID, String[]> cache = this.cacheSupplier.get();
            String[] existing = (String[])cache.get((Object)UUID.nameUUIDFromBytes(artifact.getBytes(StandardCharsets.UTF_8)));
            if (existing == null || existing.length != 3) {
                return null;
            }
            if (!artifact.equals(existing[0])) {
                return null;
            }
            return new SamlArtifactSessionMappingModel(existing[1], existing[2]);
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when obtaining data for artifact %s", (Object)artifact);
            }
            return null;
        }
    }

    public void remove(String artifact) {
        block3: {
            try {
                BasicCache<UUID, String[]> cache = this.cacheSupplier.get();
                if (cache.remove((Object)UUID.nameUUIDFromBytes(artifact.getBytes(StandardCharsets.UTF_8))) == null) {
                    logger.debugf("Artifact %s was already removed", (Object)artifact);
                }
            }
            catch (HotRodClientException re) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debugf((Throwable)re, "Failed to remove artifact %s", (Object)artifact);
            }
        }
    }

    public void close() {
    }
}

