/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.AuthenticationSelectionOption;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.DefaultAuthenticationFlow;
import org.keycloak.authentication.FormAuthenticator;
import org.keycloak.authentication.FormAuthenticatorFactory;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.RealmModel;

class AuthenticationSelectionResolver {
    private static final Logger logger = Logger.getLogger(AuthenticationSelectionResolver.class);

    AuthenticationSelectionResolver() {
    }

    static List<AuthenticationSelectionOption> createAuthenticationSelectionList(AuthenticationProcessor processor, AuthenticationExecutionModel model) {
        List<Object> authenticationSelectionList = new ArrayList<AuthenticationSelectionOption>();
        if (processor.getAuthenticationSession() != null) {
            HashMap<String, AuthenticationExecutionModel> typeAuthExecMap = new HashMap<String, AuthenticationExecutionModel>();
            ArrayList<AuthenticationExecutionModel> nonCredentialExecutions = new ArrayList<AuthenticationExecutionModel>();
            String topFlowId = AuthenticationSelectionResolver.getFlowIdOfTheHighestUsefulFlow(processor, model);
            if (topFlowId == null) {
                AuthenticationSelectionResolver.addSimpleAuthenticationExecution(processor, model, typeAuthExecMap, nonCredentialExecutions);
            } else {
                AuthenticationSelectionResolver.addAllExecutionsFromSubflow(processor, topFlowId, typeAuthExecMap, nonCredentialExecutions);
            }
            if (processor.getAuthenticationSession().getAuthenticatedUser() != null) {
                authenticationSelectionList = Stream.concat(processor.getSession().userCredentialManager().getStoredCredentialsStream(processor.getRealm(), processor.getAuthenticationSession().getAuthenticatedUser()).map(CredentialModel::getType), processor.getSession().userCredentialManager().getConfiguredUserStorageCredentialTypesStream(processor.getRealm(), processor.getAuthenticationSession().getAuthenticatedUser())).distinct().filter(typeAuthExecMap::containsKey).map(credentialType -> new AuthenticationSelectionOption(processor.getSession(), (AuthenticationExecutionModel)typeAuthExecMap.get(credentialType))).collect(Collectors.toList());
            }
            for (AuthenticationExecutionModel exec : nonCredentialExecutions) {
                authenticationSelectionList.add(new AuthenticationSelectionOption(processor.getSession(), exec));
            }
        }
        logger.debugf("Selections when trying execution '%s' : %s", (Object)model.getAuthenticator(), authenticationSelectionList);
        return authenticationSelectionList;
    }

    private static String getFlowIdOfTheHighestUsefulFlow(AuthenticationProcessor processor, AuthenticationExecutionModel execution) {
        String flowId = null;
        RealmModel realm = processor.getRealm();
        while (true) {
            if (execution.isAlternative()) {
                flowId = execution.getParentFlow();
            } else if (execution.isRequired() || execution.isConditional()) {
                List executions;
                int executionIndex;
                if (execution.isAuthenticatorFlow()) {
                    flowId = execution.getFlowId();
                }
                if ((executionIndex = (executions = realm.getAuthenticationExecutionsStream(execution.getParentFlow()).collect(Collectors.toList())).indexOf(execution)) != 0) {
                    return flowId;
                }
                flowId = execution.getParentFlow();
            }
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(flowId);
            if (flow.isTopLevel()) {
                return flowId;
            }
            execution = realm.getAuthenticationExecutionByFlowId(flowId);
        }
    }

    private static void addSimpleAuthenticationExecution(AuthenticationProcessor processor, AuthenticationExecutionModel execution, Map<String, AuthenticationExecutionModel> typeAuthExecMap, List<AuthenticationExecutionModel> nonCredentialExecutions) {
        if (DefaultAuthenticationFlow.isProcessed(processor, execution)) {
            return;
        }
        Authenticator localAuthenticator = (Authenticator)processor.getSession().getProvider(Authenticator.class, execution.getAuthenticator());
        if (!(localAuthenticator instanceof CredentialValidator)) {
            nonCredentialExecutions.add(execution);
        } else {
            CredentialValidator cv = (CredentialValidator)localAuthenticator;
            typeAuthExecMap.put(cv.getType(processor.getSession()), execution);
        }
    }

    private static boolean addAllExecutionsFromSubflow(AuthenticationProcessor processor, String flowId, Map<String, AuthenticationExecutionModel> typeAuthExecMap, List<AuthenticationExecutionModel> nonCredentialExecutions) {
        AuthenticationFlowModel flowModel = processor.getRealm().getAuthenticationFlowById(flowId);
        if (flowModel == null) {
            throw new AuthenticationFlowException("Flow not found", AuthenticationFlowError.INTERNAL_ERROR);
        }
        DefaultAuthenticationFlow flow = new DefaultAuthenticationFlow(processor, flowModel);
        logger.debugf("Going through the flow '%s' for adding executions", (Object)flowModel.getAlias());
        ArrayList<AuthenticationExecutionModel> requiredList = new ArrayList<AuthenticationExecutionModel>();
        ArrayList<AuthenticationExecutionModel> alternativeList = new ArrayList<AuthenticationExecutionModel>();
        flow.fillListsOfExecutions(processor.getRealm().getAuthenticationExecutionsStream(flowId), requiredList, alternativeList);
        if (!requiredList.isEmpty()) {
            AuthenticationExecutionModel requiredExecution = requiredList.stream().filter(ex -> {
                if (ex.isRequired()) {
                    return true;
                }
                return !flow.isConditionalSubflowDisabled((AuthenticationExecutionModel)ex);
            }).findFirst().orElse(null);
            if (requiredExecution == null) {
                return false;
            }
            if (flow.isProcessed(requiredExecution)) {
                return false;
            }
            FormAuthenticatorFactory factory = (FormAuthenticatorFactory)processor.getSession().getKeycloakSessionFactory().getProviderFactory(FormAuthenticator.class, requiredExecution.getAuthenticator());
            if (requiredExecution.isAuthenticatorFlow() && factory == null) {
                return AuthenticationSelectionResolver.addAllExecutionsFromSubflow(processor, requiredExecution.getFlowId(), typeAuthExecMap, nonCredentialExecutions);
            }
            AuthenticationSelectionResolver.addSimpleAuthenticationExecution(processor, requiredExecution, typeAuthExecMap, nonCredentialExecutions);
            return true;
        }
        boolean anyAdded = false;
        for (AuthenticationExecutionModel execution : alternativeList) {
            if (flow.isProcessed(execution)) continue;
            if (!execution.isAuthenticatorFlow()) {
                AuthenticationSelectionResolver.addSimpleAuthenticationExecution(processor, execution, typeAuthExecMap, nonCredentialExecutions);
                anyAdded = true;
                continue;
            }
            anyAdded |= AuthenticationSelectionResolver.addAllExecutionsFromSubflow(processor, execution.getFlowId(), typeAuthExecMap, nonCredentialExecutions);
        }
        return anyAdded;
    }
}

