/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.UpdateProfile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;

public class VerifyUserProfile
extends UpdateProfile {
    @Override
    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.NOT_SUPPORTED;
    }

    @Override
    protected UserModel.RequiredAction getResponseAction() {
        return UserModel.RequiredAction.VERIFY_PROFILE;
    }

    @Override
    public void evaluateTriggers(RequiredActionContext context) {
        UserModel user = context.getUser();
        UserProfileProvider provider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, user);
        try {
            profile.validate();
            context.getAuthenticationSession().removeRequiredAction(this.getId());
            user.removeRequiredAction(this.getId());
        }
        catch (ValidationException e) {
            context.getAuthenticationSession().addRequiredAction(this.getId());
        }
    }

    @Override
    public void requiredActionChallenge(RequiredActionContext context) {
        UserProfileProvider provider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, context.getUser());
        try {
            profile.validate();
            context.success();
        }
        catch (ValidationException ve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(ve.getErrors());
            Object parameters = context.getHttpRequest().getHttpMethod().equalsIgnoreCase("GET") ? new MultivaluedHashMap() : context.getHttpRequest().getDecodedFormParameters();
            context.challenge(this.createResponse(context, (MultivaluedMap<String, String>)parameters, errors));
            EventBuilder event = context.getEvent().clone();
            event.event(EventType.VERIFY_PROFILE);
            event.detail("fields_to_update", this.collectFields(errors));
            event.success();
        }
    }

    private String collectFields(List<FormMessage> errors) {
        return errors.stream().map(FormMessage::getField).distinct().collect(Collectors.joining(","));
    }

    @Override
    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    @Override
    public String getDisplayText() {
        return "Verify Profile";
    }

    @Override
    public String getId() {
        return UserModel.RequiredAction.VERIFY_PROFILE.name();
    }
}

