/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.metadata.AttributeConsumingServiceType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.RequestedAttributeType;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.saml.mappers.SamlMetadataDescriptorUpdater;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.util.StringUtil;

public class UserAttributeMapper
extends AbstractIdentityProviderMapper
implements SamlMetadataDescriptorUpdater {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"saml"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String ATTRIBUTE_NAME = "attribute.name";
    public static final String ATTRIBUTE_FRIENDLY_NAME = "attribute.friendly.name";
    public static final String USER_ATTRIBUTE = "user.attribute";
    private static final String EMAIL = "email";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
    public static final String PROVIDER_ID = "saml-user-attribute-idp-mapper";

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Attribute Importer";
    }

    public String getDisplayType() {
        return "Attribute Importer";
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        if (StringUtil.isNullOrEmpty((String)attribute)) {
            return;
        }
        String attributeName = this.getAttributeNameFromMapperModel(mapperModel);
        List<String> attributeValuesInContext = this.findAttributeValuesInContext(attributeName, context);
        if (!attributeValuesInContext.isEmpty()) {
            if (attribute.equalsIgnoreCase(EMAIL)) {
                this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setEmail(arg_0), attributeValuesInContext);
            } else if (attribute.equalsIgnoreCase(FIRST_NAME)) {
                this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setFirstName(arg_0), attributeValuesInContext);
            } else if (attribute.equalsIgnoreCase(LAST_NAME)) {
                this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setLastName(arg_0), attributeValuesInContext);
            } else {
                context.setUserAttribute(attribute, attributeValuesInContext);
            }
        }
    }

    private String getAttributeNameFromMapperModel(IdentityProviderMapperModel mapperModel) {
        String attributeName = (String)mapperModel.getConfig().get(ATTRIBUTE_NAME);
        if (attributeName == null) {
            attributeName = (String)mapperModel.getConfig().get(ATTRIBUTE_FRIENDLY_NAME);
        }
        return attributeName;
    }

    private void setIfNotEmpty(Consumer<String> consumer, List<String> values) {
        if (values != null && !values.isEmpty()) {
            consumer.accept(values.get(0));
        }
    }

    private void setIfNotEmptyAndDifferent(Consumer<String> consumer, Supplier<String> currentValueSupplier, List<String> values) {
        if (values != null && !values.isEmpty() && !values.get(0).equals(currentValueSupplier.get())) {
            consumer.accept(values.get(0));
        }
    }

    private Predicate<AttributeStatementType.ASTChoiceType> elementWith(String attributeName) {
        return attributeType -> {
            AttributeType attribute = attributeType.getAttribute();
            return Objects.equals(attribute.getName(), attributeName) || Objects.equals(attribute.getFriendlyName(), attributeName);
        };
    }

    private List<String> findAttributeValuesInContext(String attributeName, BrokeredIdentityContext context) {
        AssertionType assertion = (AssertionType)context.getContextData().get("SAML_ASSERTION");
        return assertion.getAttributeStatements().stream().flatMap(statement -> statement.getAttributes().stream()).filter(this.elementWith(attributeName)).flatMap(attributeType -> attributeType.getAttribute().getAttributeValue().stream()).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        if (StringUtil.isNullOrEmpty((String)attribute)) {
            return;
        }
        String attributeName = this.getAttributeNameFromMapperModel(mapperModel);
        List<String> attributeValuesInContext = this.findAttributeValuesInContext(attributeName, context);
        if (attribute.equalsIgnoreCase(EMAIL)) {
            this.setIfNotEmptyAndDifferent(arg_0 -> ((UserModel)user).setEmail(arg_0), () -> ((UserModel)user).getEmail(), attributeValuesInContext);
        } else if (attribute.equalsIgnoreCase(FIRST_NAME)) {
            this.setIfNotEmptyAndDifferent(arg_0 -> ((UserModel)user).setFirstName(arg_0), () -> ((UserModel)user).getFirstName(), attributeValuesInContext);
        } else if (attribute.equalsIgnoreCase(LAST_NAME)) {
            this.setIfNotEmptyAndDifferent(arg_0 -> ((UserModel)user).setLastName(arg_0), () -> ((UserModel)user).getLastName(), attributeValuesInContext);
        } else {
            List currentAttributeValues = (List)user.getAttributes().get(attribute);
            if (attributeValuesInContext == null) {
                user.removeAttribute(attribute);
            } else if (currentAttributeValues == null) {
                user.setAttribute(attribute, attributeValuesInContext);
            } else if (!CollectionUtil.collectionEquals(attributeValuesInContext, (Collection)currentAttributeValues)) {
                user.setAttribute(attribute, attributeValuesInContext);
            }
        }
    }

    public String getHelpText() {
        return "Import declared saml attribute if it exists in assertion into the specified user property or attribute.";
    }

    @Override
    public void updateMetadata(IdentityProviderMapperModel mapperModel, EntityDescriptorType entityDescriptor) {
        String attributeName = (String)mapperModel.getConfig().get(ATTRIBUTE_NAME);
        String attributeFriendlyName = (String)mapperModel.getConfig().get(ATTRIBUTE_FRIENDLY_NAME);
        RequestedAttributeType requestedAttribute = new RequestedAttributeType(attributeName);
        requestedAttribute.setIsRequired(null);
        requestedAttribute.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_BASIC.get());
        if (attributeFriendlyName != null && attributeFriendlyName.length() > 0) {
            requestedAttribute.setFriendlyName(attributeFriendlyName);
        }
        for (EntityDescriptorType.EDTChoiceType choiceType : entityDescriptor.getChoiceType()) {
            List descriptors = choiceType.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType descriptor : descriptors) {
                for (AttributeConsumingServiceType attributeConsumingService : descriptor.getSpDescriptor().getAttributeConsumingService()) {
                    boolean alreadyPresent = attributeConsumingService.getRequestedAttribute().stream().anyMatch(t -> !(attributeName != null && !attributeName.equalsIgnoreCase(t.getName()) || attributeFriendlyName != null && !attributeFriendlyName.equalsIgnoreCase(t.getFriendlyName())));
                    if (alreadyPresent) continue;
                    attributeConsumingService.addRequestedAttribute(requestedAttribute);
                }
            }
        }
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE_NAME);
        property.setLabel("Attribute Name");
        property.setHelpText("Name of attribute to search for in assertion.  You can leave this blank and specify a friendly name instead.");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE_FRIENDLY_NAME);
        property.setLabel("Friendly Name");
        property.setHelpText("Friendly name of attribute to search for in assertion.  You can leave this blank and specify a name instead.");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(USER_ATTRIBUTE);
        property.setLabel("User Attribute Name");
        property.setHelpText("User attribute name to store saml attribute.  Use email, lastName, and firstName to map to those predefined user properties.");
        property.setType("String");
        configProperties.add(property);
    }
}

