/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormAuthenticator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigInfoRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.utils.CredentialHelper;
import org.keycloak.utils.ReservedCharValidator;

public class AuthenticationManagementResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    protected static final Logger logger = Logger.getLogger(AuthenticationManagementResource.class);

    public AuthenticationManagementResource(RealmModel realm, KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.AUTH_FLOW);
    }

    @Path(value="/form-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<Map<String, Object>> getFormProviders() {
        this.auth.realm().requireViewRealm();
        return this.buildProviderMetadata(this.session.getKeycloakSessionFactory().getProviderFactoriesStream(FormAuthenticator.class));
    }

    @Path(value="/authenticator-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<Map<String, Object>> getAuthenticatorProviders() {
        this.auth.realm().requireViewRealm();
        return this.buildProviderMetadata(this.session.getKeycloakSessionFactory().getProviderFactoriesStream(Authenticator.class));
    }

    @Path(value="/client-authenticator-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<Map<String, Object>> getClientAuthenticatorProviders() {
        this.auth.realm().requireViewClientAuthenticatorProviders();
        return this.buildProviderMetadata(this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientAuthenticator.class));
    }

    public Stream<Map<String, Object>> buildProviderMetadata(Stream<ProviderFactory> factories) {
        return factories.map(factory -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", factory.getId());
            ConfigurableAuthenticatorFactory configured = (ConfigurableAuthenticatorFactory)factory;
            data.put("description", configured.getHelpText());
            data.put("displayName", configured.getDisplayType());
            return data;
        });
    }

    @Path(value="/form-action-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<Map<String, Object>> getFormActionProviders() {
        this.auth.realm().requireViewRealm();
        return this.buildProviderMetadata(this.session.getKeycloakSessionFactory().getProviderFactoriesStream(FormAction.class));
    }

    @Path(value="/flows")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<AuthenticationFlowRepresentation> getFlows() {
        this.auth.realm().requireViewAuthenticationFlows();
        return this.realm.getAuthenticationFlowsStream().filter(flow -> flow.isTopLevel() && !Objects.equals(flow.getAlias(), "saml ecp")).map(flow -> ModelToRepresentation.toRepresentation((RealmModel)this.realm, (AuthenticationFlowModel)flow));
    }

    @Path(value="/flows")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response createFlow(AuthenticationFlowRepresentation flow) {
        this.auth.realm().requireManageRealm();
        if (flow.getAlias() == null || flow.getAlias().isEmpty()) {
            return ErrorResponse.exists("Failed to create flow with empty alias name");
        }
        if (this.realm.getFlowByAlias(flow.getAlias()) != null) {
            return ErrorResponse.exists("Flow " + flow.getAlias() + " already exists");
        }
        ReservedCharValidator.validate(flow.getAlias());
        AuthenticationFlowModel createdModel = this.realm.addAuthenticationFlow(RepresentationToModel.toModel((AuthenticationFlowRepresentation)flow));
        flow.setId(createdModel.getId());
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), createdModel.getId()).representation(flow).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(flow.getId()).build(new Object[0])).build();
    }

    @Path(value="/flows/{id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public AuthenticationFlowRepresentation getFlow(@PathParam(value="id") String id) {
        this.auth.realm().requireViewRealm();
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(id);
        if (flow == null) {
            throw new NotFoundException("Could not find flow with id");
        }
        return ModelToRepresentation.toRepresentation((RealmModel)this.realm, (AuthenticationFlowModel)flow);
    }

    @Path(value="/flows/{id}")
    @PUT
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateFlow(@PathParam(value="id") String id, AuthenticationFlowRepresentation flow) {
        this.auth.realm().requireManageRealm();
        AuthenticationFlowRepresentation existingFlow = this.getFlow(id);
        if (flow.getAlias() == null || flow.getAlias().isEmpty()) {
            return ErrorResponse.exists("Failed to update flow with empty alias name");
        }
        AuthenticationFlowModel checkFlow = this.realm.getAuthenticationFlowById(id);
        if (checkFlow == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        if (this.realm.getFlowByAlias(flow.getAlias()) != null && !checkFlow.getAlias().equals(flow.getAlias())) {
            return ErrorResponse.exists("Flow alias name already exists");
        }
        if (checkFlow.getAlias() != null && !checkFlow.getAlias().equals(flow.getAlias())) {
            checkFlow.setAlias(flow.getAlias());
        } else if (checkFlow.getAlias() == null && flow.getAlias() != null) {
            checkFlow.setAlias(flow.getAlias());
        }
        if (checkFlow.getDescription() != null && !checkFlow.getDescription().equals(flow.getDescription())) {
            checkFlow.setDescription(flow.getDescription());
        } else if (checkFlow.getDescription() == null && flow.getDescription() != null) {
            checkFlow.setDescription(flow.getDescription());
        }
        flow.setId(existingFlow.getId());
        this.realm.updateAuthenticationFlow(RepresentationToModel.toModel((AuthenticationFlowRepresentation)flow));
        this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(flow).success();
        return Response.accepted((Object)flow).build();
    }

    @Path(value="/flows/{id}")
    @DELETE
    @NoCache
    public void deleteFlow(@PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        this.deleteFlow(id, true);
    }

    private void deleteFlow(String id, boolean isTopMostLevel) {
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(id);
        if (flow == null) {
            throw new NotFoundException("Could not find flow with id");
        }
        if (flow.isBuiltIn()) {
            throw new BadRequestException("Can't delete built in flow");
        }
        this.realm.getAuthenticationExecutionsStream(id).map(AuthenticationExecutionModel::getFlowId).filter(Objects::nonNull).forEachOrdered(flowId -> this.deleteFlow((String)flowId, false));
        this.realm.removeAuthenticationFlow(flow);
        if (isTopMostLevel) {
            this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        }
    }

    @Path(value="/flows/{flowAlias}/copy")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response copy(@PathParam(value="flowAlias") String flowAlias, Map<String, String> data) {
        this.auth.realm().requireManageRealm();
        String newName = data.get("newName");
        if (this.realm.getFlowByAlias(newName) != null) {
            return ErrorResponse.exists("New flow alias name already exists");
        }
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug((Object)("flow not found: " + flowAlias));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        AuthenticationFlowModel copy = AuthenticationManagementResource.copyFlow(this.realm, flow, newName);
        data.put("id", copy.getId());
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(data).success();
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    public static AuthenticationFlowModel copyFlow(RealmModel realm, AuthenticationFlowModel flow, String newName) {
        AuthenticationFlowModel copy = new AuthenticationFlowModel();
        copy.setAlias(newName);
        copy.setDescription(flow.getDescription());
        copy.setProviderId(flow.getProviderId());
        copy.setBuiltIn(false);
        copy.setTopLevel(flow.isTopLevel());
        copy = realm.addAuthenticationFlow(copy);
        AuthenticationManagementResource.copy(realm, newName, flow, copy);
        return copy;
    }

    public static void copy(RealmModel realm, String newName, AuthenticationFlowModel from, AuthenticationFlowModel to) {
        realm.getAuthenticationExecutionsStream(from.getId()).forEachOrdered(execution -> {
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel subFlow = realm.getAuthenticationFlowById(execution.getFlowId());
                AuthenticationFlowModel copy = new AuthenticationFlowModel();
                copy.setAlias(newName + " " + subFlow.getAlias());
                copy.setDescription(subFlow.getDescription());
                copy.setProviderId(subFlow.getProviderId());
                copy.setBuiltIn(false);
                copy.setTopLevel(false);
                copy = realm.addAuthenticationFlow(copy);
                execution.setFlowId(copy.getId());
                AuthenticationManagementResource.copy(realm, newName, subFlow, copy);
            }
            execution.setId(null);
            execution.setParentFlow(to.getId());
            realm.addAuthenticatorExecution(execution);
        });
    }

    @Path(value="/flows/{flowAlias}/executions/flow")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response addExecutionFlow(@PathParam(value="flowAlias") String flowAlias, Map<String, String> data) {
        this.auth.realm().requireManageRealm();
        AuthenticationFlowModel parentFlow = this.realm.getFlowByAlias(flowAlias);
        if (parentFlow == null) {
            return ErrorResponse.error("Parent flow doesn't exist", Response.Status.BAD_REQUEST);
        }
        String alias = data.get("alias");
        String type = data.get("type");
        String provider = data.get("provider");
        String description = data.get("description");
        AuthenticationFlowModel newFlow = this.realm.getFlowByAlias(alias);
        if (newFlow != null) {
            return ErrorResponse.exists("New flow alias name already exists");
        }
        newFlow = new AuthenticationFlowModel();
        newFlow.setAlias(alias);
        newFlow.setDescription(description);
        newFlow.setProviderId(type);
        newFlow = this.realm.addAuthenticationFlow(newFlow);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlow.getId());
        execution.setFlowId(newFlow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED);
        execution.setAuthenticatorFlow(true);
        if (type.equals("form-flow")) {
            execution.setAuthenticator(provider);
        }
        execution.setPriority(this.getNextPriority(parentFlow));
        execution = this.realm.addAuthenticatorExecution(execution);
        data.put("id", execution.getId());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTH_EXECUTION_FLOW).resourcePath((UriInfo)this.session.getContext().getUri()).representation(data).success();
        String addExecutionPathSegment = UriBuilder.fromMethod(AuthenticationManagementResource.class, (String)"addExecutionFlow").build(new Object[]{parentFlow.getAlias()}).getPath();
        return Response.created((URI)this.session.getContext().getUri().getBaseUriBuilder().path(this.session.getContext().getUri().getPath().replace(addExecutionPathSegment, "")).path("flows").path(newFlow.getId()).build(new Object[0])).build();
    }

    private int getNextPriority(AuthenticationFlowModel parentFlow) {
        List executions = this.realm.getAuthenticationExecutionsStream(parentFlow.getId()).collect(Collectors.toList());
        return executions.isEmpty() ? 0 : ((AuthenticationExecutionModel)executions.get(executions.size() - 1)).getPriority() + 1;
    }

    @Path(value="/flows/{flowAlias}/executions/execution")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response addExecutionToFlow(@PathParam(value="flowAlias") String flowAlias, Map<String, String> data) {
        this.auth.realm().requireManageRealm();
        AuthenticationFlowModel parentFlow = this.realm.getFlowByAlias(flowAlias);
        if (parentFlow == null) {
            throw new BadRequestException("Parent flow doesn't exist");
        }
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to add execution to a built in flow");
        }
        String provider = data.get("provider");
        ProviderFactory f = parentFlow.getProviderId().equals("client-flow") ? this.session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, provider) : (parentFlow.getProviderId().equals("form-flow") ? this.session.getKeycloakSessionFactory().getProviderFactory(FormAction.class, provider) : this.session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, provider));
        if (f == null) {
            throw new BadRequestException("No authentication provider found for id: " + provider);
        }
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlow.getId());
        ConfigurableAuthenticatorFactory conf = (ConfigurableAuthenticatorFactory)f;
        if (conf.getRequirementChoices().length == 1) {
            execution.setRequirement(conf.getRequirementChoices()[0]);
        } else {
            execution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED);
        }
        execution.setAuthenticatorFlow(false);
        execution.setAuthenticator(provider);
        execution.setPriority(this.getNextPriority(parentFlow));
        execution = this.realm.addAuthenticatorExecution(execution);
        data.put("id", execution.getId());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(data).success();
        String addExecutionPathSegment = UriBuilder.fromMethod(AuthenticationManagementResource.class, (String)"addExecutionToFlow").build(new Object[]{parentFlow.getAlias()}).getPath();
        return Response.created((URI)this.session.getContext().getUri().getBaseUriBuilder().path(this.session.getContext().getUri().getPath().replace(addExecutionPathSegment, "")).path("executions").path(execution.getId()).build(new Object[0])).build();
    }

    @Path(value="/flows/{flowAlias}/executions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getExecutions(@PathParam(value="flowAlias") String flowAlias) {
        this.auth.realm().requireViewRealm();
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug((Object)("flow not found: " + flowAlias));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LinkedList<AuthenticationExecutionInfoRepresentation> result = new LinkedList<AuthenticationExecutionInfoRepresentation>();
        int level = 0;
        this.recurseExecutions(flow, result, level);
        return Response.ok(result).build();
    }

    public void recurseExecutions(AuthenticationFlowModel flow, List<AuthenticationExecutionInfoRepresentation> result, int level) {
        AtomicInteger index = new AtomicInteger(0);
        this.realm.getAuthenticationExecutionsStream(flow.getId()).forEachOrdered(execution -> {
            AuthenticationExecutionInfoRepresentation rep = new AuthenticationExecutionInfoRepresentation();
            rep.setLevel(level);
            rep.setIndex(index.getAndIncrement());
            rep.setRequirementChoices(new LinkedList());
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel flowRef = this.realm.getAuthenticationFlowById(execution.getFlowId());
                if ("basic-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.CONDITIONAL.name());
                } else if ("form-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                    rep.setProviderId(execution.getAuthenticator());
                    rep.setAuthenticationConfig(execution.getAuthenticatorConfig());
                } else if ("client-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                }
                rep.setDisplayName(flowRef.getAlias());
                rep.setDescription(flowRef.getDescription());
                rep.setConfigurable(Boolean.valueOf(false));
                rep.setId(execution.getId());
                rep.setAuthenticationFlow(Boolean.valueOf(execution.isAuthenticatorFlow()));
                rep.setRequirement(execution.getRequirement().name());
                rep.setFlowId(execution.getFlowId());
                result.add(rep);
                AuthenticationFlowModel subFlow = this.realm.getAuthenticationFlowById(execution.getFlowId());
                this.recurseExecutions(subFlow, result, level + 1);
            } else {
                AuthenticatorConfigModel authenticatorConfig;
                String authenticatorConfigId;
                String providerId = execution.getAuthenticator();
                ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory((KeycloakSession)this.session, (String)providerId);
                rep.setDisplayName(factory.getDisplayType());
                rep.setConfigurable(Boolean.valueOf(factory.isConfigurable()));
                for (AuthenticationExecutionModel.Requirement choice : factory.getRequirementChoices()) {
                    rep.getRequirementChoices().add(choice.name());
                }
                rep.setId(execution.getId());
                if (factory.isConfigurable() && (authenticatorConfigId = execution.getAuthenticatorConfig()) != null && (authenticatorConfig = this.realm.getAuthenticatorConfigById(authenticatorConfigId)) != null) {
                    rep.setAlias(authenticatorConfig.getAlias());
                }
                rep.setRequirement(execution.getRequirement().name());
                rep.setProviderId(execution.getAuthenticator());
                rep.setAuthenticationConfig(execution.getAuthenticatorConfig());
                result.add(rep);
            }
        });
    }

    @Path(value="/flows/{flowAlias}/executions")
    @PUT
    @NoCache
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateExecutions(@PathParam(value="flowAlias") String flowAlias, AuthenticationExecutionInfoRepresentation rep) {
        this.auth.realm().requireManageRealm();
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug((Object)("flow not found: " + flowAlias));
            throw new NotFoundException("flow not found");
        }
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(rep.getId());
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        if (!model.getRequirement().name().equals(rep.getRequirement())) {
            model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
            this.realm.updateAuthenticatorExecution(model);
            this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            return Response.accepted((Object)flow).build();
        }
        if (rep.getAuthenticationFlow() == null) {
            return Response.accepted((Object)flow).build();
        }
        AuthenticationFlowModel checkFlow = this.realm.getAuthenticationFlowById(rep.getFlowId());
        if (checkFlow == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        if (this.realm.getFlowByAlias(rep.getDisplayName()) != null && !checkFlow.getAlias().equals(rep.getDisplayName())) {
            return ErrorResponse.exists("Flow alias name already exists");
        }
        if (!checkFlow.getAlias().equals(rep.getDisplayName())) {
            checkFlow.setAlias(rep.getDisplayName());
        }
        if (!checkFlow.getDescription().equals(rep.getDescription())) {
            checkFlow.setDescription(rep.getDescription());
        }
        this.realm.updateAuthenticationFlow(checkFlow);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        return Response.accepted((Object)flow).build();
    }

    @Path(value="/executions/{executionId}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getExecution(@PathParam(value="executionId") String executionId) {
        this.auth.realm().requireManageRealm();
        Optional<AuthenticationExecutionModel> model = Optional.ofNullable(this.realm.getAuthenticationExecutionById(executionId));
        if (!model.isPresent()) {
            logger.debugv("Could not find execution by Id: {}", (Object)executionId);
            throw new NotFoundException("Illegal execution");
        }
        return Response.ok((Object)model.get()).build();
    }

    @Path(value="/executions")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response addExecution(AuthenticationExecutionRepresentation execution) {
        this.auth.realm().requireManageRealm();
        AuthenticationExecutionModel model = RepresentationToModel.toModel((RealmModel)this.realm, (AuthenticationExecutionRepresentation)execution);
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to add execution to a built in flow");
        }
        model.setPriority(this.getNextPriority(parentFlow));
        model = this.realm.addAuthenticatorExecution(model);
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri(), model.getId()).representation(execution).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    public AuthenticationFlowModel getParentFlow(AuthenticationExecutionModel model) {
        if (model.getParentFlow() == null) {
            throw new BadRequestException("parent flow not set on new execution");
        }
        AuthenticationFlowModel parentFlow = this.realm.getAuthenticationFlowById(model.getParentFlow());
        if (parentFlow == null) {
            throw new BadRequestException("execution parent flow does not exist");
        }
        return parentFlow;
    }

    @Path(value="/executions/{executionId}/raise-priority")
    @POST
    @NoCache
    public void raisePriority(@PathParam(value="executionId") String execution) {
        AuthenticationExecutionModel exe;
        this.auth.realm().requireManageRealm();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to modify execution in a built in flow");
        }
        AuthenticationExecutionModel previous = null;
        Iterator iterator = this.realm.getAuthenticationExecutionsStream(parentFlow.getId()).collect(Collectors.toList()).iterator();
        while (iterator.hasNext() && !(exe = (AuthenticationExecutionModel)iterator.next()).getId().equals(model.getId())) {
            previous = exe;
        }
        if (previous == null) {
            return;
        }
        int tmp = previous.getPriority();
        previous.setPriority(model.getPriority());
        this.realm.updateAuthenticatorExecution(previous);
        model.setPriority(tmp);
        this.realm.updateAuthenticatorExecution(model);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="/executions/{executionId}/lower-priority")
    @POST
    @NoCache
    public void lowerPriority(@PathParam(value="executionId") String execution) {
        int i;
        this.auth.realm().requireManageRealm();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to modify execution in a built in flow");
        }
        List executions = this.realm.getAuthenticationExecutionsStream(parentFlow.getId()).collect(Collectors.toList());
        for (i = 0; i < executions.size() && !((AuthenticationExecutionModel)executions.get(i)).getId().equals(model.getId()); ++i) {
        }
        if (i + 1 >= executions.size()) {
            return;
        }
        AuthenticationExecutionModel next = (AuthenticationExecutionModel)executions.get(i + 1);
        int tmp = model.getPriority();
        model.setPriority(next.getPriority());
        this.realm.updateAuthenticatorExecution(model);
        next.setPriority(tmp);
        this.realm.updateAuthenticatorExecution(next);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="/executions/{executionId}")
    @DELETE
    @NoCache
    public void removeExecution(@PathParam(value="executionId") String execution) {
        this.auth.realm().requireManageRealm();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to remove execution from a built in flow");
        }
        if (model.getFlowId() != null) {
            AuthenticationFlowModel nonTopLevelFlow = this.realm.getAuthenticationFlowById(model.getFlowId());
            this.realm.removeAuthenticationFlow(nonTopLevelFlow);
        }
        this.realm.removeAuthenticatorExecution(model);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="/executions/{executionId}/config")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response newExecutionConfig(@PathParam(value="executionId") String execution, AuthenticatorConfigRepresentation json) {
        this.auth.realm().requireManageRealm();
        ReservedCharValidator.validate(json.getAlias());
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransactionManager().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticatorConfigModel config = RepresentationToModel.toModel((AuthenticatorConfigRepresentation)json);
        if (config.getAlias() == null) {
            return ErrorResponse.error("Alias missing", Response.Status.BAD_REQUEST);
        }
        config = this.realm.addAuthenticatorConfig(config);
        model.setAuthenticatorConfig(config.getId());
        this.realm.updateAuthenticatorExecution(model);
        json.setId(config.getId());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTH_EXECUTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(json).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(config.getId()).build(new Object[0])).build();
    }

    @Path(value="/executions/{executionId}/config/{id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public AuthenticatorConfigRepresentation getAuthenticatorConfig(@PathParam(value="executionId") String execution, @PathParam(value="id") String id) {
        this.auth.realm().requireViewRealm();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        return ModelToRepresentation.toRepresentation((AuthenticatorConfigModel)config);
    }

    @Path(value="unregistered-required-actions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<Map<String, String>> getUnregisteredRequiredActions() {
        this.auth.realm().requireViewRealm();
        Set providerIds = this.realm.getRequiredActionProvidersStream().map(RequiredActionProviderModel::getProviderId).collect(Collectors.toSet());
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(RequiredActionProvider.class).filter(factory -> !providerIds.contains(factory.getId())).map(factory -> {
            RequiredActionFactory r = (RequiredActionFactory)factory;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("name", r.getDisplayText());
            m.put("providerId", r.getId());
            return m;
        });
    }

    @Path(value="register-required-action")
    @POST
    @Consumes(value={"application/json"})
    @NoCache
    public void registerRequiredAction(Map<String, String> data) {
        this.auth.realm().requireManageRealm();
        String providerId = data.get("providerId");
        String name = data.get("name");
        RequiredActionProviderModel requiredAction = new RequiredActionProviderModel();
        requiredAction.setAlias(providerId);
        requiredAction.setName(name);
        requiredAction.setProviderId(providerId);
        requiredAction.setDefaultAction(false);
        requiredAction.setPriority(this.getNextRequiredActionPriority());
        requiredAction.setEnabled(true);
        requiredAction = this.realm.addRequiredActionProvider(requiredAction);
        data.put("id", requiredAction.getId());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(data).success();
    }

    private int getNextRequiredActionPriority() {
        List actions = this.realm.getRequiredActionProvidersStream().collect(Collectors.toList());
        return actions.isEmpty() ? 0 : ((RequiredActionProviderModel)actions.get(actions.size() - 1)).getPriority() + 1;
    }

    @Path(value="required-actions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RequiredActionProviderRepresentation> getRequiredActions() {
        this.auth.realm().requireViewRequiredActions();
        return this.realm.getRequiredActionProvidersStream().map(AuthenticationManagementResource::toRepresentation);
    }

    public static RequiredActionProviderRepresentation toRepresentation(RequiredActionProviderModel model) {
        RequiredActionProviderRepresentation rep = new RequiredActionProviderRepresentation();
        rep.setAlias(model.getAlias());
        rep.setProviderId(model.getProviderId());
        rep.setName(model.getName());
        rep.setDefaultAction(model.isDefaultAction());
        rep.setPriority(model.getPriority());
        rep.setEnabled(model.isEnabled());
        rep.setConfig(model.getConfig());
        return rep;
    }

    @Path(value="required-actions/{alias}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public RequiredActionProviderRepresentation getRequiredAction(@PathParam(value="alias") String alias) {
        this.auth.realm().requireViewRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action");
        }
        return AuthenticationManagementResource.toRepresentation(model);
    }

    @Path(value="required-actions/{alias}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRequiredAction(@PathParam(value="alias") String alias, RequiredActionProviderRepresentation rep) {
        this.auth.realm().requireManageRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action");
        }
        RequiredActionProviderModel update = new RequiredActionProviderModel();
        update.setId(model.getId());
        update.setName(rep.getName());
        update.setAlias(rep.getAlias());
        update.setProviderId(model.getProviderId());
        update.setDefaultAction(rep.isDefaultAction());
        update.setPriority(rep.getPriority());
        update.setEnabled(rep.isEnabled());
        update.setConfig(rep.getConfig());
        this.realm.updateRequiredActionProvider(update);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }

    @Path(value="required-actions/{alias}")
    @DELETE
    public void removeRequiredAction(@PathParam(value="alias") String alias) {
        this.auth.realm().requireManageRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action.");
        }
        this.realm.removeRequiredActionProvider(model);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="required-actions/{alias}/raise-priority")
    @POST
    @NoCache
    public void raiseRequiredActionPriority(@PathParam(value="alias") String alias) {
        RequiredActionProviderModel action;
        this.auth.realm().requireManageRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action.");
        }
        RequiredActionProviderModel previous = null;
        Iterator iterator = this.realm.getRequiredActionProvidersStream().collect(Collectors.toList()).iterator();
        while (iterator.hasNext() && !(action = (RequiredActionProviderModel)iterator.next()).getId().equals(model.getId())) {
            previous = action;
        }
        if (previous == null) {
            return;
        }
        int tmp = previous.getPriority();
        previous.setPriority(model.getPriority());
        this.realm.updateRequiredActionProvider(previous);
        model.setPriority(tmp);
        this.realm.updateRequiredActionProvider(model);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="/required-actions/{alias}/lower-priority")
    @POST
    @NoCache
    public void lowerRequiredActionPriority(@PathParam(value="alias") String alias) {
        int i;
        this.auth.realm().requireManageRealm();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action.");
        }
        List actions = this.realm.getRequiredActionProvidersStream().collect(Collectors.toList());
        for (i = 0; i < actions.size() && !((RequiredActionProviderModel)actions.get(i)).getId().equals(model.getId()); ++i) {
        }
        if (i + 1 >= actions.size()) {
            return;
        }
        RequiredActionProviderModel next = (RequiredActionProviderModel)actions.get(i + 1);
        int tmp = model.getPriority();
        model.setPriority(next.getPriority());
        this.realm.updateRequiredActionProvider(model);
        next.setPriority(tmp);
        this.realm.updateRequiredActionProvider(next);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.REQUIRED_ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="config-description/{providerId}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public AuthenticatorConfigInfoRepresentation getAuthenticatorConfigDescription(@PathParam(value="providerId") String providerId) {
        this.auth.realm().requireViewRealm();
        ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory((KeycloakSession)this.session, (String)providerId);
        if (factory == null) {
            throw new NotFoundException("Could not find authenticator provider");
        }
        AuthenticatorConfigInfoRepresentation rep = new AuthenticatorConfigInfoRepresentation();
        rep.setProviderId(providerId);
        rep.setName(factory.getDisplayType());
        rep.setHelpText(factory.getHelpText());
        rep.setProperties(new LinkedList());
        List configProperties = Optional.ofNullable(factory.getConfigProperties()).orElse(Collections.emptyList());
        for (ProviderConfigProperty prop : configProperties) {
            ConfigPropertyRepresentation propRep = this.getConfigPropertyRep(prop);
            rep.getProperties().add(propRep);
        }
        return rep;
    }

    private ConfigPropertyRepresentation getConfigPropertyRep(ProviderConfigProperty prop) {
        return ModelToRepresentation.toRepresentation((ProviderConfigProperty)prop);
    }

    @Path(value="per-client-config-description")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Map<String, List<ConfigPropertyRepresentation>> getPerClientConfigDescription() {
        this.auth.realm().requireViewClientAuthenticatorProviders();
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientAuthenticator.class).collect(Collectors.toMap(ProviderFactory::getId, factory -> {
            ClientAuthenticatorFactory clientAuthFactory = (ClientAuthenticatorFactory)CredentialHelper.getConfigurableAuthenticatorFactory((KeycloakSession)this.session, (String)factory.getId());
            return clientAuthFactory.getConfigPropertiesPerClient().stream().map(this::getConfigPropertyRep).collect(Collectors.toList());
        }));
    }

    @Path(value="config")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response createAuthenticatorConfig(AuthenticatorConfigRepresentation rep) {
        this.auth.realm().requireManageRealm();
        ReservedCharValidator.validate(rep.getAlias());
        AuthenticatorConfigModel config = this.realm.addAuthenticatorConfig(RepresentationToModel.toModel((AuthenticatorConfigRepresentation)rep));
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.AUTHENTICATOR_CONFIG).resourcePath((UriInfo)this.session.getContext().getUri(), config.getId()).representation(rep).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(config.getId()).build(new Object[0])).build();
    }

    @Path(value="config/{id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public AuthenticatorConfigRepresentation getAuthenticatorConfig(@PathParam(value="id") String id) {
        this.auth.realm().requireViewRealm();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        return ModelToRepresentation.toRepresentation((AuthenticatorConfigModel)config);
    }

    @Path(value="config/{id}")
    @DELETE
    @NoCache
    public void removeAuthenticatorConfig(@PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        this.realm.getAuthenticationFlowsStream().forEach(flow -> this.realm.getAuthenticationExecutionsStream(flow.getId()).filter(exe -> Objects.equals(id, exe.getAuthenticatorConfig())).forEachOrdered(exe -> {
            exe.setAuthenticatorConfig(null);
            this.realm.updateAuthenticatorExecution(exe);
        }));
        this.realm.removeAuthenticatorConfig(config);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.AUTHENTICATOR_CONFIG).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="config/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @NoCache
    public void updateAuthenticatorConfig(@PathParam(value="id") String id, AuthenticatorConfigRepresentation rep) {
        this.auth.realm().requireManageRealm();
        ReservedCharValidator.validate(rep.getAlias());
        AuthenticatorConfigModel exists = this.realm.getAuthenticatorConfigById(id);
        if (exists == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        exists.setAlias(rep.getAlias());
        exists.setConfig(RepresentationToModel.removeEmptyString((Map)rep.getConfig()));
        this.realm.updateAuthenticatorConfig(exists);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.AUTHENTICATOR_CONFIG).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }
}

