/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.DefaultAttributes;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;

public class LegacyAttributes
extends DefaultAttributes {
    public LegacyAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata profileMetadata, KeycloakSession session) {
        super(context, attributes, user, profileMetadata, session);
    }

    protected boolean isSupportedAttribute(String name) {
        if (super.isSupportedAttribute(name)) {
            return true;
        }
        return name.startsWith("user.attributes.");
    }

    public boolean isReadOnly(String attributeName) {
        return this.isReadOnlyFromMetadata(attributeName) || this.isReadOnlyInternalAttribute(attributeName);
    }

    public Map<String, List<String>> getReadable() {
        if (this.user == null) {
            return null;
        }
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>(this.user.getAttributes());
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    protected boolean isIncludeAttributeIfNotProvided(AttributeMetadata metadata) {
        return UserProfileContext.USER_API.equals((Object)this.context);
    }
}

