/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.webauthn4j.converter.jackson.deserializer.AuthenticationExtensionClientInputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ExtensionClientInputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ExtensionClientOutputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.JWSDeserializer;
import com.webauthn4j.converter.jackson.deserializer.RegistrationExtensionClientInputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.UnknownExtensionClientInputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.UnknownExtensionClientOutputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.JWSSerializer;
import com.webauthn4j.converter.jackson.serializer.X509CertificateSerializer;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.AuthenticatorSelectionExtensionClientOutput;
import com.webauthn4j.data.extension.client.BiometricAuthenticatorPerformanceBoundsExtensionClientOutput;
import com.webauthn4j.data.extension.client.CredentialPropertiesExtensionClientInput;
import com.webauthn4j.data.extension.client.CredentialPropertiesExtensionClientOutput;
import com.webauthn4j.data.extension.client.ExtensionClientInput;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientInput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientOutput;
import com.webauthn4j.data.extension.client.GenericTransactionAuthorizationExtensionClientOutput;
import com.webauthn4j.data.extension.client.LocationExtensionClientOutput;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.data.extension.client.SimpleTransactionAuthorizationExtensionClientOutput;
import com.webauthn4j.data.extension.client.SupportedExtensionsExtensionClientInput;
import com.webauthn4j.data.extension.client.SupportedExtensionsExtensionClientOutput;
import com.webauthn4j.data.extension.client.UnknownExtensionClientInput;
import com.webauthn4j.data.extension.client.UnknownExtensionClientOutput;
import com.webauthn4j.data.extension.client.UserVerificationIndexExtensionClientOutput;
import com.webauthn4j.data.jws.JWS;
import java.security.cert.X509Certificate;

public class WebAuthnJSONModule
extends SimpleModule {
    public WebAuthnJSONModule(ObjectConverter objectConverter) {
        super("WebAuthnJSONModule");
        this.addDeserializer(Challenge.class, (JsonDeserializer)new ChallengeDeserializer());
        this.addDeserializer(ExtensionClientInput.class, (JsonDeserializer)new ExtensionClientInputDeserializer());
        this.addDeserializer(RegistrationExtensionClientInput.class, (JsonDeserializer)new RegistrationExtensionClientInputDeserializer());
        this.addDeserializer(AuthenticationExtensionClientInput.class, (JsonDeserializer)new AuthenticationExtensionClientInputDeserializer());
        this.addDeserializer(ExtensionClientOutput.class, (JsonDeserializer)new ExtensionClientOutputDeserializer());
        this.addDeserializer(UnknownExtensionClientInput.class, (JsonDeserializer)new UnknownExtensionClientInputDeserializer());
        this.addDeserializer(UnknownExtensionClientOutput.class, (JsonDeserializer)new UnknownExtensionClientOutputDeserializer());
        this.addDeserializer(JWS.class, (JsonDeserializer)new JWSDeserializer(objectConverter));
        this.addDeserializer(X509Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        this.addSerializer((JsonSerializer)new ChallengeSerializer());
        this.addSerializer((JsonSerializer)new JWSSerializer());
        this.addSerializer((JsonSerializer)new X509CertificateSerializer());
        this.registerSubtypes(new NamedType[]{new NamedType(CredentialPropertiesExtensionClientInput.class, "credProps")});
        this.registerSubtypes(new NamedType[]{new NamedType(FIDOAppIDExtensionClientInput.class, "appid")});
        this.registerSubtypes(new NamedType[]{new NamedType(SupportedExtensionsExtensionClientInput.class, "exts")});
        this.registerSubtypes(new NamedType[]{new NamedType(AuthenticatorSelectionExtensionClientOutput.class, "authnSel")});
        this.registerSubtypes(new NamedType[]{new NamedType(BiometricAuthenticatorPerformanceBoundsExtensionClientOutput.class, "biometricPerfBounds")});
        this.registerSubtypes(new NamedType[]{new NamedType(CredentialPropertiesExtensionClientOutput.class, "credProps")});
        this.registerSubtypes(new NamedType[]{new NamedType(FIDOAppIDExtensionClientOutput.class, "appid")});
        this.registerSubtypes(new NamedType[]{new NamedType(GenericTransactionAuthorizationExtensionClientOutput.class, "txAuthGeneric")});
        this.registerSubtypes(new NamedType[]{new NamedType(LocationExtensionClientOutput.class, "loc")});
        this.registerSubtypes(new NamedType[]{new NamedType(SimpleTransactionAuthorizationExtensionClientOutput.class, "txAuthSimple")});
        this.registerSubtypes(new NamedType[]{new NamedType(SupportedExtensionsExtensionClientOutput.class, "exts")});
        this.registerSubtypes(new NamedType[]{new NamedType(UserVerificationIndexExtensionClientOutput.class, "uvi")});
    }
}

