/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common.delegate;

import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.function.Supplier;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.delegate.DelegateProvider;

public class LazyDelegateProvider<T extends UpdatableEntity>
implements DelegateProvider {
    private final Supplier<T> delegateSupplier;
    private final AtomicMarkableReference<T> delegate = new AtomicMarkableReference<Object>(null, false);

    public LazyDelegateProvider(Supplier<T> delegateSupplier) {
        this.delegateSupplier = delegateSupplier;
    }

    @Override
    public T getDelegate(boolean isRead, Object field) {
        UpdatableEntity ref;
        if (!this.isDelegateInitialized()) {
            this.delegate.compareAndSet(null, this.delegateSupplier == null ? null : (UpdatableEntity)this.delegateSupplier.get(), false, true);
        }
        if ((ref = (UpdatableEntity)this.delegate.getReference()) == null) {
            throw new IllegalStateException("Invalid delegate obtained");
        }
        return (T)ref;
    }

    protected boolean isDelegateInitialized() {
        return this.delegate.isMarked();
    }

    @Override
    public boolean isUpdated() {
        if (this.isDelegateInitialized()) {
            Object d = this.getDelegate(true, this);
            return d.isUpdated();
        }
        return false;
    }
}

