/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MapRequiredActionProviderEntity
extends UpdatableEntity.Impl {
    private String id;
    private String alias;
    private String name;
    private String providerId;
    private Integer priority = 0;
    private Boolean enabled = false;
    private Boolean defaultAction = false;
    private Map<String, String> config = new HashMap<String, String>();

    private MapRequiredActionProviderEntity() {
    }

    public static MapRequiredActionProviderEntity fromModel(RequiredActionProviderModel model) {
        if (model == null) {
            return null;
        }
        MapRequiredActionProviderEntity entity = new MapRequiredActionProviderEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setName(model.getName());
        entity.setProviderId(model.getProviderId());
        entity.setPriority(model.getPriority());
        entity.setEnabled(model.isEnabled());
        entity.setDefaultAction(model.isDefaultAction());
        entity.setConfig(model.getConfig() == null ? null : new HashMap(model.getConfig()));
        return entity;
    }

    public static RequiredActionProviderModel toModel(MapRequiredActionProviderEntity entity) {
        if (entity == null) {
            return null;
        }
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setName(entity.getName());
        model.setProviderId(entity.getProviderId());
        model.setPriority(entity.getPriority().intValue());
        model.setEnabled(entity.isEnabled().booleanValue());
        model.setDefaultAction(entity.isDefaultAction().booleanValue());
        model.setConfig((Map)(entity.getConfig() == null ? null : new HashMap<String, String>(entity.getConfig())));
        return model;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.updated = !Objects.equals(this.id, id);
        this.id = id;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.updated = !Objects.equals(this.alias, alias);
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.updated = !Objects.equals(this.name, name);
        this.name = name;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.updated = !Objects.equals(this.providerId, providerId);
        this.providerId = providerId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.updated = !Objects.equals(this.priority, priority);
        this.priority = priority;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.updated = !Objects.equals(this.enabled, enabled);
        this.enabled = enabled;
    }

    public Boolean isDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(boolean defaultAction) {
        this.updated = !Objects.equals(this.defaultAction, defaultAction);
        this.defaultAction = defaultAction;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.updated = !Objects.equals(this.config, config);
        this.config = config;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapRequiredActionProviderEntity)) {
            return false;
        }
        MapRequiredActionProviderEntity other = (MapRequiredActionProviderEntity)obj;
        return Objects.equals(other.getId(), this.getId());
    }
}

