/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;

public class MapUserSessionEntity
extends UpdatableEntity.Impl
implements AbstractEntity {
    private String id;
    private String realmId;
    private String userId;
    private String brokerSessionId;
    private String brokerUserId;
    private String loginUsername;
    private String ipAddress;
    private String authMethod;
    private boolean rememberMe;
    private int started;
    private int lastSessionRefresh;
    private long expiration;
    private Map<String, String> notes = new ConcurrentHashMap<String, String>();
    private UserSessionModel.State state;
    private UserSessionModel.SessionPersistenceState persistenceState = UserSessionModel.SessionPersistenceState.PERSISTENT;
    private Map<String, String> authenticatedClientSessions = new ConcurrentHashMap<String, String>();
    private boolean offline;

    public MapUserSessionEntity() {
    }

    public MapUserSessionEntity(String id, String realmId) {
        this.id = id;
        this.realmId = realmId;
    }

    public MapUserSessionEntity(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId, boolean offline) {
        this.id = id;
        this.realmId = realm.getId();
        this.userId = user.getId();
        this.loginUsername = loginUsername;
        this.ipAddress = ipAddress;
        this.authMethod = authMethod;
        this.rememberMe = rememberMe;
        this.brokerSessionId = brokerSessionId;
        this.brokerUserId = brokerUserId;
        this.lastSessionRefresh = this.started = Time.currentTime();
        this.offline = offline;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (this.id != null) {
            throw new IllegalStateException("Id cannot be changed");
        }
        this.id = id;
        this.updated |= id != null;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.updated |= !Objects.equals(this.realmId, realmId);
        this.realmId = realmId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.updated |= !Objects.equals(this.userId, userId);
        this.userId = userId;
    }

    public String getBrokerSessionId() {
        return this.brokerSessionId;
    }

    public void setBrokerSessionId(String brokerSessionId) {
        this.updated |= !Objects.equals(this.brokerSessionId, brokerSessionId);
        this.brokerSessionId = brokerSessionId;
    }

    public String getBrokerUserId() {
        return this.brokerUserId;
    }

    public void setBrokerUserId(String brokerUserId) {
        this.updated |= !Objects.equals(this.brokerUserId, brokerUserId);
        this.brokerUserId = brokerUserId;
    }

    public String getLoginUsername() {
        return this.loginUsername;
    }

    public void setLoginUsername(String loginUsername) {
        this.updated |= !Objects.equals(this.loginUsername, loginUsername);
        this.loginUsername = loginUsername;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.updated |= !Objects.equals(this.ipAddress, ipAddress);
        this.ipAddress = ipAddress;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.updated |= !Objects.equals(this.authMethod, authMethod);
        this.authMethod = authMethod;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.updated |= this.rememberMe != rememberMe;
        this.rememberMe = rememberMe;
    }

    public int getStarted() {
        return this.started;
    }

    public void setStarted(int started) {
        this.updated |= this.started != started;
        this.started = started;
    }

    public int getLastSessionRefresh() {
        return this.lastSessionRefresh;
    }

    public void setLastSessionRefresh(int lastSessionRefresh) {
        this.updated |= this.lastSessionRefresh != lastSessionRefresh;
        this.lastSessionRefresh = lastSessionRefresh;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.updated |= this.expiration != expiration;
        this.expiration = expiration;
    }

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public String getNote(String name) {
        return this.notes.get(name);
    }

    public void setNotes(Map<String, String> notes) {
        this.updated |= !Objects.equals(this.notes, notes);
        this.notes = notes;
    }

    public String removeNote(String name) {
        String note = this.notes.remove(name);
        this.updated |= note != null;
        return note;
    }

    public void addNote(String name, String value) {
        this.updated |= !Objects.equals(this.notes.put(name, value), value);
    }

    public UserSessionModel.State getState() {
        return this.state;
    }

    public void setState(UserSessionModel.State state) {
        this.updated |= !Objects.equals(this.state, state);
        this.state = state;
    }

    public Map<String, String> getAuthenticatedClientSessions() {
        return this.authenticatedClientSessions;
    }

    public void setAuthenticatedClientSessions(Map<String, String> authenticatedClientSessions) {
        this.updated |= !Objects.equals(this.authenticatedClientSessions, authenticatedClientSessions);
        this.authenticatedClientSessions = authenticatedClientSessions;
    }

    public void addAuthenticatedClientSession(String clientId, String clientSessionId) {
        this.updated |= !Objects.equals(this.authenticatedClientSessions.put(clientId, clientSessionId), clientSessionId);
    }

    public String removeAuthenticatedClientSession(String clientId) {
        String entity = this.authenticatedClientSessions.remove(clientId);
        this.updated |= entity != null;
        return entity;
    }

    public void clearAuthenticatedClientSessions() {
        this.updated |= !this.authenticatedClientSessions.isEmpty();
        this.authenticatedClientSessions.clear();
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.updated |= this.offline != offline;
        this.offline = offline;
    }

    public UserSessionModel.SessionPersistenceState getPersistenceState() {
        return this.persistenceState;
    }

    public void setPersistenceState(UserSessionModel.SessionPersistenceState persistenceState) {
        this.updated |= !Objects.equals(this.persistenceState, persistenceState);
        this.persistenceState = persistenceState;
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }
}

