/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validation;

import javax.ws.rs.BadRequestException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.validation.ClientValidationContext;
import org.keycloak.validation.ClientValidationProvider;

public class ClientValidationUtil {
    public static void validate(KeycloakSession session, ClientModel client, boolean create, ErrorHandler errorHandler) throws BadRequestException {
        ClientValidationProvider provider = (ClientValidationProvider)session.getProvider(ClientValidationProvider.class);
        if (provider != null) {
            DefaultClientValidationContext context = new DefaultClientValidationContext(create ? ClientValidationContext.Event.CREATE : ClientValidationContext.Event.UPDATE, session, client);
            provider.validate(context);
            if (!context.isValid()) {
                errorHandler.onError(context);
            }
        }
    }

    private static class DefaultClientValidationContext
    implements ClientValidationContext {
        private ClientValidationContext.Event event;
        private KeycloakSession session;
        private ClientModel client;
        private String error;

        public DefaultClientValidationContext(ClientValidationContext.Event event, KeycloakSession session, ClientModel client) {
            this.event = event;
            this.session = session;
            this.client = client;
        }

        public boolean isValid() {
            return this.error == null;
        }

        @Override
        public String getError() {
            return this.error;
        }

        @Override
        public ClientValidationContext.Event getEvent() {
            return this.event;
        }

        @Override
        public KeycloakSession getSession() {
            return this.session;
        }

        @Override
        public ClientModel getClient() {
            return this.client;
        }

        @Override
        public ClientValidationContext invalid(String error) {
            this.error = error;
            return this;
        }
    }

    public static interface ErrorHandler {
        public void onError(ClientValidationContext var1);
    }
}

