/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public abstract class AbstractLoginProtocolFactory
implements LoginProtocolFactory {
    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof RealmModel.ClientCreationEvent) {
                    ClientModel client = ((RealmModel.ClientCreationEvent)event).getCreatedClient();
                    AbstractLoginProtocolFactory.this.addDefaultClientScopes(client.getRealm(), client);
                    AbstractLoginProtocolFactory.this.addDefaults(client);
                }
            }
        });
    }

    @Override
    public void createDefaultClientScopes(RealmModel newRealm, boolean addScopesToExistingClients) {
        this.createDefaultClientScopesImpl(newRealm);
        if (addScopesToExistingClients) {
            this.addDefaultClientScopes(newRealm, newRealm.getClients());
        }
    }

    protected abstract void createDefaultClientScopesImpl(RealmModel var1);

    protected void addDefaultClientScopes(RealmModel realm, ClientModel newClient) {
        this.addDefaultClientScopes(realm, Arrays.asList(newClient));
    }

    protected void addDefaultClientScopes(RealmModel realm, List<ClientModel> newClients) {
        Set defaultClientScopes = realm.getDefaultClientScopes(true).stream().filter(clientScope -> this.getId().equals(clientScope.getProtocol())).collect(Collectors.toSet());
        for (ClientModel newClient : newClients) {
            newClient.addClientScopes(defaultClientScopes, true);
        }
        Set nonDefaultClientScopes = realm.getDefaultClientScopes(false).stream().filter(clientScope -> this.getId().equals(clientScope.getProtocol())).collect(Collectors.toSet());
        for (ClientModel newClient : newClients) {
            newClient.addClientScopes(nonDefaultClientScopes, false);
        }
    }

    protected abstract void addDefaults(ClientModel var1);

    public void close() {
    }
}

