/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationProviderFactory;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.UriUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.keys.KeyProvider;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.migrators.MigrateTo8_0_0;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.credential.dto.OTPCredentialData;
import org.keycloak.models.credential.dto.OTPSecretData;
import org.keycloak.models.credential.dto.PasswordCredentialData;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.models.utils.DefaultKeyProviders;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.policy.PasswordPolicyNotMetException;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClaimRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.util.JsonSerialization;
import org.keycloak.validation.ValidationUtil;

public class RepresentationToModel {
    private static Logger logger = Logger.getLogger(RepresentationToModel.class);
    public static final String OIDC = "openid-connect";

    public static OTPPolicy toPolicy(RealmRepresentation rep) {
        OTPPolicy policy = new OTPPolicy();
        if (rep.getOtpPolicyType() != null) {
            policy.setType(rep.getOtpPolicyType());
        }
        if (rep.getOtpPolicyLookAheadWindow() != null) {
            policy.setLookAheadWindow(rep.getOtpPolicyLookAheadWindow().intValue());
        }
        if (rep.getOtpPolicyInitialCounter() != null) {
            policy.setInitialCounter(rep.getOtpPolicyInitialCounter().intValue());
        }
        if (rep.getOtpPolicyAlgorithm() != null) {
            policy.setAlgorithm(rep.getOtpPolicyAlgorithm());
        }
        if (rep.getOtpPolicyDigits() != null) {
            policy.setDigits(rep.getOtpPolicyDigits().intValue());
        }
        if (rep.getOtpPolicyPeriod() != null) {
            policy.setPeriod(rep.getOtpPolicyPeriod().intValue());
        }
        return policy;
    }

    public static void importRealm(KeycloakSession session, RealmRepresentation rep, RealmModel newRealm, boolean skipUserDependent) {
        ClientScopeModel clientScope;
        RepresentationToModel.convertDeprecatedSocialProviders(rep);
        RepresentationToModel.convertDeprecatedApplications(session, rep);
        RepresentationToModel.convertDeprecatedClientTemplates(rep);
        newRealm.setName(rep.getRealm());
        if (rep.getDisplayName() != null) {
            newRealm.setDisplayName(rep.getDisplayName());
        }
        if (rep.getDisplayNameHtml() != null) {
            newRealm.setDisplayNameHtml(rep.getDisplayNameHtml());
        }
        if (rep.isEnabled() != null) {
            newRealm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isUserManagedAccessAllowed() != null) {
            newRealm.setUserManagedAccessAllowed(rep.isUserManagedAccessAllowed().booleanValue());
        }
        if (rep.isBruteForceProtected() != null) {
            newRealm.setBruteForceProtected(rep.isBruteForceProtected().booleanValue());
        }
        if (rep.isPermanentLockout() != null) {
            newRealm.setPermanentLockout(rep.isPermanentLockout().booleanValue());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            newRealm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds().intValue());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            newRealm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds().intValue());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            newRealm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds().intValue());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            newRealm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds().longValue());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            newRealm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds().intValue());
        }
        if (rep.getFailureFactor() != null) {
            newRealm.setFailureFactor(rep.getFailureFactor().intValue());
        }
        if (rep.isEventsEnabled() != null) {
            newRealm.setEventsEnabled(rep.isEventsEnabled().booleanValue());
        }
        if (rep.getEnabledEventTypes() != null) {
            newRealm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
        if (rep.getEventsExpiration() != null) {
            newRealm.setEventsExpiration(rep.getEventsExpiration().longValue());
        }
        if (rep.getEventsListeners() != null) {
            newRealm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            newRealm.setAdminEventsEnabled(rep.isAdminEventsEnabled().booleanValue());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            newRealm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled().booleanValue());
        }
        if (rep.getNotBefore() != null) {
            newRealm.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getDefaultSignatureAlgorithm() != null) {
            newRealm.setDefaultSignatureAlgorithm(rep.getDefaultSignatureAlgorithm());
        }
        if (rep.getRevokeRefreshToken() != null) {
            newRealm.setRevokeRefreshToken(rep.getRevokeRefreshToken().booleanValue());
        } else {
            newRealm.setRevokeRefreshToken(false);
        }
        if (rep.getRefreshTokenMaxReuse() != null) {
            newRealm.setRefreshTokenMaxReuse(rep.getRefreshTokenMaxReuse().intValue());
        } else {
            newRealm.setRefreshTokenMaxReuse(0);
        }
        if (rep.getAccessTokenLifespan() != null) {
            newRealm.setAccessTokenLifespan(rep.getAccessTokenLifespan().intValue());
        } else {
            newRealm.setAccessTokenLifespan(300);
        }
        if (rep.getAccessTokenLifespanForImplicitFlow() != null) {
            newRealm.setAccessTokenLifespanForImplicitFlow(rep.getAccessTokenLifespanForImplicitFlow().intValue());
        } else {
            newRealm.setAccessTokenLifespanForImplicitFlow(900);
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            newRealm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout().intValue());
        } else {
            newRealm.setSsoSessionIdleTimeout(1800);
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            newRealm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan().intValue());
        } else {
            newRealm.setSsoSessionMaxLifespan(36000);
        }
        if (rep.getSsoSessionMaxLifespanRememberMe() != null) {
            newRealm.setSsoSessionMaxLifespanRememberMe(rep.getSsoSessionMaxLifespanRememberMe().intValue());
        }
        if (rep.getSsoSessionIdleTimeoutRememberMe() != null) {
            newRealm.setSsoSessionIdleTimeoutRememberMe(rep.getSsoSessionIdleTimeoutRememberMe().intValue());
        }
        if (rep.getOfflineSessionIdleTimeout() != null) {
            newRealm.setOfflineSessionIdleTimeout(rep.getOfflineSessionIdleTimeout().intValue());
        } else {
            newRealm.setOfflineSessionIdleTimeout(2592000);
        }
        if (rep.getOfflineSessionMaxLifespanEnabled() != null) {
            newRealm.setOfflineSessionMaxLifespanEnabled(rep.getOfflineSessionMaxLifespanEnabled().booleanValue());
        } else {
            newRealm.setOfflineSessionMaxLifespanEnabled(false);
        }
        if (rep.getOfflineSessionMaxLifespan() != null) {
            newRealm.setOfflineSessionMaxLifespan(rep.getOfflineSessionMaxLifespan().intValue());
        } else {
            newRealm.setOfflineSessionMaxLifespan(5184000);
        }
        if (rep.getClientSessionIdleTimeout() != null) {
            newRealm.setClientSessionIdleTimeout(rep.getClientSessionIdleTimeout().intValue());
        }
        if (rep.getClientSessionMaxLifespan() != null) {
            newRealm.setClientSessionMaxLifespan(rep.getClientSessionMaxLifespan().intValue());
        }
        if (rep.getClientOfflineSessionIdleTimeout() != null) {
            newRealm.setClientOfflineSessionIdleTimeout(rep.getClientOfflineSessionIdleTimeout().intValue());
        }
        if (rep.getClientOfflineSessionMaxLifespan() != null) {
            newRealm.setClientOfflineSessionMaxLifespan(rep.getClientOfflineSessionMaxLifespan().intValue());
        }
        if (rep.getAccessCodeLifespan() != null) {
            newRealm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        } else {
            newRealm.setAccessCodeLifespan(60);
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            newRealm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        } else {
            newRealm.setAccessCodeLifespanUserAction(300);
        }
        if (rep.getAccessCodeLifespanLogin() != null) {
            newRealm.setAccessCodeLifespanLogin(rep.getAccessCodeLifespanLogin().intValue());
        } else {
            newRealm.setAccessCodeLifespanLogin(1800);
        }
        if (rep.getActionTokenGeneratedByAdminLifespan() != null) {
            newRealm.setActionTokenGeneratedByAdminLifespan(rep.getActionTokenGeneratedByAdminLifespan().intValue());
        } else {
            newRealm.setActionTokenGeneratedByAdminLifespan(43200);
        }
        if (rep.getActionTokenGeneratedByUserLifespan() != null) {
            newRealm.setActionTokenGeneratedByUserLifespan(rep.getActionTokenGeneratedByUserLifespan().intValue());
        } else {
            newRealm.setActionTokenGeneratedByUserLifespan(newRealm.getAccessCodeLifespanUserAction());
        }
        if (rep.getSslRequired() != null) {
            newRealm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.isRegistrationAllowed() != null) {
            newRealm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isRegistrationEmailAsUsername() != null) {
            newRealm.setRegistrationEmailAsUsername(rep.isRegistrationEmailAsUsername().booleanValue());
        }
        if (rep.isRememberMe() != null) {
            newRealm.setRememberMe(rep.isRememberMe().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            newRealm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isLoginWithEmailAllowed() != null) {
            newRealm.setLoginWithEmailAllowed(rep.isLoginWithEmailAllowed().booleanValue());
        }
        if (rep.isDuplicateEmailsAllowed() != null) {
            newRealm.setDuplicateEmailsAllowed(rep.isDuplicateEmailsAllowed().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            newRealm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isEditUsernameAllowed() != null) {
            newRealm.setEditUsernameAllowed(rep.isEditUsernameAllowed().booleanValue());
        }
        if (rep.getLoginTheme() != null) {
            newRealm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            newRealm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            newRealm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            newRealm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.getRequiredCredentials() != null) {
            for (String requiredCred : rep.getRequiredCredentials()) {
                newRealm.addRequiredCredential(requiredCred);
            }
        } else {
            newRealm.addRequiredCredential("password");
        }
        if (rep.getPasswordPolicy() != null) {
            newRealm.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)rep.getPasswordPolicy()));
        }
        if (rep.getOtpPolicyType() != null) {
            newRealm.setOTPPolicy(RepresentationToModel.toPolicy(rep));
        } else {
            newRealm.setOTPPolicy(OTPPolicy.DEFAULT_POLICY);
        }
        WebAuthnPolicy webAuthnPolicy = RepresentationToModel.getWebAuthnPolicyTwoFactor(rep);
        newRealm.setWebAuthnPolicy(webAuthnPolicy);
        webAuthnPolicy = RepresentationToModel.getWebAuthnPolicyPasswordless(rep);
        newRealm.setWebAuthnPolicyPasswordless(webAuthnPolicy);
        Map<String, String> mappedFlows = RepresentationToModel.importAuthenticationFlows(newRealm, rep);
        if (rep.getRequiredActions() != null) {
            for (Object action : rep.getRequiredActions()) {
                RequiredActionProviderModel requiredActionProviderModel = RepresentationToModel.toModel((RequiredActionProviderRepresentation)action);
                MigrationUtils.updateOTPRequiredAction(requiredActionProviderModel);
                newRealm.addRequiredActionProvider(requiredActionProviderModel);
            }
        } else {
            DefaultRequiredActions.addActions(newRealm);
        }
        RepresentationToModel.importIdentityProviders(rep, newRealm, session);
        RepresentationToModel.importIdentityProviderMappers(rep, newRealm);
        Map<Object, Object> clientScopes = new HashMap();
        if (rep.getClientScopes() != null) {
            clientScopes = RepresentationToModel.createClientScopes(session, rep.getClientScopes(), newRealm);
        }
        if (rep.getDefaultDefaultClientScopes() != null) {
            for (String string : rep.getDefaultDefaultClientScopes()) {
                clientScope = (ClientScopeModel)clientScopes.get(string);
                if (clientScope != null) {
                    newRealm.addDefaultClientScope(clientScope, true);
                    continue;
                }
                logger.warnf("Referenced client scope '%s' doesn't exists", (Object)string);
            }
        }
        if (rep.getDefaultOptionalClientScopes() != null) {
            for (String string : rep.getDefaultOptionalClientScopes()) {
                clientScope = (ClientScopeModel)clientScopes.get(string);
                if (clientScope != null) {
                    newRealm.addDefaultClientScope(clientScope, false);
                    continue;
                }
                logger.warnf("Referenced client scope '%s' doesn't exists", (Object)string);
            }
        }
        if (rep.getClients() != null) {
            RepresentationToModel.createClients(session, rep, newRealm, mappedFlows);
        }
        RepresentationToModel.importRoles(rep.getRoles(), newRealm);
        if (rep.getDefaultRoles() != null) {
            for (String string : rep.getDefaultRoles()) {
                newRealm.addDefaultRole(string.trim());
            }
        }
        if (rep.getClients() != null) {
            for (ClientRepresentation clientRepresentation : rep.getClients()) {
                if (clientRepresentation.getDefaultRoles() == null) continue;
                ClientModel clientModel = newRealm.getClientByClientId(clientRepresentation.getClientId());
                clientModel.updateDefaultRoles(clientRepresentation.getDefaultRoles());
            }
        }
        if (rep.getClientScopeMappings() != null) {
            for (Map.Entry entry : rep.getClientScopeMappings().entrySet()) {
                ClientModel app = newRealm.getClientByClientId((String)entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                RepresentationToModel.createClientScopeMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getScopeMappings() != null) {
            for (ScopeMappingRepresentation scopeMappingRepresentation : rep.getScopeMappings()) {
                ScopeContainerModel scopeContainer = RepresentationToModel.getScopeContainerHavingScope(newRealm, scopeMappingRepresentation);
                for (String roleString : scopeMappingRepresentation.getRoles()) {
                    RoleModel role = newRealm.getRole(roleString.trim());
                    if (role == null) {
                        role = newRealm.addRole(roleString.trim());
                    }
                    scopeContainer.addScopeMapping(role);
                }
            }
        }
        if (rep.getSmtpServer() != null) {
            newRealm.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            newRealm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        } else {
            newRealm.setBrowserSecurityHeaders(BrowserSecurityHeaders.realmDefaultHeaders);
        }
        if (rep.getComponents() != null) {
            MultivaluedHashMap components = rep.getComponents();
            String string = newRealm.getId();
            RepresentationToModel.importComponents(newRealm, (MultivaluedHashMap<String, ComponentExportRepresentation>)components, string);
        }
        RepresentationToModel.importUserFederationProvidersAndMappers(session, rep, newRealm);
        if (rep.getGroups() != null) {
            RepresentationToModel.importGroups(newRealm, rep);
            if (rep.getDefaultGroups() != null) {
                for (String string : rep.getDefaultGroups()) {
                    GroupModel found = KeycloakModelUtils.findGroupByPath(newRealm, string);
                    if (found == null) {
                        throw new RuntimeException("default group in realm rep doesn't exist: " + string);
                    }
                    newRealm.addDefaultGroup(found);
                }
            }
        }
        if (rep.getUsers() != null) {
            for (UserRepresentation userRepresentation : rep.getUsers()) {
                UserModel userModel = RepresentationToModel.createUser(session, newRealm, userRepresentation);
            }
        }
        if (rep.getFederatedUsers() != null) {
            for (UserRepresentation userRepresentation : rep.getFederatedUsers()) {
                RepresentationToModel.importFederatedUser(session, newRealm, userRepresentation);
            }
        }
        if (!skipUserDependent) {
            RepresentationToModel.importRealmAuthorizationSettings(rep, newRealm, session);
        }
        if (rep.isInternationalizationEnabled() != null) {
            newRealm.setInternationalizationEnabled(rep.isInternationalizationEnabled().booleanValue());
        }
        if (rep.getSupportedLocales() != null) {
            newRealm.setSupportedLocales(new HashSet(rep.getSupportedLocales()));
        }
        if (rep.getDefaultLocale() != null) {
            newRealm.setDefaultLocale(rep.getDefaultLocale());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                newRealm.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (newRealm.getComponents(newRealm.getId(), KeyProvider.class.getName()).isEmpty()) {
            if (rep.getPrivateKey() != null) {
                DefaultKeyProviders.createProviders(newRealm, rep.getPrivateKey(), rep.getCertificate());
            } else {
                DefaultKeyProviders.createProviders(newRealm);
            }
        }
    }

    private static WebAuthnPolicy getWebAuthnPolicyTwoFactor(RealmRepresentation rep) {
        List webAuthnPolicyAcceptableAaguids;
        WebAuthnPolicy webAuthnPolicy = new WebAuthnPolicy();
        String webAuthnPolicyRpEntityName = rep.getWebAuthnPolicyRpEntityName();
        if (webAuthnPolicyRpEntityName == null || webAuthnPolicyRpEntityName.isEmpty()) {
            webAuthnPolicyRpEntityName = "keycloak";
        }
        webAuthnPolicy.setRpEntityName(webAuthnPolicyRpEntityName);
        List<String> webAuthnPolicySignatureAlgorithms = rep.getWebAuthnPolicySignatureAlgorithms();
        if (webAuthnPolicySignatureAlgorithms == null || webAuthnPolicySignatureAlgorithms.isEmpty()) {
            webAuthnPolicySignatureAlgorithms = Arrays.asList("ES256".split(","));
        }
        webAuthnPolicy.setSignatureAlgorithm(webAuthnPolicySignatureAlgorithms);
        String webAuthnPolicyRpId = rep.getWebAuthnPolicyRpId();
        if (webAuthnPolicyRpId == null || webAuthnPolicyRpId.isEmpty()) {
            webAuthnPolicyRpId = "";
        }
        webAuthnPolicy.setRpId(webAuthnPolicyRpId);
        String webAuthnPolicyAttestationConveyancePreference = rep.getWebAuthnPolicyAttestationConveyancePreference();
        if (webAuthnPolicyAttestationConveyancePreference == null || webAuthnPolicyAttestationConveyancePreference.isEmpty()) {
            webAuthnPolicyAttestationConveyancePreference = "not specified";
        }
        webAuthnPolicy.setAttestationConveyancePreference(webAuthnPolicyAttestationConveyancePreference);
        String webAuthnPolicyAuthenticatorAttachment = rep.getWebAuthnPolicyAuthenticatorAttachment();
        if (webAuthnPolicyAuthenticatorAttachment == null || webAuthnPolicyAuthenticatorAttachment.isEmpty()) {
            webAuthnPolicyAuthenticatorAttachment = "not specified";
        }
        webAuthnPolicy.setAuthenticatorAttachment(webAuthnPolicyAuthenticatorAttachment);
        String webAuthnPolicyRequireResidentKey = rep.getWebAuthnPolicyRequireResidentKey();
        if (webAuthnPolicyRequireResidentKey == null || webAuthnPolicyRequireResidentKey.isEmpty()) {
            webAuthnPolicyRequireResidentKey = "not specified";
        }
        webAuthnPolicy.setRequireResidentKey(webAuthnPolicyRequireResidentKey);
        String webAuthnPolicyUserVerificationRequirement = rep.getWebAuthnPolicyUserVerificationRequirement();
        if (webAuthnPolicyUserVerificationRequirement == null || webAuthnPolicyUserVerificationRequirement.isEmpty()) {
            webAuthnPolicyUserVerificationRequirement = "not specified";
        }
        webAuthnPolicy.setUserVerificationRequirement(webAuthnPolicyUserVerificationRequirement);
        Integer webAuthnPolicyCreateTimeout = rep.getWebAuthnPolicyCreateTimeout();
        if (webAuthnPolicyCreateTimeout != null) {
            webAuthnPolicy.setCreateTimeout(webAuthnPolicyCreateTimeout.intValue());
        } else {
            webAuthnPolicy.setCreateTimeout(0);
        }
        Boolean webAuthnPolicyAvoidSameAuthenticatorRegister = rep.isWebAuthnPolicyAvoidSameAuthenticatorRegister();
        if (webAuthnPolicyAvoidSameAuthenticatorRegister != null) {
            webAuthnPolicy.setAvoidSameAuthenticatorRegister(webAuthnPolicyAvoidSameAuthenticatorRegister.booleanValue());
        }
        if ((webAuthnPolicyAcceptableAaguids = rep.getWebAuthnPolicyAcceptableAaguids()) != null) {
            webAuthnPolicy.setAcceptableAaguids(webAuthnPolicyAcceptableAaguids);
        }
        return webAuthnPolicy;
    }

    private static WebAuthnPolicy getWebAuthnPolicyPasswordless(RealmRepresentation rep) {
        List webAuthnPolicyAcceptableAaguids;
        WebAuthnPolicy webAuthnPolicy = new WebAuthnPolicy();
        String webAuthnPolicyRpEntityName = rep.getWebAuthnPolicyPasswordlessRpEntityName();
        if (webAuthnPolicyRpEntityName == null || webAuthnPolicyRpEntityName.isEmpty()) {
            webAuthnPolicyRpEntityName = "keycloak";
        }
        webAuthnPolicy.setRpEntityName(webAuthnPolicyRpEntityName);
        List<String> webAuthnPolicySignatureAlgorithms = rep.getWebAuthnPolicyPasswordlessSignatureAlgorithms();
        if (webAuthnPolicySignatureAlgorithms == null || webAuthnPolicySignatureAlgorithms.isEmpty()) {
            webAuthnPolicySignatureAlgorithms = Arrays.asList("ES256".split(","));
        }
        webAuthnPolicy.setSignatureAlgorithm(webAuthnPolicySignatureAlgorithms);
        String webAuthnPolicyRpId = rep.getWebAuthnPolicyPasswordlessRpId();
        if (webAuthnPolicyRpId == null || webAuthnPolicyRpId.isEmpty()) {
            webAuthnPolicyRpId = "";
        }
        webAuthnPolicy.setRpId(webAuthnPolicyRpId);
        String webAuthnPolicyAttestationConveyancePreference = rep.getWebAuthnPolicyPasswordlessAttestationConveyancePreference();
        if (webAuthnPolicyAttestationConveyancePreference == null || webAuthnPolicyAttestationConveyancePreference.isEmpty()) {
            webAuthnPolicyAttestationConveyancePreference = "not specified";
        }
        webAuthnPolicy.setAttestationConveyancePreference(webAuthnPolicyAttestationConveyancePreference);
        String webAuthnPolicyAuthenticatorAttachment = rep.getWebAuthnPolicyPasswordlessAuthenticatorAttachment();
        if (webAuthnPolicyAuthenticatorAttachment == null || webAuthnPolicyAuthenticatorAttachment.isEmpty()) {
            webAuthnPolicyAuthenticatorAttachment = "not specified";
        }
        webAuthnPolicy.setAuthenticatorAttachment(webAuthnPolicyAuthenticatorAttachment);
        String webAuthnPolicyRequireResidentKey = rep.getWebAuthnPolicyPasswordlessRequireResidentKey();
        if (webAuthnPolicyRequireResidentKey == null || webAuthnPolicyRequireResidentKey.isEmpty()) {
            webAuthnPolicyRequireResidentKey = "not specified";
        }
        webAuthnPolicy.setRequireResidentKey(webAuthnPolicyRequireResidentKey);
        String webAuthnPolicyUserVerificationRequirement = rep.getWebAuthnPolicyPasswordlessUserVerificationRequirement();
        if (webAuthnPolicyUserVerificationRequirement == null || webAuthnPolicyUserVerificationRequirement.isEmpty()) {
            webAuthnPolicyUserVerificationRequirement = "not specified";
        }
        webAuthnPolicy.setUserVerificationRequirement(webAuthnPolicyUserVerificationRequirement);
        Integer webAuthnPolicyCreateTimeout = rep.getWebAuthnPolicyPasswordlessCreateTimeout();
        if (webAuthnPolicyCreateTimeout != null) {
            webAuthnPolicy.setCreateTimeout(webAuthnPolicyCreateTimeout.intValue());
        } else {
            webAuthnPolicy.setCreateTimeout(0);
        }
        Boolean webAuthnPolicyAvoidSameAuthenticatorRegister = rep.isWebAuthnPolicyPasswordlessAvoidSameAuthenticatorRegister();
        if (webAuthnPolicyAvoidSameAuthenticatorRegister != null) {
            webAuthnPolicy.setAvoidSameAuthenticatorRegister(webAuthnPolicyAvoidSameAuthenticatorRegister.booleanValue());
        }
        if ((webAuthnPolicyAcceptableAaguids = rep.getWebAuthnPolicyPasswordlessAcceptableAaguids()) != null) {
            webAuthnPolicy.setAcceptableAaguids(webAuthnPolicyAcceptableAaguids);
        }
        return webAuthnPolicy;
    }

    public static void importUserFederationProvidersAndMappers(KeycloakSession session, RealmRepresentation rep, RealmModel newRealm) {
        HashSet<String> convertSet = new HashSet<String>();
        convertSet.add("ldap");
        convertSet.add("kerberos");
        HashMap<String, String> mapperConvertSet = new HashMap<String, String>();
        mapperConvertSet.put("ldap", "org.keycloak.storage.ldap.mappers.LDAPStorageMapper");
        HashMap<String, ComponentModel> userStorageModels = new HashMap<String, ComponentModel>();
        if (rep.getUserFederationProviders() != null) {
            for (UserFederationProviderRepresentation fedRep : rep.getUserFederationProviders()) {
                if (!convertSet.contains(fedRep.getProviderName())) continue;
                ComponentModel component = RepresentationToModel.convertFedProviderToComponent(newRealm.getId(), fedRep);
                userStorageModels.put(fedRep.getDisplayName(), newRealm.importComponentModel(component));
            }
        }
        HashSet storageProvidersWhichShouldImportDefaultMappers = new HashSet(userStorageModels.keySet());
        if (rep.getUserFederationMappers() != null) {
            for (UserFederationMapperRepresentation representation : rep.getUserFederationMappers()) {
                if (!userStorageModels.containsKey(representation.getFederationProviderDisplayName())) continue;
                ComponentModel parent = (ComponentModel)userStorageModels.get(representation.getFederationProviderDisplayName());
                String newMapperType = (String)mapperConvertSet.get(parent.getProviderId());
                ComponentModel mapper = RepresentationToModel.convertFedMapperToComponent(newRealm, parent, representation, newMapperType);
                newRealm.importComponentModel(mapper);
                storageProvidersWhichShouldImportDefaultMappers.remove(representation.getFederationProviderDisplayName());
            }
        }
        for (String providerDisplayName : storageProvidersWhichShouldImportDefaultMappers) {
            ComponentUtil.notifyCreated(session, newRealm, (ComponentModel)userStorageModels.get(providerDisplayName));
        }
    }

    protected static void importComponents(RealmModel newRealm, MultivaluedHashMap<String, ComponentExportRepresentation> components, String parentId) {
        for (Map.Entry entry : components.entrySet()) {
            String providerType = (String)entry.getKey();
            for (ComponentExportRepresentation compRep : (List)entry.getValue()) {
                ComponentModel component = new ComponentModel();
                component.setId(compRep.getId());
                component.setName(compRep.getName());
                component.setConfig(compRep.getConfig());
                component.setProviderType(providerType);
                component.setProviderId(compRep.getProviderId());
                component.setSubType(compRep.getSubType());
                component.setParentId(parentId);
                component = newRealm.importComponentModel(component);
                if (compRep.getSubComponents() == null) continue;
                RepresentationToModel.importComponents(newRealm, (MultivaluedHashMap<String, ComponentExportRepresentation>)compRep.getSubComponents(), component.getId());
            }
        }
    }

    public static void importRoles(RolesRepresentation realmRoles, RealmModel realm) {
        RoleModel role;
        ClientModel client;
        if (realmRoles == null) {
            return;
        }
        if (realmRoles.getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realmRoles.getRealm()) {
                RepresentationToModel.createRole(realm, roleRepresentation);
            }
        }
        if (realmRoles.getClient() != null) {
            for (Map.Entry entry : realmRoles.getClient().entrySet()) {
                client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                }
                for (RoleRepresentation roleRep : (List)entry.getValue()) {
                    role = roleRep.getId() != null ? client.addRole(roleRep.getId(), roleRep.getName()) : client.addRole(roleRep.getName());
                    role.setDescription(roleRep.getDescription());
                    if (roleRep.getAttributes() == null) continue;
                    roleRep.getAttributes().forEach((key, value) -> role.setAttribute(key, (Collection)value));
                }
            }
        }
        if (realmRoles.getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realmRoles.getRealm()) {
                RoleModel role2 = realm.getRole(roleRepresentation.getName());
                RepresentationToModel.addComposites(role2, roleRepresentation, realm);
            }
        }
        if (realmRoles.getClient() != null) {
            for (Map.Entry entry : realmRoles.getClient().entrySet()) {
                client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                }
                for (RoleRepresentation roleRep : (List)entry.getValue()) {
                    role = client.getRole(roleRep.getName());
                    RepresentationToModel.addComposites(role, roleRep, realm);
                }
            }
        }
    }

    public static void importGroups(RealmModel realm, RealmRepresentation rep) {
        List groups = rep.getGroups();
        if (groups == null) {
            return;
        }
        GroupModel parent = null;
        for (GroupRepresentation group : groups) {
            RepresentationToModel.importGroup(realm, parent, group);
        }
    }

    public static void importGroup(RealmModel realm, GroupModel parent, GroupRepresentation group) {
        GroupModel newGroup = realm.createGroup(group.getId(), group.getName(), parent);
        if (group.getAttributes() != null) {
            for (Map.Entry attr : group.getAttributes().entrySet()) {
                newGroup.setAttribute((String)attr.getKey(), (List)attr.getValue());
            }
        }
        if (group.getRealmRoles() != null) {
            for (String roleString : group.getRealmRoles()) {
                RoleModel role = realm.getRole(roleString.trim());
                if (role == null) {
                    role = realm.addRole(roleString.trim());
                }
                newGroup.grantRole(role);
            }
        }
        if (group.getClientRoles() != null) {
            for (Map.Entry entry : group.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                List roleNames = (List)entry.getValue();
                for (String roleName : roleNames) {
                    RoleModel role = client.getRole(roleName.trim());
                    if (role == null) {
                        role = client.addRole(roleName.trim());
                    }
                    newGroup.grantRole(role);
                }
            }
        }
        if (group.getSubGroups() != null) {
            for (GroupRepresentation subGroup : group.getSubGroups()) {
                RepresentationToModel.importGroup(realm, newGroup, subGroup);
            }
        }
    }

    public static Map<String, String> importAuthenticationFlows(RealmModel newRealm, RealmRepresentation rep) {
        HashMap<String, String> mappedFlows = new HashMap<String, String>();
        if (rep.getAuthenticationFlows() == null) {
            DefaultAuthenticationFlows.migrateFlows(newRealm);
        } else {
            AuthenticatorConfigModel model;
            for (AuthenticatorConfigRepresentation configRep : rep.getAuthenticatorConfig()) {
                if (configRep.getAlias() == null) {
                    throw new IllegalStateException("Provided realm contains authenticator config with null alias. It should be resolved by adding alias to the authenticator config before exporting the realm.");
                }
                model = RepresentationToModel.toModel(configRep);
                newRealm.addAuthenticatorConfig(model);
            }
            for (Object flowRep : rep.getAuthenticationFlows()) {
                model = RepresentationToModel.toModel((AuthenticationFlowRepresentation)flowRep);
                String previousId = model.getId();
                model.setId(null);
                model = newRealm.addAuthenticationFlow((AuthenticationFlowModel)model);
                mappedFlows.put(previousId, model.getId());
            }
            for (Object flowRep : rep.getAuthenticationFlows()) {
                model = newRealm.getFlowByAlias(flowRep.getAlias());
                for (AuthenticationExecutionExportRepresentation exeRep : flowRep.getAuthenticationExecutions()) {
                    AuthenticationExecutionModel execution = RepresentationToModel.toModel(newRealm, (AuthenticationFlowModel)model, exeRep);
                    newRealm.addAuthenticatorExecution(execution);
                }
            }
        }
        if (rep.getBrowserFlow() == null) {
            newRealm.setBrowserFlow(newRealm.getFlowByAlias("browser"));
        } else {
            newRealm.setBrowserFlow(newRealm.getFlowByAlias(rep.getBrowserFlow()));
        }
        if (rep.getRegistrationFlow() == null) {
            newRealm.setRegistrationFlow(newRealm.getFlowByAlias("registration"));
        } else {
            newRealm.setRegistrationFlow(newRealm.getFlowByAlias(rep.getRegistrationFlow()));
        }
        if (rep.getDirectGrantFlow() == null) {
            newRealm.setDirectGrantFlow(newRealm.getFlowByAlias("direct grant"));
        } else {
            newRealm.setDirectGrantFlow(newRealm.getFlowByAlias(rep.getDirectGrantFlow()));
        }
        if (rep.getResetCredentialsFlow() == null) {
            AuthenticationFlowModel resetFlow = newRealm.getFlowByAlias("reset credentials");
            if (resetFlow == null) {
                DefaultAuthenticationFlows.resetCredentialsFlow(newRealm);
            } else {
                newRealm.setResetCredentialsFlow(resetFlow);
            }
        } else {
            newRealm.setResetCredentialsFlow(newRealm.getFlowByAlias(rep.getResetCredentialsFlow()));
        }
        if (rep.getClientAuthenticationFlow() == null) {
            AuthenticationFlowModel clientFlow = newRealm.getFlowByAlias("clients");
            if (clientFlow == null) {
                DefaultAuthenticationFlows.clientAuthFlow(newRealm);
            } else {
                newRealm.setClientAuthenticationFlow(clientFlow);
            }
        } else {
            newRealm.setClientAuthenticationFlow(newRealm.getFlowByAlias(rep.getClientAuthenticationFlow()));
        }
        if (newRealm.getFlowByAlias("first broker login") == null) {
            DefaultAuthenticationFlows.firstBrokerLoginFlow(newRealm, true);
        }
        String defaultProvider = null;
        if (rep.getIdentityProviders() != null) {
            for (IdentityProviderRepresentation i : rep.getIdentityProviders()) {
                if (!i.isEnabled() || !i.isAuthenticateByDefault()) continue;
                defaultProvider = i.getProviderId();
                break;
            }
        }
        if (rep.getDockerAuthenticationFlow() == null) {
            AuthenticationFlowModel dockerAuthenticationFlow = newRealm.getFlowByAlias("docker auth");
            if (dockerAuthenticationFlow == null) {
                DefaultAuthenticationFlows.dockerAuthenticationFlow(newRealm);
            } else {
                newRealm.setDockerAuthenticationFlow(dockerAuthenticationFlow);
            }
        } else {
            newRealm.setDockerAuthenticationFlow(newRealm.getFlowByAlias(rep.getDockerAuthenticationFlow()));
        }
        DefaultAuthenticationFlows.addIdentityProviderAuthenticator(newRealm, defaultProvider);
        return mappedFlows;
    }

    private static void convertDeprecatedSocialProviders(RealmRepresentation rep) {
        if (rep.isSocial() != null && rep.isSocial().booleanValue() && rep.getSocialProviders() != null && !rep.getSocialProviders().isEmpty() && rep.getIdentityProviders() == null) {
            Boolean updateProfileFirstLogin = rep.isUpdateProfileOnInitialSocialLogin() != null && rep.isUpdateProfileOnInitialSocialLogin() != false;
            if (rep.getSocialProviders() != null) {
                logger.warn((Object)"Using deprecated 'social' configuration in JSON representation. It will be removed in future versions");
                LinkedList<IdentityProviderRepresentation> identityProviders = new LinkedList<IdentityProviderRepresentation>();
                for (String k : rep.getSocialProviders().keySet()) {
                    if (!k.endsWith(".key")) continue;
                    String providerId = k.split("\\.")[0];
                    String key = (String)rep.getSocialProviders().get(k);
                    String secret = (String)rep.getSocialProviders().get(k.replace(".key", ".secret"));
                    IdentityProviderRepresentation identityProvider = new IdentityProviderRepresentation();
                    identityProvider.setAlias(providerId);
                    identityProvider.setProviderId(providerId);
                    identityProvider.setEnabled(true);
                    identityProvider.setLinkOnly(false);
                    identityProvider.setUpdateProfileFirstLogin(updateProfileFirstLogin.booleanValue());
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("clientId", key);
                    config.put("clientSecret", secret);
                    identityProvider.setConfig(config);
                    identityProviders.add(identityProvider);
                }
                rep.setIdentityProviders(identityProviders);
            }
        }
    }

    private static void convertDeprecatedSocialProviders(UserRepresentation user) {
        if (user.getSocialLinks() != null && !user.getSocialLinks().isEmpty() && user.getFederatedIdentities() == null) {
            logger.warnf("Using deprecated 'socialLinks' configuration in JSON representation for user '%s'. It will be removed in future versions", (Object)user.getUsername());
            LinkedList<FederatedIdentityRepresentation> federatedIdentities = new LinkedList<FederatedIdentityRepresentation>();
            for (SocialLinkRepresentation social : user.getSocialLinks()) {
                FederatedIdentityRepresentation federatedIdentity = new FederatedIdentityRepresentation();
                federatedIdentity.setIdentityProvider(social.getSocialProvider());
                federatedIdentity.setUserId(social.getSocialUserId());
                federatedIdentity.setUserName(social.getSocialUsername());
                federatedIdentities.add(federatedIdentity);
            }
            user.setFederatedIdentities(federatedIdentities);
        }
        user.setSocialLinks(null);
    }

    private static void convertDeprecatedApplications(KeycloakSession session, RealmRepresentation realm) {
        if (realm.getApplications() != null || realm.getOauthClients() != null) {
            if (realm.getClients() == null) {
                realm.setClients(new LinkedList());
            }
            LinkedList clients = new LinkedList();
            if (realm.getApplications() != null) {
                clients.addAll(realm.getApplications());
            }
            if (realm.getOauthClients() != null) {
                clients.addAll(realm.getOauthClients());
            }
            for (ApplicationRepresentation app : clients) {
                app.setClientId(app.getName());
                app.setName(null);
                if (app instanceof OAuthClientRepresentation) {
                    app.setConsentRequired(Boolean.valueOf(true));
                    app.setFullScopeAllowed(Boolean.valueOf(false));
                }
                if (app.getProtocolMappers() == null && app.getClaims() != null) {
                    long mask = RepresentationToModel.getClaimsMask(app.getClaims());
                    List<ProtocolMapperRepresentation> convertedProtocolMappers = ((MigrationProvider)session.getProvider(MigrationProvider.class)).getMappersForClaimMask(mask);
                    app.setProtocolMappers(convertedProtocolMappers);
                    app.setClaims(null);
                }
                realm.getClients().add(app);
            }
        }
        if (realm.getApplicationScopeMappings() != null && realm.getClientScopeMappings() == null) {
            realm.setClientScopeMappings(realm.getApplicationScopeMappings());
        }
        if (realm.getRoles() != null && realm.getRoles().getApplication() != null && realm.getRoles().getClient() == null) {
            realm.getRoles().setClient(realm.getRoles().getApplication());
        }
        if (realm.getUsers() != null) {
            for (UserRepresentation userRepresentation : realm.getUsers()) {
                if (userRepresentation.getApplicationRoles() == null || userRepresentation.getClientRoles() != null) continue;
                userRepresentation.setClientRoles(userRepresentation.getApplicationRoles());
            }
        }
        if (realm.getRoles() != null && realm.getRoles().getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realm.getRoles().getRealm()) {
                if (roleRepresentation.getComposites() == null || roleRepresentation.getComposites().getApplication() == null || roleRepresentation.getComposites().getClient() != null) continue;
                roleRepresentation.getComposites().setClient(roleRepresentation.getComposites().getApplication());
            }
        }
        if (realm.getRoles() != null && realm.getRoles().getClient() != null) {
            for (Map.Entry entry : realm.getRoles().getClient().entrySet()) {
                for (RoleRepresentation role : (List)entry.getValue()) {
                    if (role.getComposites() == null || role.getComposites().getApplication() == null || role.getComposites().getClient() != null) continue;
                    role.getComposites().setClient(role.getComposites().getApplication());
                }
            }
        }
    }

    private static void convertDeprecatedClientTemplates(RealmRepresentation realm) {
        if (realm.getClientTemplates() != null) {
            logger.warnf("Using deprecated 'clientTemplates' configuration in JSON representation for realm '%s'. It will be removed in future versions", (Object)realm.getRealm());
            LinkedList<ClientScopeRepresentation> clientScopes = new LinkedList<ClientScopeRepresentation>();
            for (ClientTemplateRepresentation template : realm.getClientTemplates()) {
                ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
                scopeRep.setId(template.getId());
                scopeRep.setName(template.getName());
                scopeRep.setProtocol(template.getProtocol());
                scopeRep.setDescription(template.getDescription());
                scopeRep.setAttributes(template.getAttributes());
                scopeRep.setProtocolMappers(template.getProtocolMappers());
                clientScopes.add(scopeRep);
            }
            realm.setClientScopes(clientScopes);
        }
    }

    private static void convertDeprecatedCredentialsFormat(UserRepresentation user) {
        if (user.getCredentials() != null) {
            for (CredentialRepresentation cred : user.getCredentials()) {
                try {
                    PasswordCredentialData credentialData;
                    if (cred.getCredentialData() != null && cred.getSecretData() != null || cred.getValue() != null) continue;
                    logger.warnf("Using deprecated 'credentials' format in JSON representation for user '%s'. It will be removed in future versions", (Object)user.getUsername());
                    if ("password".equals(cred.getType()) || "password-history".equals(cred.getType())) {
                        credentialData = new PasswordCredentialData(cred.getHashIterations().intValue(), cred.getAlgorithm());
                        cred.setCredentialData(JsonSerialization.writeValueAsString((Object)credentialData));
                        cred.setSecretData("{\"value\":\"" + cred.getHashedSaltedValue() + "\",\"salt\":\"" + cred.getSalt() + "\"}");
                        cred.setPriority(Integer.valueOf(10));
                        continue;
                    }
                    if (!"totp".equals(cred.getType()) && !"hotp".equals(cred.getType())) continue;
                    credentialData = new OTPCredentialData(cred.getType(), cred.getDigits().intValue(), cred.getCounter().intValue(), cred.getPeriod().intValue(), cred.getAlgorithm());
                    OTPSecretData secretData = new OTPSecretData(cred.getHashedSaltedValue());
                    cred.setCredentialData(JsonSerialization.writeValueAsString((Object)credentialData));
                    cred.setSecretData(JsonSerialization.writeValueAsString((Object)secretData));
                    cred.setPriority(Integer.valueOf(20));
                    cred.setType("otp");
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }

    public static void renameRealm(RealmModel realm, String name) {
        ClientModel accountClient;
        if (name.equals(realm.getName())) {
            return;
        }
        String oldName = realm.getName();
        ClientModel masterApp = realm.getMasterAdminClient();
        masterApp.setClientId(KeycloakModelUtils.getMasterRealmAdminApplicationClientId(name));
        realm.setName(name);
        ClientModel adminClient = realm.getClientByClientId("security-admin-console");
        if (adminClient != null) {
            if (adminClient.getBaseUrl() != null) {
                adminClient.setBaseUrl(adminClient.getBaseUrl().replace("/admin/" + oldName + "/", "/admin/" + name + "/"));
            }
            HashSet<String> adminRedirectUris = new HashSet<String>();
            for (String r : adminClient.getRedirectUris()) {
                adminRedirectUris.add(RepresentationToModel.replace(r, "/admin/" + oldName + "/", "/admin/" + name + "/"));
            }
            adminClient.setRedirectUris(adminRedirectUris);
        }
        if ((accountClient = realm.getClientByClientId("account")) != null) {
            if (accountClient.getBaseUrl() != null) {
                accountClient.setBaseUrl(accountClient.getBaseUrl().replace("/realms/" + oldName + "/", "/realms/" + name + "/"));
            }
            HashSet<String> accountRedirectUris = new HashSet<String>();
            for (String r : accountClient.getRedirectUris()) {
                accountRedirectUris.add(RepresentationToModel.replace(r, "/realms/" + oldName + "/", "/realms/" + name + "/"));
            }
            accountClient.setRedirectUris(accountRedirectUris);
        }
    }

    private static String replace(String url, String target, String replacement) {
        return url != null ? url.replace(target, replacement) : null;
    }

    public static void updateRealm(RealmRepresentation rep, RealmModel realm, KeycloakSession session) {
        if (rep.getRealm() != null) {
            RepresentationToModel.renameRealm(realm, rep.getRealm());
        }
        if (rep.getAttributes() != null) {
            HashSet attrsToRemove = new HashSet(realm.getAttributes().keySet());
            attrsToRemove.removeAll(rep.getAttributes().keySet());
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                realm.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            for (String attr : attrsToRemove) {
                realm.removeAttribute(attr);
            }
        }
        if (rep.getDisplayName() != null) {
            realm.setDisplayName(rep.getDisplayName());
        }
        if (rep.getDisplayNameHtml() != null) {
            realm.setDisplayNameHtml(rep.getDisplayNameHtml());
        }
        if (rep.isEnabled() != null) {
            realm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isUserManagedAccessAllowed() != null) {
            realm.setUserManagedAccessAllowed(rep.isUserManagedAccessAllowed().booleanValue());
        }
        if (rep.isBruteForceProtected() != null) {
            realm.setBruteForceProtected(rep.isBruteForceProtected().booleanValue());
        }
        if (rep.isPermanentLockout() != null) {
            realm.setPermanentLockout(rep.isPermanentLockout().booleanValue());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            realm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds().intValue());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            realm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds().intValue());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            realm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds().intValue());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            realm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds().longValue());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            realm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds().intValue());
        }
        if (rep.getFailureFactor() != null) {
            realm.setFailureFactor(rep.getFailureFactor().intValue());
        }
        if (rep.isRegistrationAllowed() != null) {
            realm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isRegistrationEmailAsUsername() != null) {
            realm.setRegistrationEmailAsUsername(rep.isRegistrationEmailAsUsername().booleanValue());
        }
        if (rep.isRememberMe() != null) {
            realm.setRememberMe(rep.isRememberMe().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            realm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isLoginWithEmailAllowed() != null) {
            realm.setLoginWithEmailAllowed(rep.isLoginWithEmailAllowed().booleanValue());
        }
        if (rep.isDuplicateEmailsAllowed() != null) {
            realm.setDuplicateEmailsAllowed(rep.isDuplicateEmailsAllowed().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            realm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isEditUsernameAllowed() != null) {
            realm.setEditUsernameAllowed(rep.isEditUsernameAllowed().booleanValue());
        }
        if (rep.getSslRequired() != null) {
            realm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.getAccessCodeLifespan() != null) {
            realm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            realm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        }
        if (rep.getAccessCodeLifespanLogin() != null) {
            realm.setAccessCodeLifespanLogin(rep.getAccessCodeLifespanLogin().intValue());
        }
        if (rep.getActionTokenGeneratedByAdminLifespan() != null) {
            realm.setActionTokenGeneratedByAdminLifespan(rep.getActionTokenGeneratedByAdminLifespan().intValue());
        }
        if (rep.getActionTokenGeneratedByUserLifespan() != null) {
            realm.setActionTokenGeneratedByUserLifespan(rep.getActionTokenGeneratedByUserLifespan().intValue());
        }
        if (rep.getNotBefore() != null) {
            realm.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getDefaultSignatureAlgorithm() != null) {
            realm.setDefaultSignatureAlgorithm(rep.getDefaultSignatureAlgorithm());
        }
        if (rep.getRevokeRefreshToken() != null) {
            realm.setRevokeRefreshToken(rep.getRevokeRefreshToken().booleanValue());
        }
        if (rep.getRefreshTokenMaxReuse() != null) {
            realm.setRefreshTokenMaxReuse(rep.getRefreshTokenMaxReuse().intValue());
        }
        if (rep.getAccessTokenLifespan() != null) {
            realm.setAccessTokenLifespan(rep.getAccessTokenLifespan().intValue());
        }
        if (rep.getAccessTokenLifespanForImplicitFlow() != null) {
            realm.setAccessTokenLifespanForImplicitFlow(rep.getAccessTokenLifespanForImplicitFlow().intValue());
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            realm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout().intValue());
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            realm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan().intValue());
        }
        if (rep.getSsoSessionIdleTimeoutRememberMe() != null) {
            realm.setSsoSessionIdleTimeoutRememberMe(rep.getSsoSessionIdleTimeoutRememberMe().intValue());
        }
        if (rep.getSsoSessionMaxLifespanRememberMe() != null) {
            realm.setSsoSessionMaxLifespanRememberMe(rep.getSsoSessionMaxLifespanRememberMe().intValue());
        }
        if (rep.getOfflineSessionIdleTimeout() != null) {
            realm.setOfflineSessionIdleTimeout(rep.getOfflineSessionIdleTimeout().intValue());
        }
        if (rep.getOfflineSessionMaxLifespanEnabled() != null) {
            realm.setOfflineSessionMaxLifespanEnabled(rep.getOfflineSessionMaxLifespanEnabled().booleanValue());
        }
        if (rep.getOfflineSessionMaxLifespan() != null) {
            realm.setOfflineSessionMaxLifespan(rep.getOfflineSessionMaxLifespan().intValue());
        }
        if (rep.getClientSessionIdleTimeout() != null) {
            realm.setClientSessionIdleTimeout(rep.getClientSessionIdleTimeout().intValue());
        }
        if (rep.getClientSessionMaxLifespan() != null) {
            realm.setClientSessionMaxLifespan(rep.getClientSessionMaxLifespan().intValue());
        }
        if (rep.getClientOfflineSessionIdleTimeout() != null) {
            realm.setClientOfflineSessionIdleTimeout(rep.getClientOfflineSessionIdleTimeout().intValue());
        }
        if (rep.getClientOfflineSessionMaxLifespan() != null) {
            realm.setClientOfflineSessionMaxLifespan(rep.getClientOfflineSessionMaxLifespan().intValue());
        }
        if (rep.getRequiredCredentials() != null) {
            realm.updateRequiredCredentials(rep.getRequiredCredentials());
        }
        if (rep.getLoginTheme() != null) {
            realm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            realm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            realm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            realm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.isEventsEnabled() != null) {
            realm.setEventsEnabled(rep.isEventsEnabled().booleanValue());
        }
        if (rep.getEventsExpiration() != null) {
            realm.setEventsExpiration(rep.getEventsExpiration().longValue());
        }
        if (rep.getEventsListeners() != null) {
            realm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.getEnabledEventTypes() != null) {
            realm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            realm.setAdminEventsEnabled(rep.isAdminEventsEnabled().booleanValue());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            realm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled().booleanValue());
        }
        if (rep.getPasswordPolicy() != null) {
            realm.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)rep.getPasswordPolicy()));
        }
        if (rep.getOtpPolicyType() != null) {
            realm.setOTPPolicy(RepresentationToModel.toPolicy(rep));
        }
        if (rep.getDefaultRoles() != null) {
            realm.updateDefaultRoles(rep.getDefaultRoles().toArray(new String[rep.getDefaultRoles().size()]));
        }
        WebAuthnPolicy webAuthnPolicy = RepresentationToModel.getWebAuthnPolicyTwoFactor(rep);
        realm.setWebAuthnPolicy(webAuthnPolicy);
        webAuthnPolicy = RepresentationToModel.getWebAuthnPolicyPasswordless(rep);
        realm.setWebAuthnPolicyPasswordless(webAuthnPolicy);
        if (rep.getSmtpServer() != null) {
            HashMap<String, String> config = new HashMap<String, String>(rep.getSmtpServer());
            if (rep.getSmtpServer().containsKey("password") && "**********".equals(rep.getSmtpServer().get("password"))) {
                String passwordValue = realm.getSmtpConfig() != null ? (String)realm.getSmtpConfig().get("password") : null;
                config.put("password", passwordValue);
            }
            realm.setSmtpConfig(config);
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            realm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        }
        if (rep.isInternationalizationEnabled() != null) {
            realm.setInternationalizationEnabled(rep.isInternationalizationEnabled().booleanValue());
        }
        if (rep.getSupportedLocales() != null) {
            realm.setSupportedLocales(new HashSet(rep.getSupportedLocales()));
        }
        if (rep.getDefaultLocale() != null) {
            realm.setDefaultLocale(rep.getDefaultLocale());
        }
        if (rep.getBrowserFlow() != null) {
            realm.setBrowserFlow(realm.getFlowByAlias(rep.getBrowserFlow()));
        }
        if (rep.getRegistrationFlow() != null) {
            realm.setRegistrationFlow(realm.getFlowByAlias(rep.getRegistrationFlow()));
        }
        if (rep.getDirectGrantFlow() != null) {
            realm.setDirectGrantFlow(realm.getFlowByAlias(rep.getDirectGrantFlow()));
        }
        if (rep.getResetCredentialsFlow() != null) {
            realm.setResetCredentialsFlow(realm.getFlowByAlias(rep.getResetCredentialsFlow()));
        }
        if (rep.getClientAuthenticationFlow() != null) {
            realm.setClientAuthenticationFlow(realm.getFlowByAlias(rep.getClientAuthenticationFlow()));
        }
        if (rep.getDockerAuthenticationFlow() != null) {
            realm.setDockerAuthenticationFlow(realm.getFlowByAlias(rep.getDockerAuthenticationFlow()));
        }
    }

    public static ComponentModel convertFedProviderToComponent(String realmId, UserFederationProviderRepresentation fedModel) {
        UserStorageProviderModel model = new UserStorageProviderModel();
        model.setId(fedModel.getId());
        model.setName(fedModel.getDisplayName());
        model.setParentId(realmId);
        model.setProviderId(fedModel.getProviderName());
        model.setProviderType(UserStorageProvider.class.getName());
        model.setFullSyncPeriod(fedModel.getFullSyncPeriod());
        model.setPriority(fedModel.getPriority());
        model.setChangedSyncPeriod(fedModel.getChangedSyncPeriod());
        model.setLastSync(fedModel.getLastSync());
        if (fedModel.getConfig() != null) {
            for (Map.Entry entry : fedModel.getConfig().entrySet()) {
                model.getConfig().putSingle(entry.getKey(), entry.getValue());
            }
        }
        return model;
    }

    public static ComponentModel convertFedMapperToComponent(RealmModel realm, ComponentModel parent, UserFederationMapperRepresentation rep, String newMapperType) {
        ComponentModel mapper = new ComponentModel();
        mapper.setId(rep.getId());
        mapper.setName(rep.getName());
        mapper.setProviderId(rep.getFederationMapperType());
        mapper.setProviderType(newMapperType);
        mapper.setParentId(parent.getId());
        if (rep.getConfig() != null) {
            for (Map.Entry entry : rep.getConfig().entrySet()) {
                mapper.getConfig().putSingle(entry.getKey(), entry.getValue());
            }
        }
        return mapper;
    }

    public static void createRole(RealmModel newRealm, RoleRepresentation roleRep) {
        RoleModel role;
        RoleModel roleModel = role = roleRep.getId() != null ? newRealm.addRole(roleRep.getId(), roleRep.getName()) : newRealm.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
        if (roleRep.getAttributes() != null) {
            for (Map.Entry attribute : roleRep.getAttributes().entrySet()) {
                role.setAttribute((String)attribute.getKey(), (Collection)attribute.getValue());
            }
        }
    }

    private static void addComposites(RoleModel role, RoleRepresentation roleRep, RealmModel realm) {
        if (roleRep.getComposites() == null) {
            return;
        }
        if (roleRep.getComposites().getRealm() != null) {
            for (String string : roleRep.getComposites().getRealm()) {
                RoleModel realmRole = realm.getRole(string);
                if (realmRole == null) {
                    throw new RuntimeException("Unable to find composite realm role: " + string);
                }
                role.addCompositeRole(realmRole);
            }
        }
        if (roleRep.getComposites().getClient() != null) {
            for (Map.Entry entry : roleRep.getComposites().getClient().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + roleRep.getName());
                }
                for (String roleStr : (List)entry.getValue()) {
                    RoleModel clientRole = client.getRole(roleStr);
                    if (clientRole == null) {
                        throw new RuntimeException("Unable to find composite client role: " + roleStr);
                    }
                    role.addCompositeRole(clientRole);
                }
            }
        }
    }

    private static Map<String, ClientModel> createClients(KeycloakSession session, RealmRepresentation rep, RealmModel realm, Map<String, String> mappedFlows) {
        HashMap<String, ClientModel> appMap = new HashMap<String, ClientModel>();
        for (ClientRepresentation resourceRep : rep.getClients()) {
            ClientModel app = RepresentationToModel.createClient(session, realm, resourceRep, false, mappedFlows);
            appMap.put(app.getClientId(), app);
            ValidationUtil.validateClient(session, app, false, r -> {
                throw new RuntimeException("Invalid client " + app.getClientId() + ": " + r.getAllErrorsAsString());
            });
        }
        return appMap;
    }

    public static ClientModel createClient(KeycloakSession session, RealmModel realm, ClientRepresentation resourceRep, boolean addDefaultRoles) {
        return RepresentationToModel.createClient(session, realm, resourceRep, addDefaultRoles, null);
    }

    private static ClientModel createClient(KeycloakSession session, RealmModel realm, ClientRepresentation resourceRep, boolean addDefaultRoles, Map<String, String> mappedFlows) {
        ClientModel client;
        logger.debugv("Create client: {0}", (Object)resourceRep.getClientId());
        ClientModel clientModel = client = resourceRep.getId() != null ? realm.addClient(resourceRep.getId(), resourceRep.getClientId()) : realm.addClient(resourceRep.getClientId());
        if (resourceRep.getName() != null) {
            client.setName(resourceRep.getName());
        }
        if (resourceRep.getDescription() != null) {
            client.setDescription(resourceRep.getDescription());
        }
        if (resourceRep.isEnabled() != null) {
            client.setEnabled(resourceRep.isEnabled().booleanValue());
        }
        if (resourceRep.isAlwaysDisplayInConsole() != null) {
            client.setAlwaysDisplayInConsole(resourceRep.isAlwaysDisplayInConsole().booleanValue());
        }
        client.setManagementUrl(resourceRep.getAdminUrl());
        if (resourceRep.isSurrogateAuthRequired() != null) {
            client.setSurrogateAuthRequired(resourceRep.isSurrogateAuthRequired().booleanValue());
        }
        if (resourceRep.getRootUrl() != null) {
            client.setRootUrl(resourceRep.getRootUrl());
        }
        if (resourceRep.getBaseUrl() != null) {
            client.setBaseUrl(resourceRep.getBaseUrl());
        }
        if (resourceRep.isBearerOnly() != null) {
            client.setBearerOnly(resourceRep.isBearerOnly().booleanValue());
        }
        if (resourceRep.isConsentRequired() != null) {
            client.setConsentRequired(resourceRep.isConsentRequired().booleanValue());
        }
        if (resourceRep.isDirectGrantsOnly() != null) {
            logger.warn((Object)"Using deprecated 'directGrantsOnly' configuration in JSON representation. It will be removed in future versions");
            client.setStandardFlowEnabled(resourceRep.isDirectGrantsOnly() == false);
            client.setDirectAccessGrantsEnabled(resourceRep.isDirectGrantsOnly().booleanValue());
        }
        if (resourceRep.isStandardFlowEnabled() != null) {
            client.setStandardFlowEnabled(resourceRep.isStandardFlowEnabled().booleanValue());
        }
        if (resourceRep.isImplicitFlowEnabled() != null) {
            client.setImplicitFlowEnabled(resourceRep.isImplicitFlowEnabled().booleanValue());
        }
        if (resourceRep.isDirectAccessGrantsEnabled() != null) {
            client.setDirectAccessGrantsEnabled(resourceRep.isDirectAccessGrantsEnabled().booleanValue());
        }
        if (resourceRep.isServiceAccountsEnabled() != null) {
            client.setServiceAccountsEnabled(resourceRep.isServiceAccountsEnabled().booleanValue());
        }
        if (resourceRep.isPublicClient() != null) {
            client.setPublicClient(resourceRep.isPublicClient().booleanValue());
        }
        if (resourceRep.isFrontchannelLogout() != null) {
            client.setFrontchannelLogout(resourceRep.isFrontchannelLogout().booleanValue());
        }
        if (resourceRep.getProtocol() != null) {
            client.setProtocol(resourceRep.getProtocol());
        } else {
            client.setProtocol(OIDC);
        }
        if (resourceRep.getNodeReRegistrationTimeout() != null) {
            client.setNodeReRegistrationTimeout(resourceRep.getNodeReRegistrationTimeout().intValue());
        } else {
            client.setNodeReRegistrationTimeout(-1);
        }
        if (resourceRep.getNotBefore() != null) {
            client.setNotBefore(resourceRep.getNotBefore().intValue());
        }
        if (resourceRep.getClientAuthenticatorType() != null) {
            client.setClientAuthenticatorType(resourceRep.getClientAuthenticatorType());
        } else {
            client.setClientAuthenticatorType(KeycloakModelUtils.getDefaultClientAuthenticatorType());
        }
        client.setSecret(resourceRep.getSecret());
        if (client.getSecret() == null) {
            KeycloakModelUtils.generateSecret(client);
        }
        if (resourceRep.getAttributes() != null) {
            for (Map.Entry entry : resourceRep.getAttributes().entrySet()) {
                client.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (resourceRep.getAuthenticationFlowBindingOverrides() != null) {
            for (Map.Entry entry : resourceRep.getAuthenticationFlowBindingOverrides().entrySet()) {
                if (entry.getValue() == null || ((String)entry.getValue()).trim().equals("")) continue;
                String flowId = (String)entry.getValue();
                if (mappedFlows != null && mappedFlows.containsKey(flowId)) {
                    flowId = mappedFlows.get(flowId);
                }
                if (client.getRealm().getAuthenticationFlowById(flowId) == null) {
                    throw new RuntimeException("Unable to resolve auth flow binding override for: " + (String)entry.getKey());
                }
                client.setAuthenticationFlowBindingOverride((String)entry.getKey(), flowId);
            }
        }
        if (resourceRep.getRedirectUris() != null) {
            for (String string : resourceRep.getRedirectUris()) {
                client.addRedirectUri(string);
            }
        }
        if (resourceRep.getWebOrigins() != null) {
            for (String string : resourceRep.getWebOrigins()) {
                logger.debugv("Client: {0} webOrigin: {1}", (Object)resourceRep.getClientId(), (Object)string);
                client.addWebOrigin(string);
            }
        } else if (resourceRep.getRedirectUris() != null) {
            HashSet origins = new HashSet();
            for (String redirectUri : resourceRep.getRedirectUris()) {
                logger.debugv("add redirect-uri to origin: {0}", (Object)redirectUri);
                if (!redirectUri.startsWith("http")) continue;
                String origin = UriUtils.getOrigin((String)redirectUri);
                logger.debugv("adding default client origin: {0}", (Object)origin);
                origins.add(origin);
            }
            if (origins.size() > 0) {
                client.setWebOrigins((Set)origins);
            }
        }
        if (resourceRep.getRegisteredNodes() != null) {
            for (Map.Entry entry : resourceRep.getRegisteredNodes().entrySet()) {
                client.registerNode((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
        }
        if (addDefaultRoles && resourceRep.getDefaultRoles() != null) {
            client.updateDefaultRoles(resourceRep.getDefaultRoles());
        }
        if (resourceRep.getProtocolMappers() != null) {
            Set mappers = client.getProtocolMappers();
            for (ProtocolMapperModel mapper : mappers) {
                client.removeProtocolMapper(mapper);
            }
            for (ProtocolMapperModel mapper : resourceRep.getProtocolMappers()) {
                client.addProtocolMapper(RepresentationToModel.toModel((ProtocolMapperRepresentation)mapper));
            }
            MigrationUtils.updateProtocolMappers((ProtocolMapperContainerModel)client);
        }
        if (resourceRep.getClientTemplate() != null) {
            String clientTemplateName = KeycloakModelUtils.convertClientScopeName(resourceRep.getClientTemplate());
            RepresentationToModel.addClientScopeToClient(realm, client, clientTemplateName, true);
        }
        if (resourceRep.getDefaultClientScopes() != null || resourceRep.getOptionalClientScopes() != null) {
            for (ClientScopeModel clientScopeModel : client.getClientScopes(true, false).values()) {
                client.removeClientScope(clientScopeModel);
            }
            for (ClientScopeModel clientScopeModel : client.getClientScopes(false, false).values()) {
                client.removeClientScope(clientScopeModel);
            }
        }
        if (resourceRep.getDefaultClientScopes() != null) {
            for (String string : resourceRep.getDefaultClientScopes()) {
                RepresentationToModel.addClientScopeToClient(realm, client, string, true);
            }
        }
        if (resourceRep.getOptionalClientScopes() != null) {
            for (String string : resourceRep.getOptionalClientScopes()) {
                RepresentationToModel.addClientScopeToClient(realm, client, string, false);
            }
        }
        if (resourceRep.isFullScopeAllowed() != null) {
            client.setFullScopeAllowed(resourceRep.isFullScopeAllowed().booleanValue());
        } else {
            client.setFullScopeAllowed(!client.isConsentRequired());
        }
        client.updateClient();
        resourceRep.setId(client.getId());
        return client;
    }

    private static void addClientScopeToClient(RealmModel realm, ClientModel client, String clientScopeName, boolean defaultScope) {
        ClientScopeModel clientScope = KeycloakModelUtils.getClientScopeByName(realm, clientScopeName);
        if (clientScope != null) {
            client.addClientScope(clientScope, defaultScope);
        } else {
            logger.warnf("Referenced client scope '%s' doesn't exists. Ignoring", (Object)clientScopeName);
        }
    }

    public static void updateClient(ClientRepresentation rep, ClientModel resource) {
        List list;
        List redirectUris;
        if (rep.getClientId() != null) {
            resource.setClientId(rep.getClientId());
        }
        if (rep.getName() != null) {
            resource.setName(rep.getName());
        }
        if (rep.getDescription() != null) {
            resource.setDescription(rep.getDescription());
        }
        if (rep.isEnabled() != null) {
            resource.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isAlwaysDisplayInConsole() != null) {
            resource.setAlwaysDisplayInConsole(rep.isAlwaysDisplayInConsole().booleanValue());
        }
        if (rep.isBearerOnly() != null) {
            resource.setBearerOnly(rep.isBearerOnly().booleanValue());
        }
        if (rep.isConsentRequired() != null) {
            resource.setConsentRequired(rep.isConsentRequired().booleanValue());
        }
        if (rep.isStandardFlowEnabled() != null) {
            resource.setStandardFlowEnabled(rep.isStandardFlowEnabled().booleanValue());
        }
        if (rep.isImplicitFlowEnabled() != null) {
            resource.setImplicitFlowEnabled(rep.isImplicitFlowEnabled().booleanValue());
        }
        if (rep.isDirectAccessGrantsEnabled() != null) {
            resource.setDirectAccessGrantsEnabled(rep.isDirectAccessGrantsEnabled().booleanValue());
        }
        if (rep.isServiceAccountsEnabled() != null) {
            resource.setServiceAccountsEnabled(rep.isServiceAccountsEnabled().booleanValue());
        }
        if (rep.isPublicClient() != null) {
            resource.setPublicClient(rep.isPublicClient().booleanValue());
        }
        if (rep.isFullScopeAllowed() != null) {
            resource.setFullScopeAllowed(rep.isFullScopeAllowed().booleanValue());
        }
        if (rep.isFrontchannelLogout() != null) {
            resource.setFrontchannelLogout(rep.isFrontchannelLogout().booleanValue());
        }
        if (rep.getRootUrl() != null) {
            resource.setRootUrl(rep.getRootUrl());
        }
        if (rep.getAdminUrl() != null) {
            resource.setManagementUrl(rep.getAdminUrl());
        }
        if (rep.getBaseUrl() != null) {
            resource.setBaseUrl(rep.getBaseUrl());
        }
        if (rep.isSurrogateAuthRequired() != null) {
            resource.setSurrogateAuthRequired(rep.isSurrogateAuthRequired().booleanValue());
        }
        if (rep.getNodeReRegistrationTimeout() != null) {
            resource.setNodeReRegistrationTimeout(rep.getNodeReRegistrationTimeout().intValue());
        }
        if (rep.getClientAuthenticatorType() != null) {
            resource.setClientAuthenticatorType(rep.getClientAuthenticatorType());
        }
        if (rep.getProtocol() != null) {
            resource.setProtocol(rep.getProtocol());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                resource.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry<Object, Object> entry : RepresentationToModel.removeEmptyString(rep.getAttributes()).entrySet()) {
                resource.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (rep.getAuthenticationFlowBindingOverrides() != null) {
            for (Map.Entry<Object, Object> entry : rep.getAuthenticationFlowBindingOverrides().entrySet()) {
                if (entry.getValue() == null || ((String)entry.getValue()).trim().equals("")) {
                    resource.removeAuthenticationFlowBindingOverride((String)entry.getKey());
                    continue;
                }
                String flowId = (String)entry.getValue();
                if (resource.getRealm().getAuthenticationFlowById(flowId) == null) {
                    throw new RuntimeException("Unable to resolve auth flow binding override for: " + (String)entry.getKey());
                }
                resource.setAuthenticationFlowBindingOverride((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (rep.getNotBefore() != null) {
            resource.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getDefaultRoles() != null) {
            resource.updateDefaultRoles(rep.getDefaultRoles());
        }
        if ((redirectUris = rep.getRedirectUris()) != null) {
            resource.setRedirectUris(new HashSet(redirectUris));
        }
        if ((list = rep.getWebOrigins()) != null) {
            resource.setWebOrigins(new HashSet(list));
        }
        if (rep.getRegisteredNodes() != null) {
            for (Map.Entry entry : rep.getRegisteredNodes().entrySet()) {
                resource.registerNode((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
        }
        if (rep.getSecret() != null) {
            resource.setSecret(rep.getSecret());
        }
        resource.updateClient();
    }

    public static void updateClientProtocolMappers(ClientRepresentation rep, ClientModel resource) {
        if (rep.getProtocolMappers() != null) {
            HashMap<String, ProtocolMapperModel> existingProtocolMappers = new HashMap<String, ProtocolMapperModel>();
            for (ProtocolMapperModel protocolMapperModel : resource.getProtocolMappers()) {
                existingProtocolMappers.put(RepresentationToModel.generateProtocolNameKey(protocolMapperModel.getProtocol(), protocolMapperModel.getName()), protocolMapperModel);
            }
            for (ProtocolMapperRepresentation protocolMapperRepresentation : rep.getProtocolMappers()) {
                String protocolNameKey = RepresentationToModel.generateProtocolNameKey(protocolMapperRepresentation.getProtocol(), protocolMapperRepresentation.getName());
                ProtocolMapperModel existingMapper = (ProtocolMapperModel)existingProtocolMappers.get(protocolNameKey);
                if (existingMapper != null) {
                    ProtocolMapperModel updatedProtocolMapperModel = RepresentationToModel.toModel(protocolMapperRepresentation);
                    updatedProtocolMapperModel.setId(existingMapper.getId());
                    resource.updateProtocolMapper(updatedProtocolMapperModel);
                    existingProtocolMappers.remove(protocolNameKey);
                    continue;
                }
                resource.addProtocolMapper(RepresentationToModel.toModel(protocolMapperRepresentation));
            }
            for (Map.Entry entry : existingProtocolMappers.entrySet()) {
                resource.removeProtocolMapper((ProtocolMapperModel)entry.getValue());
            }
        }
    }

    private static String generateProtocolNameKey(String protocol, String name) {
        return String.format("%s%%%s", protocol, name);
    }

    private static Map<String, ClientScopeModel> createClientScopes(KeycloakSession session, List<ClientScopeRepresentation> clientScopes, RealmModel realm) {
        HashMap<String, ClientScopeModel> appMap = new HashMap<String, ClientScopeModel>();
        for (ClientScopeRepresentation resourceRep : clientScopes) {
            ClientScopeModel app = RepresentationToModel.createClientScope(session, realm, resourceRep);
            appMap.put(app.getName(), app);
        }
        return appMap;
    }

    public static ClientScopeModel createClientScope(KeycloakSession session, RealmModel realm, ClientScopeRepresentation resourceRep) {
        ClientScopeModel clientScope;
        logger.debugv("Create client scope: {0}", (Object)resourceRep.getName());
        ClientScopeModel clientScopeModel = clientScope = resourceRep.getId() != null ? realm.addClientScope(resourceRep.getId(), resourceRep.getName()) : realm.addClientScope(resourceRep.getName());
        if (resourceRep.getName() != null) {
            clientScope.setName(resourceRep.getName());
        }
        if (resourceRep.getDescription() != null) {
            clientScope.setDescription(resourceRep.getDescription());
        }
        if (resourceRep.getProtocol() != null) {
            clientScope.setProtocol(resourceRep.getProtocol());
        }
        if (resourceRep.getProtocolMappers() != null) {
            Set mappers = clientScope.getProtocolMappers();
            for (ProtocolMapperModel mapper : mappers) {
                clientScope.removeProtocolMapper(mapper);
            }
            for (ProtocolMapperModel mapper : resourceRep.getProtocolMappers()) {
                clientScope.addProtocolMapper(RepresentationToModel.toModel((ProtocolMapperRepresentation)mapper));
            }
            MigrationUtils.updateProtocolMappers((ProtocolMapperContainerModel)clientScope);
        }
        if (resourceRep.getAttributes() != null) {
            for (Map.Entry entry : resourceRep.getAttributes().entrySet()) {
                clientScope.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return clientScope;
    }

    public static void updateClientScope(ClientScopeRepresentation rep, ClientScopeModel resource) {
        if (rep.getName() != null) {
            resource.setName(rep.getName());
        }
        if (rep.getDescription() != null) {
            resource.setDescription(rep.getDescription());
        }
        if (rep.getProtocol() != null) {
            resource.setProtocol(rep.getProtocol());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                resource.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static long getClaimsMask(ClaimRepresentation rep) {
        long mask = 1023L;
        mask = rep.getAddress() ? (mask |= 0x100L) : (mask &= 0xFFFFFFFFFFFFFEFFL);
        mask = rep.getEmail() ? (mask |= 0x20L) : (mask &= 0xFFFFFFFFFFFFFFDFL);
        mask = rep.getGender() ? (mask |= 0x40L) : (mask &= 0xFFFFFFFFFFFFFFBFL);
        mask = rep.getLocale() ? (mask |= 0x80L) : (mask &= 0xFFFFFFFFFFFFFF7FL);
        mask = rep.getName() ? (mask |= 1L) : (mask &= 0xFFFFFFFFFFFFFFFEL);
        mask = rep.getPhone() ? (mask |= 0x200L) : (mask &= 0xFFFFFFFFFFFFFDFFL);
        mask = rep.getPicture() ? (mask |= 8L) : (mask &= 0xFFFFFFFFFFFFFFF7L);
        mask = rep.getProfile() ? (mask |= 4L) : (mask &= 0xFFFFFFFFFFFFFFFBL);
        mask = rep.getUsername() ? (mask |= 2L) : (mask &= 0xFFFFFFFFFFFFFFFDL);
        mask = rep.getWebsite() ? (mask |= 0x10L) : (mask &= 0xFFFFFFFFFFFFFFEFL);
        return mask;
    }

    public static void createClientScopeMappings(RealmModel realm, ClientModel clientModel, List<ScopeMappingRepresentation> mappings) {
        for (ScopeMappingRepresentation mapping : mappings) {
            ScopeContainerModel scopeContainer = RepresentationToModel.getScopeContainerHavingScope(realm, mapping);
            for (String roleString : mapping.getRoles()) {
                RoleModel role = clientModel.getRole(roleString.trim());
                if (role == null) {
                    role = clientModel.addRole(roleString.trim());
                }
                scopeContainer.addScopeMapping(role);
            }
        }
    }

    private static ScopeContainerModel getScopeContainerHavingScope(RealmModel realm, ScopeMappingRepresentation scope) {
        if (scope.getClient() != null) {
            ClientModel client = realm.getClientByClientId(scope.getClient());
            if (client == null) {
                throw new RuntimeException("Unknown client specification in scope mappings: " + scope.getClient());
            }
            return client;
        }
        if (scope.getClientScope() != null) {
            ClientScopeModel clientScope = KeycloakModelUtils.getClientScopeByName(realm, scope.getClientScope());
            if (clientScope == null) {
                throw new RuntimeException("Unknown clientScope specification in scope mappings: " + scope.getClientScope());
            }
            return clientScope;
        }
        if (scope.getClientTemplate() != null) {
            String templateName = KeycloakModelUtils.convertClientScopeName(scope.getClientTemplate());
            ClientScopeModel clientTemplate = KeycloakModelUtils.getClientScopeByName(realm, templateName);
            if (clientTemplate == null) {
                throw new RuntimeException("Unknown clientScope specification in scope mappings: " + templateName);
            }
            return clientTemplate;
        }
        throw new RuntimeException("Either client or clientScope needs to be specified in scope mappings");
    }

    public static UserModel createUser(KeycloakSession session, RealmModel newRealm, UserRepresentation userRep) {
        RepresentationToModel.convertDeprecatedSocialProviders(userRep);
        UserModel user = session.userLocalStorage().addUser(newRealm, userRep.getId(), userRep.getUsername(), false, false);
        user.setEnabled(userRep.isEnabled() != null && userRep.isEnabled() != false);
        user.setCreatedTimestamp(userRep.getCreatedTimestamp());
        user.setEmail(userRep.getEmail());
        if (userRep.isEmailVerified() != null) {
            user.setEmailVerified(userRep.isEmailVerified().booleanValue());
        }
        user.setFirstName(userRep.getFirstName());
        user.setLastName(userRep.getLastName());
        user.setFederationLink(userRep.getFederationLink());
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                List value = (List)entry.getValue();
                if (value == null) continue;
                user.setAttribute((String)entry.getKey(), new ArrayList(value));
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String requiredAction : userRep.getRequiredActions()) {
                try {
                    user.addRequiredAction(UserModel.RequiredAction.valueOf((String)requiredAction.toUpperCase()));
                }
                catch (IllegalArgumentException iae) {
                    user.addRequiredAction(requiredAction);
                }
            }
        }
        RepresentationToModel.createCredentials(userRep, session, newRealm, user, false);
        RepresentationToModel.createFederatedIdentities(userRep, session, newRealm, user);
        RepresentationToModel.createRoleMappings(userRep, user, newRealm);
        if (userRep.getClientConsents() != null) {
            for (UserConsentRepresentation consentRep : userRep.getClientConsents()) {
                UserConsentModel consentModel = RepresentationToModel.toModel(newRealm, consentRep);
                session.users().addConsent(newRealm, user.getId(), consentModel);
            }
        }
        if (userRep.getNotBefore() != null) {
            session.users().setNotBeforeForUser(newRealm, user, userRep.getNotBefore().intValue());
        }
        if (userRep.getServiceAccountClientId() != null) {
            String clientId = userRep.getServiceAccountClientId();
            ClientModel client = newRealm.getClientByClientId(clientId);
            if (client == null) {
                throw new RuntimeException("Unable to find client specified for service account link. Client: " + clientId);
            }
            user.setServiceAccountClientLink(client.getId());
        }
        RepresentationToModel.createGroups(userRep, newRealm, user);
        return user;
    }

    public static void createGroups(UserRepresentation userRep, RealmModel newRealm, UserModel user) {
        if (userRep.getGroups() != null) {
            for (String path : userRep.getGroups()) {
                GroupModel group = KeycloakModelUtils.findGroupByPath(newRealm, path);
                if (group == null) {
                    throw new RuntimeException("Unable to find group specified by path: " + path);
                }
                user.joinGroup(group);
            }
        }
    }

    public static void createFederatedIdentities(UserRepresentation userRep, KeycloakSession session, RealmModel realm, UserModel user) {
        if (userRep.getFederatedIdentities() != null) {
            for (FederatedIdentityRepresentation identity : userRep.getFederatedIdentities()) {
                FederatedIdentityModel mappingModel = new FederatedIdentityModel(identity.getIdentityProvider(), identity.getUserId(), identity.getUserName());
                session.users().addFederatedIdentity(realm, user, mappingModel);
            }
        }
    }

    public static void createCredentials(UserRepresentation userRep, KeycloakSession session, RealmModel realm, UserModel user, boolean adminRequest) {
        RepresentationToModel.convertDeprecatedCredentialsFormat(userRep);
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                if (cred.getId() != null && session.userCredentialManager().getStoredCredentialById(realm, user, cred.getId()) != null) continue;
                if (cred.getValue() != null && !cred.getValue().isEmpty()) {
                    RealmModel origRealm = session.getContext().getRealm();
                    try {
                        session.getContext().setRealm(realm);
                        session.userCredentialManager().updateCredential(realm, user, (CredentialInput)UserCredentialModel.password((String)cred.getValue(), (boolean)false));
                        continue;
                    }
                    catch (ModelException ex) {
                        throw new PasswordPolicyNotMetException(ex.getMessage(), user.getUsername(), (Throwable)ex);
                    }
                    finally {
                        session.getContext().setRealm(origRealm);
                        continue;
                    }
                }
                session.userCredentialManager().createCredentialThroughProvider(realm, user, RepresentationToModel.toModel(cred));
            }
        }
    }

    public static CredentialModel toModel(CredentialRepresentation cred) {
        CredentialModel model = new CredentialModel();
        model.setCreatedDate(cred.getCreatedDate());
        model.setType(cred.getType());
        model.setUserLabel(cred.getUserLabel());
        model.setSecretData(cred.getSecretData());
        model.setCredentialData(cred.getCredentialData());
        model.setId(cred.getId());
        return model;
    }

    public static void createRoleMappings(UserRepresentation userRep, UserModel user, RealmModel realm) {
        if (userRep.getRealmRoles() != null) {
            for (String string : userRep.getRealmRoles()) {
                RoleModel role = realm.getRole(string.trim());
                if (role == null) {
                    role = realm.addRole(string.trim());
                }
                user.grantRole(role);
            }
        }
        if (userRep.getClientRoles() != null) {
            for (Map.Entry entry : userRep.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                RepresentationToModel.createClientRoleMappings(client, user, (List)entry.getValue());
            }
        }
    }

    public static void createClientRoleMappings(ClientModel clientModel, UserModel user, List<String> roleNames) {
        if (user == null) {
            throw new RuntimeException("User not found");
        }
        for (String roleName : roleNames) {
            RoleModel role = clientModel.getRole(roleName.trim());
            if (role == null) {
                role = clientModel.addRole(roleName.trim());
            }
            user.grantRole(role);
        }
    }

    private static void importIdentityProviders(RealmRepresentation rep, RealmModel newRealm, KeycloakSession session) {
        if (rep.getIdentityProviders() != null) {
            for (IdentityProviderRepresentation representation : rep.getIdentityProviders()) {
                newRealm.addIdentityProvider(RepresentationToModel.toModel(newRealm, representation, session));
            }
        }
    }

    private static void importIdentityProviderMappers(RealmRepresentation rep, RealmModel newRealm) {
        if (rep.getIdentityProviderMappers() != null) {
            for (IdentityProviderMapperRepresentation representation : rep.getIdentityProviderMappers()) {
                newRealm.addIdentityProviderMapper(RepresentationToModel.toModel(representation));
            }
        }
    }

    public static IdentityProviderModel toModel(RealmModel realm, IdentityProviderRepresentation representation, KeycloakSession session) {
        AuthenticationFlowModel flowModel;
        IdentityProviderFactory providerFactory = (IdentityProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(IdentityProvider.class, representation.getProviderId());
        if (providerFactory == null) {
            providerFactory = (IdentityProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(SocialIdentityProvider.class, representation.getProviderId());
        }
        if (providerFactory == null) {
            throw new IllegalArgumentException("Invalid identity provider id [" + representation.getProviderId() + "]");
        }
        Object identityProviderModel = providerFactory.createConfig();
        identityProviderModel.setInternalId(representation.getInternalId());
        identityProviderModel.setAlias(representation.getAlias());
        identityProviderModel.setDisplayName(representation.getDisplayName());
        identityProviderModel.setProviderId(representation.getProviderId());
        identityProviderModel.setEnabled(representation.isEnabled());
        identityProviderModel.setLinkOnly(representation.isLinkOnly());
        identityProviderModel.setTrustEmail(representation.isTrustEmail());
        identityProviderModel.setAuthenticateByDefault(representation.isAuthenticateByDefault());
        identityProviderModel.setStoreToken(representation.isStoreToken());
        identityProviderModel.setAddReadTokenRoleOnCreate(representation.isAddReadTokenRoleOnCreate());
        identityProviderModel.setConfig(RepresentationToModel.removeEmptyString(representation.getConfig()));
        String flowAlias = representation.getFirstBrokerLoginFlowAlias();
        if (flowAlias == null) {
            flowAlias = "first broker login";
        }
        if ((flowModel = realm.getFlowByAlias(flowAlias)) == null) {
            throw new ModelException("No available authentication flow with alias: " + flowAlias);
        }
        identityProviderModel.setFirstBrokerLoginFlowId(flowModel.getId());
        flowAlias = representation.getPostBrokerLoginFlowAlias();
        if (flowAlias == null || flowAlias.trim().length() == 0) {
            identityProviderModel.setPostBrokerLoginFlowId(null);
        } else {
            flowModel = realm.getFlowByAlias(flowAlias);
            if (flowModel == null) {
                throw new ModelException("No available authentication flow with alias: " + flowAlias);
            }
            identityProviderModel.setPostBrokerLoginFlowId(flowModel.getId());
        }
        identityProviderModel.validate(realm);
        return identityProviderModel;
    }

    public static ProtocolMapperModel toModel(ProtocolMapperRepresentation rep) {
        ProtocolMapperModel model = new ProtocolMapperModel();
        model.setId(rep.getId());
        model.setName(rep.getName());
        model.setProtocol(rep.getProtocol());
        model.setProtocolMapper(rep.getProtocolMapper());
        model.setConfig(RepresentationToModel.removeEmptyString(rep.getConfig()));
        return model;
    }

    public static IdentityProviderMapperModel toModel(IdentityProviderMapperRepresentation rep) {
        IdentityProviderMapperModel model = new IdentityProviderMapperModel();
        model.setId(rep.getId());
        model.setName(rep.getName());
        model.setIdentityProviderAlias(rep.getIdentityProviderAlias());
        model.setIdentityProviderMapper(rep.getIdentityProviderMapper());
        model.setConfig(RepresentationToModel.removeEmptyString(rep.getConfig()));
        return model;
    }

    public static UserConsentModel toModel(RealmModel newRealm, UserConsentRepresentation consentRep) {
        ClientModel client = newRealm.getClientByClientId(consentRep.getClientId());
        if (client == null) {
            throw new RuntimeException("Unable to find client consent mappings for client: " + consentRep.getClientId());
        }
        UserConsentModel consentModel = new UserConsentModel(client);
        consentModel.setCreatedDate(consentRep.getCreatedDate());
        consentModel.setLastUpdatedDate(consentRep.getLastUpdatedDate());
        if (consentRep.getGrantedClientScopes() != null) {
            for (String scopeName : consentRep.getGrantedClientScopes()) {
                ClientScopeModel clientScope = KeycloakModelUtils.getClientScopeByName(newRealm, scopeName);
                if (clientScope == null) {
                    throw new RuntimeException("Unable to find client scope referenced in consent mappings of user. Client scope name: " + scopeName);
                }
                consentModel.addGrantedClientScope(clientScope);
            }
        }
        if (consentRep.getGrantedRealmRoles() != null && consentRep.getGrantedRealmRoles().contains("offline_access")) {
            ClientScopeModel offlineScope = (ClientScopeModel)client.getClientScopes(false, true).get("offline_access");
            if (offlineScope == null) {
                logger.warn((Object)"Unable to find offline_access scope referenced in grantedRoles of user");
            }
            consentModel.addGrantedClientScope(offlineScope);
        }
        return consentModel;
    }

    public static AuthenticationFlowModel toModel(AuthenticationFlowRepresentation rep) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(rep.getId());
        model.setBuiltIn(rep.isBuiltIn());
        model.setTopLevel(rep.isTopLevel());
        model.setProviderId(rep.getProviderId());
        model.setAlias(rep.getAlias());
        model.setDescription(rep.getDescription());
        return model;
    }

    private static AuthenticationExecutionModel toModel(RealmModel realm, AuthenticationFlowModel parentFlow, AuthenticationExecutionExportRepresentation rep) {
        AuthenticationExecutionModel model;
        block4: {
            model = new AuthenticationExecutionModel();
            if (rep.getAuthenticatorConfig() != null) {
                AuthenticatorConfigModel config = realm.getAuthenticatorConfigByAlias(rep.getAuthenticatorConfig());
                model.setAuthenticatorConfig(config.getId());
            }
            model.setAuthenticator(rep.getAuthenticator());
            model.setAuthenticatorFlow(rep.isAutheticatorFlow());
            if (rep.getFlowAlias() != null) {
                AuthenticationFlowModel flow = realm.getFlowByAlias(rep.getFlowAlias());
                model.setFlowId(flow.getId());
            }
            model.setPriority(rep.getPriority());
            try {
                model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
                model.setParentFlow(parentFlow.getId());
            }
            catch (IllegalArgumentException iae) {
                if (!"OPTIONAL".equals(rep.getRequirement())) break block4;
                MigrateTo8_0_0.migrateOptionalAuthenticationExecution(realm, parentFlow, model, false);
            }
        }
        return model;
    }

    public static AuthenticationExecutionModel toModel(RealmModel realm, AuthenticationExecutionRepresentation rep) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(rep.getId());
        model.setFlowId(rep.getFlowId());
        model.setAuthenticator(rep.getAuthenticator());
        model.setPriority(rep.getPriority());
        model.setParentFlow(rep.getParentFlow());
        model.setAuthenticatorFlow(rep.isAutheticatorFlow());
        model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
        if (rep.getAuthenticatorConfig() != null) {
            AuthenticatorConfigModel cfg = realm.getAuthenticatorConfigByAlias(rep.getAuthenticatorConfig());
            model.setAuthenticatorConfig(cfg.getId());
        }
        return model;
    }

    public static AuthenticatorConfigModel toModel(AuthenticatorConfigRepresentation rep) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setAlias(rep.getAlias());
        model.setConfig(RepresentationToModel.removeEmptyString(rep.getConfig()));
        return model;
    }

    public static RequiredActionProviderModel toModel(RequiredActionProviderRepresentation rep) {
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setConfig(RepresentationToModel.removeEmptyString(rep.getConfig()));
        model.setPriority(rep.getPriority());
        model.setDefaultAction(rep.isDefaultAction());
        model.setEnabled(rep.isEnabled());
        model.setProviderId(rep.getProviderId());
        model.setName(rep.getName());
        model.setAlias(rep.getAlias());
        return model;
    }

    public static ComponentModel toModel(KeycloakSession session, ComponentRepresentation rep) {
        ComponentModel model = new ComponentModel();
        model.setId(rep.getId());
        model.setParentId(rep.getParentId());
        model.setProviderType(rep.getProviderType());
        model.setProviderId(rep.getProviderId());
        model.setConfig(new MultivaluedHashMap());
        model.setName(rep.getName());
        model.setSubType(rep.getSubType());
        if (rep.getConfig() != null) {
            HashSet keys = new HashSet(rep.getConfig().keySet());
            for (String k : keys) {
                List values = (List)rep.getConfig().get((Object)k);
                if (values == null) continue;
                ListIterator itr = values.listIterator();
                while (itr.hasNext()) {
                    String v = (String)itr.next();
                    if (v != null && !v.trim().isEmpty()) continue;
                    itr.remove();
                }
                if (values.isEmpty()) continue;
                model.getConfig().put((Object)k, (Object)values);
            }
        }
        return model;
    }

    public static void updateComponent(KeycloakSession session, ComponentRepresentation rep, ComponentModel component, boolean internal) {
        if (rep.getName() != null) {
            component.setName(rep.getName());
        }
        if (rep.getParentId() != null) {
            component.setParentId(rep.getParentId());
        }
        if (rep.getProviderType() != null) {
            component.setProviderType(rep.getProviderType());
        }
        if (rep.getProviderId() != null) {
            component.setProviderId(rep.getProviderId());
        }
        if (rep.getSubType() != null) {
            component.setSubType(rep.getSubType());
        }
        Map<String, ProviderConfigProperty> providerConfiguration = null;
        if (!internal) {
            providerConfiguration = ComponentUtil.getComponentConfigProperties(session, component);
        }
        if (rep.getConfig() != null) {
            HashSet keys = new HashSet(rep.getConfig().keySet());
            for (String k : keys) {
                if (!internal && !providerConfiguration.containsKey(k)) break;
                List values = (List)rep.getConfig().get((Object)k);
                if (values == null || values.isEmpty() || values.get(0) == null || ((String)values.get(0)).trim().isEmpty()) {
                    component.getConfig().remove((Object)k);
                    continue;
                }
                ListIterator itr = values.listIterator();
                while (itr.hasNext()) {
                    String v = (String)itr.next();
                    if (v != null && !v.trim().isEmpty() && !v.equals("**********")) continue;
                    itr.remove();
                }
                if (values.isEmpty()) continue;
                component.getConfig().put((Object)k, (Object)values);
            }
        }
    }

    public static void importRealmAuthorizationSettings(RealmRepresentation rep, RealmModel newRealm, KeycloakSession session) {
        if (rep.getClients() != null) {
            rep.getClients().forEach(clientRepresentation -> {
                ClientModel client = newRealm.getClientByClientId(clientRepresentation.getClientId());
                RepresentationToModel.importAuthorizationSettings(clientRepresentation, client, session);
            });
        }
    }

    public static void importAuthorizationSettings(ClientRepresentation clientRepresentation, ClientModel client, KeycloakSession session) {
        if (Boolean.TRUE.equals(clientRepresentation.getAuthorizationServicesEnabled())) {
            AuthorizationProviderFactory authorizationFactory = (AuthorizationProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(AuthorizationProvider.class);
            AuthorizationProvider authorization = authorizationFactory.create(session, client.getRealm());
            client.setServiceAccountsEnabled(true);
            client.setBearerOnly(false);
            client.setPublicClient(false);
            ResourceServerRepresentation rep = clientRepresentation.getAuthorizationSettings();
            if (rep == null) {
                rep = new ResourceServerRepresentation();
            }
            rep.setClientId(client.getId());
            RepresentationToModel.toModel(rep, authorization);
        }
    }

    public static ResourceServer toModel(ResourceServerRepresentation rep, AuthorizationProvider authorization) {
        ResourceServer resourceServer;
        ResourceServerStore resourceServerStore = authorization.getStoreFactory().getResourceServerStore();
        ResourceServer existing = resourceServerStore.findById(rep.getClientId());
        if (existing == null) {
            resourceServer = resourceServerStore.create(rep.getClientId());
            resourceServer.setAllowRemoteResourceManagement(true);
            resourceServer.setPolicyEnforcementMode(PolicyEnforcementMode.ENFORCING);
        } else {
            resourceServer = existing;
        }
        resourceServer.setPolicyEnforcementMode(rep.getPolicyEnforcementMode());
        resourceServer.setAllowRemoteResourceManagement(rep.isAllowRemoteResourceManagement());
        DecisionStrategy decisionStrategy = rep.getDecisionStrategy();
        if (decisionStrategy == null) {
            decisionStrategy = DecisionStrategy.UNANIMOUS;
        }
        resourceServer.setDecisionStrategy(decisionStrategy);
        for (ScopeRepresentation scope : rep.getScopes()) {
            RepresentationToModel.toModel(scope, resourceServer, authorization);
        }
        KeycloakSession session = authorization.getKeycloakSession();
        RealmModel realm = authorization.getRealm();
        for (ResourceRepresentation resource : rep.getResources()) {
            UserModel user;
            ResourceOwnerRepresentation owner = resource.getOwner();
            if (owner == null) {
                owner = new ResourceOwnerRepresentation();
                owner.setId(resourceServer.getId());
                resource.setOwner(owner);
            } else if (owner.getName() != null && (user = session.users().getUserByUsername(owner.getName(), realm)) != null) {
                owner.setId(user.getId());
            }
            RepresentationToModel.toModel(resource, resourceServer, authorization);
        }
        RepresentationToModel.importPolicies(authorization, resourceServer, rep.getPolicies(), null);
        return resourceServer;
    }

    private static Policy importPolicies(AuthorizationProvider authorization, ResourceServer resourceServer, List<PolicyRepresentation> policiesToImport, String parentPolicyName) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        for (PolicyRepresentation policyRepresentation : policiesToImport) {
            Policy policy;
            PolicyStore policyStore;
            if (parentPolicyName != null && !parentPolicyName.equals(policyRepresentation.getName())) continue;
            Map config = policyRepresentation.getConfig();
            String applyPolicies = (String)config.get("applyPolicies");
            if (applyPolicies != null && !applyPolicies.isEmpty()) {
                policyStore = storeFactory.getPolicyStore();
                try {
                    List policies = (List)JsonSerialization.readValue((String)applyPolicies, List.class);
                    HashSet<String> policyIds = new HashSet<String>();
                    for (String policyName : policies) {
                        Policy policy2 = policyStore.findByName(policyName, resourceServer.getId());
                        if (policy2 == null) {
                            policy2 = policyStore.findById(policyName, resourceServer.getId());
                        }
                        if (policy2 == null && (policy2 = RepresentationToModel.importPolicies(authorization, resourceServer, policiesToImport, policyName)) == null) {
                            throw new RuntimeException("Policy with name [" + policyName + "] not defined.");
                        }
                        policyIds.add(policy2.getId());
                    }
                    config.put("applyPolicies", JsonSerialization.writeValueAsString(policyIds));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while importing policy [" + policyRepresentation.getName() + "].", e);
                }
            }
            if ((policy = (policyStore = storeFactory.getPolicyStore()).findById(policyRepresentation.getId(), resourceServer.getId())) == null) {
                policy = policyStore.findByName(policyRepresentation.getName(), resourceServer.getId());
            }
            policy = policy == null ? policyStore.create((AbstractPolicyRepresentation)policyRepresentation, resourceServer) : RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, authorization, policy);
            if (parentPolicyName == null || !parentPolicyName.equals(policyRepresentation.getName())) continue;
            return policy;
        }
        return null;
    }

    public static Policy toModel(AbstractPolicyRepresentation representation, AuthorizationProvider authorization, Policy model) {
        model.setName(representation.getName());
        model.setDescription(representation.getDescription());
        model.setDecisionStrategy(representation.getDecisionStrategy());
        model.setLogic(representation.getLogic());
        Set resources = representation.getResources();
        Set scopes = representation.getScopes();
        Set policies = representation.getPolicies();
        if (representation instanceof PolicyRepresentation) {
            String policiesConfig;
            String scopesConfig;
            String resourcesConfig;
            PolicyRepresentation policy = (PolicyRepresentation)PolicyRepresentation.class.cast(representation);
            if (resources == null && (resourcesConfig = (String)policy.getConfig().get("resources")) != null) {
                try {
                    resources = (Set)JsonSerialization.readValue((String)resourcesConfig, Set.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (scopes == null && (scopesConfig = (String)policy.getConfig().get("scopes")) != null) {
                try {
                    scopes = (Set)JsonSerialization.readValue((String)scopesConfig, Set.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (policies == null && (policiesConfig = (String)policy.getConfig().get("applyPolicies")) != null) {
                try {
                    policies = (Set)JsonSerialization.readValue((String)policiesConfig, Set.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            model.setConfig(policy.getConfig());
        }
        StoreFactory storeFactory = authorization.getStoreFactory();
        RepresentationToModel.updateResources(resources, model, storeFactory);
        RepresentationToModel.updateScopes(scopes, model, storeFactory);
        RepresentationToModel.updateAssociatedPolicies(policies, model, storeFactory);
        PolicyProviderFactory provider = authorization.getProviderFactory(model.getType());
        if (representation instanceof PolicyRepresentation) {
            provider.onImport(model, (PolicyRepresentation)PolicyRepresentation.class.cast(representation), authorization);
        } else if (representation.getId() == null) {
            provider.onCreate(model, representation, authorization);
        } else {
            provider.onUpdate(model, representation, authorization);
        }
        representation.setId(model.getId());
        return model;
    }

    private static void updateScopes(Set<String> scopeIds, Policy policy, StoreFactory storeFactory) {
        if (scopeIds != null) {
            boolean hasScope;
            if (scopeIds.isEmpty()) {
                for (Scope scope : new HashSet<Scope>(policy.getScopes())) {
                    policy.removeScope(scope);
                }
                return;
            }
            for (String scopeId : scopeIds) {
                hasScope = false;
                for (Scope scopeModel : new HashSet<Scope>(policy.getScopes())) {
                    if (!scopeModel.getId().equals(scopeId) && !scopeModel.getName().equals(scopeId)) continue;
                    hasScope = true;
                }
                if (hasScope) continue;
                ResourceServer resourceServer = policy.getResourceServer();
                Scope scope = storeFactory.getScopeStore().findById(scopeId, resourceServer.getId());
                if (scope == null && (scope = storeFactory.getScopeStore().findByName(scopeId, resourceServer.getId())) == null) {
                    throw new RuntimeException("Scope with id or name [" + scopeId + "] does not exist");
                }
                policy.addScope(scope);
            }
            for (Scope scopeModel : new HashSet<Scope>(policy.getScopes())) {
                hasScope = false;
                for (String scopeId : scopeIds) {
                    if (!scopeModel.getId().equals(scopeId) && !scopeModel.getName().equals(scopeId)) continue;
                    hasScope = true;
                }
                if (hasScope) continue;
                policy.removeScope(scopeModel);
            }
        }
        policy.removeConfig("scopes");
    }

    private static void updateAssociatedPolicies(Set<String> policyIds, Policy policy, StoreFactory storeFactory) {
        ResourceServer resourceServer = policy.getResourceServer();
        if (policyIds != null) {
            boolean hasPolicy;
            if (policyIds.isEmpty()) {
                for (Policy associated : new HashSet<Policy>(policy.getAssociatedPolicies())) {
                    policy.removeAssociatedPolicy(associated);
                }
                return;
            }
            PolicyStore policyStore = storeFactory.getPolicyStore();
            for (String policyId : policyIds) {
                hasPolicy = false;
                for (Policy policyModel : new HashSet<Policy>(policy.getAssociatedPolicies())) {
                    if (!policyModel.getId().equals(policyId) && !policyModel.getName().equals(policyId)) continue;
                    hasPolicy = true;
                }
                if (hasPolicy) continue;
                Policy associatedPolicy = policyStore.findById(policyId, resourceServer.getId());
                if (associatedPolicy == null && (associatedPolicy = policyStore.findByName(policyId, resourceServer.getId())) == null) {
                    throw new RuntimeException("Policy with id or name [" + policyId + "] does not exist");
                }
                policy.addAssociatedPolicy(associatedPolicy);
            }
            for (Policy policyModel : new HashSet<Policy>(policy.getAssociatedPolicies())) {
                hasPolicy = false;
                for (String policyId : policyIds) {
                    if (!policyModel.getId().equals(policyId) && !policyModel.getName().equals(policyId)) continue;
                    hasPolicy = true;
                }
                if (hasPolicy) continue;
                policy.removeAssociatedPolicy(policyModel);
            }
        }
        policy.removeConfig("applyPolicies");
    }

    private static void updateResources(Set<String> resourceIds, Policy policy, StoreFactory storeFactory) {
        if (resourceIds != null) {
            boolean hasResource;
            if (resourceIds.isEmpty()) {
                for (Resource resource : new HashSet<Resource>(policy.getResources())) {
                    policy.removeResource(resource);
                }
            }
            for (String resourceId : resourceIds) {
                hasResource = false;
                for (Resource resourceModel : new HashSet<Resource>(policy.getResources())) {
                    if (!resourceModel.getId().equals(resourceId) && !resourceModel.getName().equals(resourceId)) continue;
                    hasResource = true;
                }
                if (hasResource || "".equals(resourceId)) continue;
                Resource resource = storeFactory.getResourceStore().findById(resourceId, policy.getResourceServer().getId());
                if (resource == null && (resource = storeFactory.getResourceStore().findByName(resourceId, policy.getResourceServer().getId())) == null) {
                    throw new RuntimeException("Resource with id or name [" + resourceId + "] does not exist or is not owned by the resource server");
                }
                policy.addResource(resource);
            }
            for (Resource resourceModel : new HashSet<Resource>(policy.getResources())) {
                hasResource = false;
                for (String resourceId : resourceIds) {
                    if (!resourceModel.getId().equals(resourceId) && !resourceModel.getName().equals(resourceId)) continue;
                    hasResource = true;
                }
                if (hasResource) continue;
                policy.removeResource(resourceModel);
            }
        }
        policy.removeConfig("resources");
    }

    public static Resource toModel(ResourceRepresentation resource, ResourceServer resourceServer, AuthorizationProvider authorization) {
        Map attributes;
        Resource existing;
        String ownerId;
        ResourceStore resourceStore = authorization.getStoreFactory().getResourceStore();
        ResourceOwnerRepresentation owner = resource.getOwner();
        if (owner == null) {
            owner = new ResourceOwnerRepresentation();
            owner.setId(resourceServer.getId());
        }
        if ((ownerId = owner.getId()) == null) {
            ownerId = resourceServer.getId();
        }
        if (!resourceServer.getId().equals(ownerId)) {
            RealmModel realm = authorization.getRealm();
            KeycloakSession keycloakSession = authorization.getKeycloakSession();
            UserProvider users = keycloakSession.users();
            Object ownerModel = users.getUserById(ownerId, realm);
            if (ownerModel == null) {
                ownerModel = users.getUserByUsername(ownerId, realm);
            }
            if (ownerModel == null) {
                throw new RuntimeException("Owner must be a valid username or user identifier. If the resource server, the client id or null.");
            }
            ownerId = ownerModel.getId();
        }
        if ((existing = resource.getId() != null ? resourceStore.findById(resource.getId(), resourceServer.getId()) : resourceStore.findByName(resource.getName(), ownerId, resourceServer.getId())) != null) {
            existing.setName(resource.getName());
            existing.setDisplayName(resource.getDisplayName());
            existing.setType(resource.getType());
            existing.updateUris(resource.getUris());
            existing.setIconUri(resource.getIconUri());
            existing.setOwnerManagedAccess(Boolean.TRUE.equals(resource.getOwnerManagedAccess()));
            existing.updateScopes(resource.getScopes().stream().map(scope -> RepresentationToModel.toModel(scope, resourceServer, authorization, false)).collect(Collectors.toSet()));
            Map attributes2 = resource.getAttributes();
            if (attributes2 != null) {
                Set<String> existingAttrNames = existing.getAttributes().keySet();
                for (String name : existingAttrNames) {
                    if (attributes2.containsKey(name)) {
                        existing.setAttribute(name, (List)attributes2.get(name));
                        attributes2.remove(name);
                        continue;
                    }
                    existing.removeAttribute(name);
                }
                for (String name : attributes2.keySet()) {
                    existing.setAttribute(name, (List)attributes2.get(name));
                }
            }
            return existing;
        }
        Resource model = resourceStore.create(resource.getId(), resource.getName(), resourceServer, ownerId);
        model.setDisplayName(resource.getDisplayName());
        model.setType(resource.getType());
        model.updateUris(resource.getUris());
        model.setIconUri(resource.getIconUri());
        model.setOwnerManagedAccess(Boolean.TRUE.equals(resource.getOwnerManagedAccess()));
        Set scopes = resource.getScopes();
        if (scopes != null) {
            model.updateScopes(scopes.stream().map(scope -> RepresentationToModel.toModel(scope, resourceServer, authorization, false)).collect(Collectors.toSet()));
        }
        if ((attributes = resource.getAttributes()) != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                model.setAttribute((String)entry.getKey(), (List)entry.getValue());
            }
        }
        resource.setId(model.getId());
        return model;
    }

    public static Scope toModel(ScopeRepresentation scope, ResourceServer resourceServer, AuthorizationProvider authorization) {
        return RepresentationToModel.toModel(scope, resourceServer, authorization, true);
    }

    public static Scope toModel(ScopeRepresentation scope, ResourceServer resourceServer, AuthorizationProvider authorization, boolean updateIfExists) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        ScopeStore scopeStore = storeFactory.getScopeStore();
        Scope existing = scope.getId() != null ? scopeStore.findById(scope.getId(), resourceServer.getId()) : scopeStore.findByName(scope.getName(), resourceServer.getId());
        if (existing != null) {
            if (updateIfExists) {
                existing.setName(scope.getName());
                existing.setDisplayName(scope.getDisplayName());
                existing.setIconUri(scope.getIconUri());
            }
            return existing;
        }
        Scope model = scopeStore.create(scope.getId(), scope.getName(), resourceServer);
        model.setDisplayName(scope.getDisplayName());
        model.setIconUri(scope.getIconUri());
        scope.setId(model.getId());
        return model;
    }

    public static PermissionTicket toModel(PermissionTicketRepresentation representation, String resourceServerId, AuthorizationProvider authorization) {
        PermissionTicketStore ticketStore = authorization.getStoreFactory().getPermissionTicketStore();
        PermissionTicket ticket = ticketStore.findById(representation.getId(), resourceServerId);
        boolean granted = representation.isGranted();
        if (granted && !ticket.isGranted()) {
            ticket.setGrantedTimestamp(System.currentTimeMillis());
        } else if (!granted) {
            ticketStore.delete(ticket.getId());
        }
        return ticket;
    }

    public static void importFederatedUser(KeycloakSession session, RealmModel newRealm, UserRepresentation userRep) {
        UserFederatedStorageProvider federatedStorage = session.userFederatedStorage();
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                if (value == null) continue;
                federatedStorage.setAttribute(newRealm, userRep.getId(), key, new LinkedList(value));
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String action : userRep.getRequiredActions()) {
                federatedStorage.addRequiredAction(newRealm, userRep.getId(), action);
            }
        }
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                federatedStorage.createCredential(newRealm, userRep.getId(), RepresentationToModel.toModel(cred));
            }
        }
        RepresentationToModel.createFederatedRoleMappings(federatedStorage, userRep, newRealm);
        if (userRep.getGroups() != null) {
            for (String path : userRep.getGroups()) {
                GroupModel group = KeycloakModelUtils.findGroupByPath(newRealm, path);
                if (group == null) {
                    throw new RuntimeException("Unable to find group specified by path: " + path);
                }
                federatedStorage.joinGroup(newRealm, userRep.getId(), group);
            }
        }
        if (userRep.getFederatedIdentities() != null) {
            for (FederatedIdentityRepresentation identity : userRep.getFederatedIdentities()) {
                FederatedIdentityModel mappingModel = new FederatedIdentityModel(identity.getIdentityProvider(), identity.getUserId(), identity.getUserName());
                federatedStorage.addFederatedIdentity(newRealm, userRep.getId(), mappingModel);
            }
        }
        if (userRep.getClientConsents() != null) {
            for (UserConsentRepresentation consentRep : userRep.getClientConsents()) {
                UserConsentModel consentModel = RepresentationToModel.toModel(newRealm, consentRep);
                federatedStorage.addConsent(newRealm, userRep.getId(), consentModel);
            }
        }
        if (userRep.getNotBefore() != null) {
            federatedStorage.setNotBeforeForUser(newRealm, userRep.getId(), userRep.getNotBefore().intValue());
        }
    }

    public static void createFederatedRoleMappings(UserFederatedStorageProvider federatedStorage, UserRepresentation userRep, RealmModel realm) {
        if (userRep.getRealmRoles() != null) {
            for (String string : userRep.getRealmRoles()) {
                RoleModel role = realm.getRole(string.trim());
                if (role == null) {
                    role = realm.addRole(string.trim());
                }
                federatedStorage.grantRole(realm, userRep.getId(), role);
            }
        }
        if (userRep.getClientRoles() != null) {
            for (Map.Entry entry : userRep.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                RepresentationToModel.createFederatedClientRoleMappings(federatedStorage, realm, client, userRep, (List)entry.getValue());
            }
        }
    }

    public static void createFederatedClientRoleMappings(UserFederatedStorageProvider federatedStorage, RealmModel realm, ClientModel clientModel, UserRepresentation userRep, List<String> roleNames) {
        if (userRep == null) {
            throw new RuntimeException("User not found");
        }
        for (String roleName : roleNames) {
            RoleModel role = clientModel.getRole(roleName.trim());
            if (role == null) {
                role = clientModel.addRole(roleName.trim());
            }
            federatedStorage.grantRole(realm, userRep.getId(), role);
        }
    }

    public static Map<String, String> removeEmptyString(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>(map);
        Iterator itr = m.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            if (e.getValue() != null && !((String)e.getValue()).equals("")) continue;
            itr.remove();
        }
        return m;
    }

    public static ResourceServer createResourceServer(ClientModel client, KeycloakSession session, boolean addDefaultRoles) {
        if ((client.isBearerOnly() || client.isPublicClient()) && !client.getClientId().equals(Config.getAdminRealm() + "-realm") && !client.getClientId().equals("realm-management")) {
            throw new RuntimeException("Only confidential clients are allowed to set authorization settings");
        }
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        UserModel serviceAccount = session.users().getServiceAccount(client);
        if (serviceAccount == null) {
            client.setServiceAccountsEnabled(true);
        }
        if (addDefaultRoles) {
            RoleModel umaProtectionRole = client.getRole("uma_protection");
            if (umaProtectionRole == null) {
                umaProtectionRole = client.addRole("uma_protection");
            }
            if (serviceAccount != null) {
                serviceAccount.grantRole(umaProtectionRole);
            }
        }
        ResourceServerRepresentation representation = new ResourceServerRepresentation();
        representation.setAllowRemoteResourceManagement(true);
        representation.setClientId(client.getId());
        return RepresentationToModel.toModel(representation, authorization);
    }
}

