/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.models.utils.TimeBasedOTP;

public class CredentialValidation {
    public static boolean validOTP(String token, OTPCredentialModel credentialModel, int lookAheadWindow) {
        if (credentialModel.getOTPCredentialData().getSubType().equals("totp")) {
            TimeBasedOTP validator = new TimeBasedOTP(credentialModel.getOTPCredentialData().getAlgorithm(), credentialModel.getOTPCredentialData().getDigits(), credentialModel.getOTPCredentialData().getPeriod(), lookAheadWindow);
            return validator.validateTOTP(token, credentialModel.getOTPSecretData().getValue().getBytes());
        }
        HmacOTP validator = new HmacOTP(credentialModel.getOTPCredentialData().getDigits(), credentialModel.getOTPCredentialData().getAlgorithm(), lookAheadWindow);
        int c = validator.validateHOTP(token, credentialModel.getOTPSecretData().getValue(), credentialModel.getOTPCredentialData().getCounter());
        return c > -1;
    }
}

