/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate;

import org.keycloak.utils.StringUtil;
import org.keycloak.validate.AbstractSimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public abstract class AbstractStringValidator
extends AbstractSimpleValidator {
    @Override
    protected void doValidate(Object value, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (value instanceof String) {
            this.doValidate(value.toString(), inputHint, context, config);
        } else {
            context.addError(new ValidationError(this.getId(), inputHint, "error-invalid-value", value));
        }
    }

    protected abstract void doValidate(String var1, String var2, ValidationContext var3, ValidatorConfig var4);

    @Override
    protected boolean skipValidation(Object value, ValidatorConfig config) {
        if (this.isIgnoreEmptyValuesConfigured(config) && (value == null || value instanceof String)) {
            return value == null || StringUtil.isBlank((String)value.toString());
        }
        return false;
    }
}

