/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo18_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("18.0.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo18_0_0.class);

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.STEP_UP_AUTHENTICATION)) {
            session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm));
        }
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.STEP_UP_AUTHENTICATION)) {
            MigrationProvider migrationProvider = (MigrationProvider)session.getProvider(MigrationProvider.class);
            migrationProvider.addOIDCAcrClientScope(realm);
        }
    }
}

