/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class MigrateTo2_1_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("2.1.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> {
            this.migrateDefaultRequiredAction((RealmModel)realm);
            this.migrateRolePolicies((RealmModel)realm, session);
        });
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateDefaultRequiredAction(realm);
        this.migrateRolePolicies(realm, session);
    }

    private void migrateDefaultRequiredAction(RealmModel realm) {
        RequiredActionProviderModel otpAction = realm.getRequiredActionProviderByAlias(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        MigrationUtils.updateOTPRequiredAction(otpAction);
        realm.updateRequiredActionProvider(otpAction);
    }

    private void migrateRolePolicies(RealmModel realm, KeycloakSession session) {
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        realm.getClientsStream().forEach(clientModel -> {
            ResourceServer resourceServer = storeFactory.getResourceServerStore().findByClient((ClientModel)clientModel);
            if (resourceServer != null) {
                policyStore.findByType(resourceServer, "role").forEach(policy -> {
                    List roleConfig;
                    HashMap<String, String> config = new HashMap<String, String>(policy.getConfig());
                    String roles = (String)config.get("roles");
                    try {
                        roleConfig = (List)JsonSerialization.readValue((String)roles, List.class);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Malformed configuration for role policy [" + policy.getName() + "].", e);
                    }
                    if (!roleConfig.isEmpty() && roleConfig.get(0) instanceof String) {
                        try {
                            config.put("roles", JsonSerialization.writeValueAsString(roleConfig.stream().map(new Function<String, Map>(){

                                @Override
                                public Map apply(String roleId) {
                                    HashMap<String, String> updated = new HashMap<String, String>();
                                    updated.put("id", roleId);
                                    return updated;
                                }
                            }).collect(Collectors.toList())));
                            policy.setConfig(config);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to migrate role policy [" + policy.getName() + "].", e);
                        }
                    }
                });
            }
        });
    }
}

