/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;

public class LegacyStoreMigrateRepresentationEvent
implements ProviderEvent {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final RealmRepresentation rep;
    private final boolean skipUserDependent;

    public LegacyStoreMigrateRepresentationEvent(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.session = session;
        this.realm = realm;
        this.rep = rep;
        this.skipUserDependent = skipUserDependent;
    }

    public static void fire(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        session.getKeycloakSessionFactory().publish((ProviderEvent)new LegacyStoreMigrateRepresentationEvent(session, realm, rep, skipUserDependent));
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public RealmRepresentation getRep() {
        return this.rep;
    }

    public boolean isSkipUserDependent() {
        return this.skipUserDependent;
    }
}

