/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.jboss.logging.Logger;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowStep;

public class WorkflowExecutionContext {
    private static final Logger logger = Logger.getLogger(WorkflowExecutionContext.class);
    private String executionId;
    private String resourceId;
    private Workflow workflow;
    private List<WorkflowStep> steps;
    private int lastExecutedStepIndex = -1;

    public WorkflowExecutionContext(Workflow workflow, List<WorkflowStep> steps, String resourceId) {
        this.workflow = workflow;
        this.steps = Optional.ofNullable(steps).orElse(List.of());
        this.resourceId = resourceId;
    }

    public WorkflowExecutionContext(Workflow workflow, List<WorkflowStep> steps, String resourceId, String stepId, String executionId) {
        this(workflow, steps, resourceId);
        this.executionId = executionId;
        if (stepId != null) {
            for (int i = 0; i < steps.size(); ++i) {
                if (!steps.get(i).getId().equals(stepId)) continue;
                this.lastExecutedStepIndex = i - 1;
                break;
            }
        }
    }

    public void init() {
        if (this.executionId == null) {
            this.executionId = UUID.randomUUID().toString();
            logger.debugf("Started workflow '%s' for resource %s (execution id: %s)", (Object)this.workflow.getName(), (Object)this.resourceId, (Object)this.executionId);
        }
    }

    public void success(WorkflowStep step) {
        logger.debugf("Step %s completed successfully (execution id: %s)", (Object)step.getProviderId(), (Object)this.executionId);
    }

    public void fail(WorkflowStep step, String errorMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append("Step %s failed (execution id: %s)");
        if (errorMessage != null) {
            sb.append(" - error message: %s");
            logger.debugf(sb.toString(), (Object)step.getProviderId(), (Object)this.executionId, (Object)errorMessage);
        } else {
            logger.debugf(sb.toString(), (Object)step.getProviderId(), (Object)this.executionId);
        }
    }

    public void complete() {
        logger.debugf("Workflow '%s' completed for resource %s (execution id: %s)", (Object)this.workflow.getName(), (Object)this.resourceId, (Object)this.executionId);
    }

    public void cancel() {
        logger.debugf("Workflow '%s' cancelled for resource %s (execution id: %s)", (Object)this.workflow.getName(), (Object)this.resourceId, (Object)this.executionId);
    }

    public boolean hasNextStep() {
        return this.lastExecutedStepIndex + 1 < this.steps.size();
    }

    public WorkflowStep getNextStep() {
        if (this.lastExecutedStepIndex + 1 < this.steps.size()) {
            return this.steps.get(++this.lastExecutedStepIndex);
        }
        return null;
    }

    public void restart() {
        logger.debugf("Restarted workflow '%s' for resource %s (execution id: %s)", (Object)this.workflow.getName(), (Object)this.resourceId, (Object)this.executionId);
        this.lastExecutedStepIndex = -1;
    }

    public String getExecutionId() {
        return this.executionId;
    }
}

