/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store.syncronization;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.store.syncronization.Synchronizer;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;

public class ClientApplicationSynchronizer
implements Synchronizer<RealmModel.ClientRemovedEvent> {
    @Override
    public void synchronize(RealmModel.ClientRemovedEvent event, KeycloakSessionFactory factory) {
        ProviderFactory providerFactory = factory.getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)providerFactory.create(event.getKeycloakSession());
        this.removeFromClientPolicies(event, authorizationProvider);
    }

    private void removeFromClientPolicies(RealmModel.ClientRemovedEvent event, AuthorizationProvider authorizationProvider) {
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        ResourceServerStore store = storeFactory.getResourceServerStore();
        ResourceServer resourceServer = store.findById(event.getClient().getId());
        if (resourceServer != null) {
            storeFactory.getResourceServerStore().delete(resourceServer.getId());
        }
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        attributes.put("type", new String[]{"client"});
        attributes.put("config:clients", new String[]{event.getClient().getId()});
        List<Policy> search = storeFactory.getPolicyStore().findByResourceServer(attributes, null, -1, -1);
        for (Policy policy : search) {
            Object policyFactory = authorizationProvider.getProviderFactory(policy.getType());
            ClientPolicyRepresentation representation = (ClientPolicyRepresentation)ClientPolicyRepresentation.class.cast(policyFactory.toRepresentation(policy, authorizationProvider));
            Set clients = representation.getClients();
            clients.remove(event.getClient().getId());
            if (clients.isEmpty()) {
                policyFactory.onRemove(policy, authorizationProvider);
                authorizationProvider.getStoreFactory().getPolicyStore().delete(policy.getId());
                continue;
            }
            policyFactory.onUpdate(policy, (ClientPolicyRepresentation)representation, authorizationProvider);
        }
    }
}

