/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.user;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public interface UserQueryProvider {
    public int getUsersCount(RealmModel var1);

    default public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.getUsers(realm), groupIds);
    }

    default public int getUsersCount(String search, RealmModel realm) {
        return this.searchForUser(search, realm).size();
    }

    default public int getUsersCount(String search, RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        List<UserModel> users = this.searchForUser(search, realm);
        return UserQueryProvider.countUsersInGroups(users, groupIds);
    }

    default public int getUsersCount(Map<String, String> params, RealmModel realm) {
        return this.searchForUser(params, realm).size();
    }

    default public int getUsersCount(Map<String, String> params, RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        List<UserModel> users = this.searchForUser(params, realm);
        return UserQueryProvider.countUsersInGroups(users, groupIds);
    }

    public static int countUsersInGroups(List<UserModel> users, Set<String> groupIds) {
        return (int)users.stream().filter(u -> {
            for (GroupModel group : u.getGroups()) {
                if (!groupIds.contains(group.getId())) continue;
                return true;
            }
            return false;
        }).count();
    }

    default public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        throw new RuntimeException("Not implemented");
    }

    public List<UserModel> getUsers(RealmModel var1);

    public List<UserModel> getUsers(RealmModel var1, int var2, int var3);

    public List<UserModel> searchForUser(String var1, RealmModel var2);

    public List<UserModel> searchForUser(String var1, RealmModel var2, int var3, int var4);

    public List<UserModel> searchForUser(Map<String, String> var1, RealmModel var2);

    public List<UserModel> searchForUser(Map<String, String> var1, RealmModel var2, int var3, int var4);

    public List<UserModel> getGroupMembers(RealmModel var1, GroupModel var2, int var3, int var4);

    default public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role) {
        return Collections.EMPTY_LIST;
    }

    default public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role, int firstResult, int maxResults) {
        return Collections.EMPTY_LIST;
    }

    public List<UserModel> getGroupMembers(RealmModel var1, GroupModel var2);

    public List<UserModel> searchForUserByUserAttribute(String var1, String var2, RealmModel var3);
}

