/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.user;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public interface UserQueryProvider {
    default public int getUsersCount(RealmModel realm) {
        return this.getUsersCount(realm, false);
    }

    default public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.getUsersStream(realm), groupIds);
    }

    default public int getUsersCount(RealmModel realm, String search) {
        return this.getUsersCount(search, realm);
    }

    @Deprecated
    default public int getUsersCount(String search, RealmModel realm) {
        return (int)this.searchForUserStream(realm, search).count();
    }

    default public int getUsersCount(RealmModel realm, String search, Set<String> groupIds) {
        return this.getUsersCount(search, realm, groupIds);
    }

    @Deprecated
    default public int getUsersCount(String search, RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.searchForUserStream(realm, search), groupIds);
    }

    default public int getUsersCount(RealmModel realm, Map<String, String> params) {
        return this.getUsersCount(params, realm);
    }

    @Deprecated
    default public int getUsersCount(Map<String, String> params, RealmModel realm) {
        return (int)this.searchForUserStream(realm, params).count();
    }

    default public int getUsersCount(RealmModel realm, Map<String, String> params, Set<String> groupIds) {
        return this.getUsersCount(params, realm, groupIds);
    }

    @Deprecated
    default public int getUsersCount(Map<String, String> params, RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.searchForUserStream(realm, params), groupIds);
    }

    public static int countUsersInGroups(Stream<UserModel> users, Set<String> groupIds) {
        return (int)users.filter(u -> u.getGroupsStream().map(GroupModel::getId).anyMatch(groupIds::contains)).count();
    }

    default public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        throw new RuntimeException("Not implemented");
    }

    @Deprecated
    public List<UserModel> getUsers(RealmModel var1);

    default public Stream<UserModel> getUsersStream(RealmModel realm) {
        List<UserModel> value = this.getUsers(realm);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> getUsers(RealmModel var1, int var2, int var3);

    default public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        List<UserModel> value = this.getUsers(realm, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> searchForUser(String var1, RealmModel var2);

    default public Stream<UserModel> searchForUserStream(RealmModel realm, String search) {
        List<UserModel> value = this.searchForUser(search, realm);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> searchForUser(String var1, RealmModel var2, int var3, int var4);

    default public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        List<UserModel> value = this.searchForUser(search, realm, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> searchForUser(Map<String, String> var1, RealmModel var2);

    default public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params) {
        List<UserModel> value = this.searchForUser(params, realm);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> searchForUser(Map<String, String> var1, RealmModel var2, int var3, int var4);

    default public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params, Integer firstResult, Integer maxResults) {
        List<UserModel> value = this.searchForUser(params, realm, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> getGroupMembers(RealmModel var1, GroupModel var2);

    default public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
        List<UserModel> value = this.getGroupMembers(realm, group);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> getGroupMembers(RealmModel var1, GroupModel var2, int var3, int var4);

    default public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        List<UserModel> value = this.getGroupMembers(realm, group, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    default public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role) {
        return this.getRoleMembersStream(realm, role).collect(Collectors.toList());
    }

    default public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role) {
        return this.getRoleMembersStream(realm, role, null, null);
    }

    @Deprecated
    default public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role, int firstResult, int maxResults) {
        return Collections.emptyList();
    }

    default public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        return this.getRoleMembers(realm, role, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults).stream();
    }

    @Deprecated
    public List<UserModel> searchForUserByUserAttribute(String var1, String var2, RealmModel var3);

    default public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        List<UserModel> value = this.searchForUserByUserAttribute(attrName, attrValue, realm);
        return value != null ? value.stream() : Stream.empty();
    }

    public static interface Streams
    extends UserQueryProvider {
        @Override
        default public int getUsersCount(RealmModel realm, String search) {
            return (int)this.searchForUserStream(realm, search).count();
        }

        @Override
        default public int getUsersCount(String search, RealmModel realm) {
            return this.getUsersCount(realm, search);
        }

        @Override
        default public int getUsersCount(RealmModel realm, String search, Set<String> groupIds) {
            if (groupIds == null || groupIds.isEmpty()) {
                return 0;
            }
            return UserQueryProvider.countUsersInGroups(this.searchForUserStream(realm, search), groupIds);
        }

        @Override
        default public int getUsersCount(String search, RealmModel realm, Set<String> groupIds) {
            return this.getUsersCount(realm, search, groupIds);
        }

        @Override
        default public int getUsersCount(RealmModel realm, Map<String, String> params) {
            return (int)this.searchForUserStream(realm, params).count();
        }

        @Override
        default public int getUsersCount(Map<String, String> params, RealmModel realm) {
            return this.getUsersCount(realm, params);
        }

        @Override
        default public int getUsersCount(RealmModel realm, Map<String, String> params, Set<String> groupIds) {
            if (groupIds == null || groupIds.isEmpty()) {
                return 0;
            }
            return UserQueryProvider.countUsersInGroups(this.searchForUserStream(realm, params), groupIds);
        }

        @Override
        default public int getUsersCount(Map<String, String> params, RealmModel realm, Set<String> groupIds) {
            return this.getUsersCount(realm, params, groupIds);
        }

        @Override
        default public List<UserModel> getUsers(RealmModel realm) {
            return this.getUsersStream(realm).collect(Collectors.toList());
        }

        @Override
        default public Stream<UserModel> getUsersStream(RealmModel realm) {
            return this.getUsersStream(realm, null, null);
        }

        @Override
        default public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
            return this.getUsersStream(realm, firstResult, maxResults).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> getUsersStream(RealmModel var1, Integer var2, Integer var3);

        @Override
        default public List<UserModel> searchForUser(String search, RealmModel realm) {
            return this.searchForUserStream(realm, search).collect(Collectors.toList());
        }

        @Override
        default public Stream<UserModel> searchForUserStream(RealmModel realm, String search) {
            return this.searchForUserStream(realm, search, null, null);
        }

        @Override
        default public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
            return this.searchForUserStream(realm, search, (Integer)firstResult, (Integer)maxResults).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> searchForUserStream(RealmModel var1, String var2, Integer var3, Integer var4);

        @Override
        default public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm) {
            return this.searchForUserStream(realm, params).collect(Collectors.toList());
        }

        @Override
        default public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params) {
            return this.searchForUserStream(realm, params, null, null);
        }

        @Override
        default public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm, int firstResult, int maxResults) {
            return this.searchForUserStream(realm, params, (Integer)firstResult, (Integer)maxResults).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> searchForUserStream(RealmModel var1, Map<String, String> var2, Integer var3, Integer var4);

        @Override
        default public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
            return this.getGroupMembersStream(realm, group).collect(Collectors.toList());
        }

        @Override
        default public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
            return this.getGroupMembersStream(realm, group, null, null);
        }

        @Override
        default public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
            return this.getGroupMembersStream(realm, group, firstResult, maxResults).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> getGroupMembersStream(RealmModel var1, GroupModel var2, Integer var3, Integer var4);

        @Override
        default public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
            return this.searchForUserByUserAttributeStream(realm, attrName, attrValue).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel var1, String var2, String var3);
    }
}

