/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.SocialMappingRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserRoleMappingRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.OAuthClientManager;

public class RealmManager {
    protected static final Logger logger = Logger.getLogger(RealmManager.class);
    private static AtomicLong counter = new AtomicLong(1L);
    protected KeycloakSession identitySession;

    public static String generateId() {
        return counter.getAndIncrement() + "-" + System.currentTimeMillis();
    }

    public RealmManager(KeycloakSession identitySession) {
        this.identitySession = identitySession;
    }

    public RealmModel getKeycloakAdminstrationRealm() {
        return this.getRealm("keycloak-admin");
    }

    public RealmModel getRealm(String id) {
        return this.identitySession.getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.identitySession.getRealmByName(name);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(name, name);
    }

    public RealmModel createRealm(String id, String name) {
        if (id == null) {
            id = RealmManager.generateId();
        }
        RealmModel realm = this.identitySession.createRealm(id, name);
        realm.setName(name);
        realm.addRole("KEYCLOAK__APPLICATION");
        realm.addRole("KEYCLOAK__IDENTITY_REQUESTER");
        this.setupAccountManagement(realm);
        return realm;
    }

    public void generateRealmKeys(RealmModel realm) {
        KeyPair keyPair = null;
        try {
            keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        realm.setPrivateKey(keyPair.getPrivate());
        realm.setPublicKey(keyPair.getPublic());
    }

    public void updateRealm(RealmRepresentation rep, RealmModel realm) {
        if (rep.getRealm() != null) {
            logger.info("Updating realm name to " + rep.getRealm());
            realm.setName(rep.getRealm());
        }
        if (rep.isEnabled() != null) {
            realm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isSocial() != null) {
            realm.setSocial(rep.isSocial().booleanValue());
        }
        if (rep.isRegistrationAllowed() != null) {
            realm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            realm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            realm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isUpdateProfileOnInitialSocialLogin() != null) {
            realm.setUpdateProfileOnInitialSocialLogin(rep.isUpdateProfileOnInitialSocialLogin().booleanValue());
        }
        if (rep.isSslNotRequired() != null) {
            realm.setSslNotRequired(rep.isSslNotRequired().booleanValue());
        }
        if (rep.getAccessCodeLifespan() != null) {
            realm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            realm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        }
        if (rep.getTokenLifespan() != null) {
            realm.setTokenLifespan(rep.getTokenLifespan().intValue());
        }
        if (rep.getRequiredOAuthClientCredentials() != null) {
            realm.updateRequiredOAuthClientCredentials(rep.getRequiredOAuthClientCredentials());
        }
        if (rep.getRequiredCredentials() != null) {
            realm.updateRequiredCredentials(rep.getRequiredCredentials());
        }
        if (rep.getRequiredApplicationCredentials() != null) {
            realm.updateRequiredApplicationCredentials(rep.getRequiredApplicationCredentials());
        }
        realm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        if (rep.getDefaultRoles() != null) {
            realm.updateDefaultRoles(rep.getDefaultRoles().toArray(new String[rep.getDefaultRoles().size()]));
        }
        if (rep.getSmtpServer() != null) {
            realm.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
        if (rep.getSocialProviders() != null) {
            realm.setSocialConfig(new HashMap(rep.getSocialProviders()));
        }
        if ("GENERATE".equals(rep.getPublicKey())) {
            this.generateRealmKeys(realm);
        }
    }

    private void setupAccountManagement(RealmModel realm) {
        ApplicationModel application = (ApplicationModel)realm.getApplicationNameMap().get("account");
        if (application == null) {
            application = realm.addApplication("account");
            application.setEnabled(true);
            application.addDefaultRole("view-profile");
            application.addDefaultRole("manage-account");
            UserCredentialModel password = new UserCredentialModel();
            password.setType("password");
            password.setValue(UUID.randomUUID().toString());
            realm.updateCredential(application.getApplicationUser(), password);
            RoleModel applicationRole = realm.getRole("KEYCLOAK__APPLICATION");
            realm.grantRole(application.getApplicationUser(), applicationRole);
        }
    }

    public RealmModel importRealm(RealmRepresentation rep, UserModel realmCreator) {
        String id = rep.getId();
        if (id == null) {
            id = RealmManager.generateId();
        }
        RealmModel realm = this.createRealm(id, rep.getRealm());
        this.importRealm(rep, realm);
        return realm;
    }

    public void importRealm(RealmRepresentation rep, RealmModel newRealm) {
        UserModel user;
        ApplicationModel app;
        ApplicationManager manager;
        Map appMap;
        newRealm.setName(rep.getRealm());
        if (rep.isEnabled() != null) {
            newRealm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isSocial() != null) {
            newRealm.setSocial(rep.isSocial().booleanValue());
        }
        if (rep.getTokenLifespan() != null) {
            newRealm.setTokenLifespan(rep.getTokenLifespan().intValue());
        } else {
            newRealm.setTokenLifespan(300);
        }
        if (rep.getAccessCodeLifespan() != null) {
            newRealm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        } else {
            newRealm.setAccessCodeLifespan(60);
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            newRealm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        } else {
            newRealm.setAccessCodeLifespanUserAction(300);
        }
        if (rep.isSslNotRequired() != null) {
            newRealm.setSslNotRequired(rep.isSslNotRequired().booleanValue());
        }
        if (rep.isRegistrationAllowed() != null) {
            newRealm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            newRealm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            newRealm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isUpdateProfileOnInitialSocialLogin() != null) {
            newRealm.setUpdateProfileOnInitialSocialLogin(rep.isUpdateProfileOnInitialSocialLogin().booleanValue());
        }
        if (rep.getPrivateKey() == null || rep.getPublicKey() == null) {
            this.generateRealmKeys(newRealm);
        } else {
            newRealm.setPrivateKeyPem(rep.getPrivateKey());
            newRealm.setPublicKeyPem(rep.getPublicKey());
        }
        HashMap<String, UserModel> userMap = new HashMap<String, UserModel>();
        if (rep.getRequiredCredentials() != null) {
            for (String requiredCred : rep.getRequiredCredentials()) {
                this.addRequiredCredential(newRealm, requiredCred);
            }
        } else {
            this.addRequiredCredential(newRealm, "password");
        }
        if (rep.getRequiredApplicationCredentials() != null) {
            for (String requiredCred : rep.getRequiredApplicationCredentials()) {
                this.addResourceRequiredCredential(newRealm, requiredCred);
            }
        } else {
            this.addResourceRequiredCredential(newRealm, "password");
        }
        if (rep.getRequiredOAuthClientCredentials() != null) {
            for (String requiredCred : rep.getRequiredOAuthClientCredentials()) {
                this.addOAuthClientRequiredCredential(newRealm, requiredCred);
            }
        } else {
            this.addOAuthClientRequiredCredential(newRealm, "password");
        }
        newRealm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        if (rep.getUsers() != null) {
            for (UserRepresentation userRep : rep.getUsers()) {
                UserModel userModel = this.createUser(newRealm, userRep);
                userMap.put(userModel.getLoginName(), userModel);
            }
        }
        if (rep.getRoles() != null) {
            for (RoleRepresentation roleRep : rep.getRoles()) {
                this.createRole(newRealm, roleRep);
            }
        }
        if (rep.getDefaultRoles() != null) {
            for (String roleString : rep.getDefaultRoles()) {
                newRealm.addDefaultRole(roleString.trim());
            }
        }
        if (rep.getApplications() != null) {
            appMap = this.createApplications(rep, newRealm);
            for (ApplicationModel applicationModel : appMap.values()) {
                userMap.put(applicationModel.getApplicationUser().getLoginName(), applicationModel.getApplicationUser());
            }
        }
        if (rep.getOauthClients() != null) {
            Map<String, OAuthClientModel> oauthMap = this.createOAuthClients(rep, newRealm);
            for (OAuthClientModel oAuthClientModel : oauthMap.values()) {
                userMap.put(oAuthClientModel.getOAuthAgent().getLoginName(), oAuthClientModel.getOAuthAgent());
            }
        }
        appMap = newRealm.getApplicationNameMap();
        if (rep.getApplicationRoleMappings() != null) {
            manager = new ApplicationManager(this);
            for (Map.Entry entry : rep.getApplicationRoleMappings().entrySet()) {
                app = (ApplicationModel)appMap.get(entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find application role mappings for app: " + (String)entry.getKey());
                }
                manager.createRoleMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getApplicationScopeMappings() != null) {
            manager = new ApplicationManager(this);
            for (Map.Entry entry : rep.getApplicationScopeMappings().entrySet()) {
                app = (ApplicationModel)appMap.get(entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find application role mappings for app: " + (String)entry.getKey());
                }
                manager.createScopeMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getRoleMappings() != null) {
            for (UserRoleMappingRepresentation userRoleMappingRepresentation : rep.getRoleMappings()) {
                user = (UserModel)userMap.get(userRoleMappingRepresentation.getUsername());
                for (String roleString : userRoleMappingRepresentation.getRoles()) {
                    RoleModel role = newRealm.getRole(roleString.trim());
                    if (role == null) {
                        role = newRealm.addRole(roleString.trim());
                    }
                    newRealm.grantRole(user, role);
                }
            }
        }
        if (rep.getScopeMappings() != null) {
            for (ScopeMappingRepresentation scopeMappingRepresentation : rep.getScopeMappings()) {
                for (String roleString : scopeMappingRepresentation.getRoles()) {
                    RoleModel role = newRealm.getRole(roleString.trim());
                    if (role == null) {
                        role = newRealm.addRole(roleString.trim());
                    }
                    UserModel user3 = (UserModel)userMap.get(scopeMappingRepresentation.getUsername());
                    newRealm.addScopeMapping(user3, role.getName());
                }
            }
        }
        if (rep.getSocialMappings() != null) {
            for (SocialMappingRepresentation socialMappingRepresentation : rep.getSocialMappings()) {
                user = (UserModel)userMap.get(socialMappingRepresentation.getUsername());
                for (SocialLinkRepresentation link : socialMappingRepresentation.getSocialLinks()) {
                    SocialLinkModel mappingModel = new SocialLinkModel(link.getSocialProvider(), link.getSocialUsername());
                    newRealm.addSocialLink(user, mappingModel);
                }
            }
        }
        if (rep.getSmtpServer() != null) {
            newRealm.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
        if (rep.getSocialProviders() != null) {
            newRealm.setSocialConfig(new HashMap(rep.getSocialProviders()));
        }
    }

    public void createRole(RealmModel newRealm, RoleRepresentation roleRep) {
        RoleModel role = newRealm.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
    }

    public UserModel createUser(RealmModel newRealm, UserRepresentation userRep) {
        UserModel user = newRealm.addUser(userRep.getUsername());
        user.setEnabled(userRep.isEnabled());
        user.setEmail(userRep.getEmail());
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                user.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String requiredAction : userRep.getRequiredActions()) {
                user.addRequiredAction(UserModel.RequiredAction.valueOf((String)requiredAction));
            }
        }
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                UserCredentialModel credential = RealmManager.fromRepresentation(cred);
                newRealm.updateCredential(user, credential);
            }
        }
        return user;
    }

    public static UserCredentialModel fromRepresentation(CredentialRepresentation cred) {
        UserCredentialModel credential = new UserCredentialModel();
        credential.setType(cred.getType());
        credential.setValue(cred.getValue());
        return credential;
    }

    public List<UserModel> searchUsers(String searchString, RealmModel realmModel) {
        if (searchString == null) {
            return Collections.emptyList();
        }
        return realmModel.searchForUser(searchString.trim());
    }

    public void addRequiredCredential(RealmModel newRealm, String requiredCred) {
        newRealm.addRequiredCredential(requiredCred);
    }

    public void addResourceRequiredCredential(RealmModel newRealm, String requiredCred) {
        newRealm.addRequiredResourceCredential(requiredCred);
    }

    public void addOAuthClientRequiredCredential(RealmModel newRealm, String requiredCred) {
        newRealm.addRequiredOAuthClientCredential(requiredCred);
    }

    protected Map<String, ApplicationModel> createApplications(RealmRepresentation rep, RealmModel realm) {
        HashMap<String, ApplicationModel> appMap = new HashMap<String, ApplicationModel>();
        RoleModel loginRole = realm.getRole("KEYCLOAK__APPLICATION");
        ApplicationManager manager = new ApplicationManager(this);
        for (ApplicationRepresentation resourceRep : rep.getApplications()) {
            ApplicationModel app = manager.createApplication(realm, loginRole, resourceRep);
            appMap.put(app.getName(), app);
        }
        return appMap;
    }

    protected Map<String, OAuthClientModel> createOAuthClients(RealmRepresentation realmRep, RealmModel realm) {
        HashMap<String, OAuthClientModel> appMap = new HashMap<String, OAuthClientModel>();
        OAuthClientManager manager = new OAuthClientManager(realm);
        for (OAuthClientRepresentation rep : realmRep.getOauthClients()) {
            OAuthClientModel app = manager.create(rep);
            appMap.put(app.getOAuthAgent().getLoginName(), app);
        }
        return appMap;
    }

    public static UserRepresentation toRepresentation(UserModel user) {
        UserRepresentation rep = new UserRepresentation();
        rep.setUsername(user.getLoginName());
        rep.setLastName(user.getLastName());
        rep.setFirstName(user.getFirstName());
        rep.setEmail(user.getEmail());
        rep.setEnabled(user.isEnabled());
        rep.setEmailVerified(user.isEmailVerified());
        rep.setTotp(user.isTotp());
        ArrayList<String> reqActions = new ArrayList<String>();
        for (UserModel.RequiredAction ra : user.getRequiredActions()) {
            reqActions.add(ra.name());
        }
        rep.setRequiredActions(reqActions);
        if (user.getAttributes() != null && !user.getAttributes().isEmpty()) {
            HashMap attrs = new HashMap();
            attrs.putAll(user.getAttributes());
            rep.setAttributes(attrs);
        }
        return rep;
    }

    public static RoleRepresentation toRepresentation(RoleModel role) {
        RoleRepresentation rep = new RoleRepresentation();
        rep.setId(role.getId());
        rep.setName(role.getName());
        rep.setDescription(role.getDescription());
        return rep;
    }

    public static RealmRepresentation toRepresentation(RealmModel realm) {
        List requiredOAuthCredentialModels;
        List requiredResourceCredentialModels;
        List requiredCredentialModels;
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId(realm.getId());
        rep.setRealm(realm.getName());
        rep.setEnabled(Boolean.valueOf(realm.isEnabled()));
        rep.setSocial(Boolean.valueOf(realm.isSocial()));
        rep.setUpdateProfileOnInitialSocialLogin(Boolean.valueOf(realm.isUpdateProfileOnInitialSocialLogin()));
        rep.setSslNotRequired(Boolean.valueOf(realm.isSslNotRequired()));
        rep.setPublicKey(realm.getPublicKeyPem());
        rep.setPrivateKey(realm.getPrivateKeyPem());
        rep.setRegistrationAllowed(Boolean.valueOf(realm.isRegistrationAllowed()));
        rep.setVerifyEmail(Boolean.valueOf(realm.isVerifyEmail()));
        rep.setResetPasswordAllowed(Boolean.valueOf(realm.isResetPasswordAllowed()));
        rep.setTokenLifespan(Integer.valueOf(realm.getTokenLifespan()));
        rep.setAccessCodeLifespan(Integer.valueOf(realm.getAccessCodeLifespan()));
        rep.setAccessCodeLifespanUserAction(Integer.valueOf(realm.getAccessCodeLifespanUserAction()));
        rep.setSmtpServer(realm.getSmtpConfig());
        rep.setSocialProviders(realm.getSocialConfig());
        if (realm.getPasswordPolicy() != null) {
            rep.setPasswordPolicy(realm.getPasswordPolicy().toString());
        }
        ApplicationModel accountManagementApplication = (ApplicationModel)realm.getApplicationNameMap().get("account");
        List defaultRoles = realm.getDefaultRoles();
        if (!defaultRoles.isEmpty()) {
            ArrayList roleStrings = new ArrayList();
            roleStrings.addAll(defaultRoles);
            rep.setDefaultRoles(roleStrings);
        }
        if ((requiredCredentialModels = realm.getRequiredCredentials()).size() > 0) {
            rep.setRequiredCredentials(new HashSet());
            for (RequiredCredentialModel cred : requiredCredentialModels) {
                rep.getRequiredCredentials().add(cred.getType());
            }
        }
        if ((requiredResourceCredentialModels = realm.getRequiredApplicationCredentials()).size() > 0) {
            rep.setRequiredApplicationCredentials(new HashSet());
            for (RequiredCredentialModel cred : requiredResourceCredentialModels) {
                rep.getRequiredApplicationCredentials().add(cred.getType());
            }
        }
        if ((requiredOAuthCredentialModels = realm.getRequiredOAuthClientCredentials()).size() > 0) {
            rep.setRequiredOAuthClientCredentials(new HashSet());
            for (RequiredCredentialModel cred : requiredOAuthCredentialModels) {
                rep.getRequiredOAuthClientCredentials().add(cred.getType());
            }
        }
        return rep;
    }
}

