/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.keycloak.social.RequestDetails;

public class SocialRequestManager {
    public static final long TIMEOUT = 600000L;
    private Map<String, RequestDetails> map = new HashMap<String, RequestDetails>();
    private LinkedHashMap<String, Long> expires = new LinkedHashMap();

    public synchronized void addRequest(String requestId, RequestDetails request) {
        this.pruneExpired();
        this.map.put(requestId, request);
        this.expires.put(requestId, System.currentTimeMillis() + 600000L);
    }

    public synchronized boolean isRequestId(String requestId) {
        return this.map.containsKey(requestId);
    }

    public synchronized RequestDetails retrieveData(String requestId) {
        this.expires.remove(requestId);
        RequestDetails details = this.map.remove(requestId);
        this.pruneExpired();
        return details;
    }

    public synchronized RequestDetails getData(String requestId) {
        return this.map.get(requestId);
    }

    private void pruneExpired() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> itr = this.expires.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Long> e = itr.next();
            if (e.getValue() < currentTime) {
                itr.remove();
                this.map.remove(e.getKey());
                continue;
            }
            return;
        }
    }
}

