/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.PublishedRealmRepresentation;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.TokenService;

public class PublicRealmResource {
    protected static final Logger logger = Logger.getLogger(PublicRealmResource.class);
    public static final String ADMIN_ROLE = "$REALM-ADMIN$";
    @Context
    protected UriInfo uriInfo;
    protected RealmModel realm;

    public PublicRealmResource(RealmModel realm) {
        this.realm = realm;
    }

    public static UriBuilder realmUrl(UriInfo uriInfo) {
        UriBuilder base = uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
        return base;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public PublishedRealmRepresentation getRealm(@PathParam(value="realm") String id) {
        return PublicRealmResource.realmRep(this.realm, this.uriInfo);
    }

    @GET
    @NoCache
    @Path(value="html")
    @Produces(value={"text/html"})
    public String getRealmHtml(@PathParam(value="realm") String id) {
        StringBuffer html = new StringBuffer();
        String authUri = TokenService.loginPageUrl(this.uriInfo).build(new Object[]{this.realm.getName()}).toString();
        String codeUri = TokenService.accessCodeToTokenUrl(this.uriInfo).build(new Object[]{this.realm.getName()}).toString();
        String grantUrl = TokenService.grantAccessTokenUrl(this.uriInfo).build(new Object[]{this.realm.getName()}).toString();
        String idGrantUrl = TokenService.grantIdentityTokenUrl(this.uriInfo).build(new Object[]{this.realm.getName()}).toString();
        html.append("<html><body><h1>Realm: ").append(this.realm.getName()).append("</h1>");
        html.append("<p>auth: ").append(authUri).append("</p>");
        html.append("<p>code: ").append(codeUri).append("</p>");
        html.append("<p>grant: ").append(grantUrl).append("</p>");
        html.append("<p>identity grant: ").append(idGrantUrl).append("</p>");
        html.append("<p>public key: ").append(this.realm.getPublicKeyPem()).append("</p>");
        html.append("</body></html>");
        return html.toString();
    }

    public static PublishedRealmRepresentation realmRep(RealmModel realm, UriInfo uriInfo) {
        PublishedRealmRepresentation rep = new PublishedRealmRepresentation();
        rep.setRealm(realm.getName());
        rep.setSelf(PublicRealmResource.realmUrl(uriInfo).build(new Object[]{realm.getId()}).toString());
        rep.setPublicKeyPem(realm.getPublicKeyPem());
        rep.setAdminRole(ADMIN_ROLE);
        rep.setAuthorizationUrl(TokenService.loginPageUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        rep.setCodeUrl(TokenService.accessCodeToTokenUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        rep.setGrantUrl(TokenService.grantAccessTokenUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        String idGrantUrl = TokenService.grantIdentityTokenUrl(uriInfo).build(new Object[]{realm.getName()}).toString();
        rep.setIdentityGrantUrl(idGrantUrl);
        return rep;
    }
}

