/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ApplicationMappingsRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.flows.Flows;

public class UsersResource {
    protected static final Logger logger = Logger.getLogger(UsersResource.class);
    protected RealmModel realm;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;

    public UsersResource(RealmModel realm) {
        this.realm = realm;
    }

    @Path(value="{username}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateUser(@PathParam(value="username") String username, UserRepresentation rep) {
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        this.updateUserFromRep(user, rep);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createUser(@Context UriInfo uriInfo, UserRepresentation rep) {
        if (this.realm.getUser(rep.getUsername()) != null) {
            return Flows.errors().exists("User with username " + rep.getUsername() + " already exists");
        }
        UserModel user = this.realm.addUser(rep.getUsername());
        if (user == null) {
            throw new NotFoundException();
        }
        this.updateUserFromRep(user, rep);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(user.getLoginName()).build(new Object[0])).build();
    }

    private void updateUserFromRep(UserModel user, UserRepresentation rep) {
        user.setEmail(rep.getEmail());
        user.setFirstName(rep.getFirstName());
        user.setLastName(rep.getLastName());
        user.setEnabled(rep.isEnabled());
        user.setTotp(rep.isTotp());
        user.setEmailVerified(rep.isEmailVerified());
        List reqActions = rep.getRequiredActions();
        for (UserModel.RequiredAction ra : UserModel.RequiredAction.values()) {
            if (reqActions.contains(ra.name())) {
                user.addRequiredAction(ra);
                continue;
            }
            user.removeRequiredAction(ra);
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry attr : rep.getAttributes().entrySet()) {
                user.setAttribute((String)attr.getKey(), (String)attr.getValue());
            }
        }
    }

    @Path(value="{username}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserRepresentation getUser(@PathParam(value="username") String username) {
        UserModel user = this.realm.getUser(username);
        if (user == null || !this.isUser(user)) {
            throw new NotFoundException();
        }
        new RealmManager(this.session);
        return RealmManager.toRepresentation(user);
    }

    @Path(value="{username}")
    @DELETE
    @NoCache
    public void deleteUser(@PathParam(value="username") String username) {
        this.realm.removeUser(username);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserRepresentation> getUsers(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="username") String username) {
        List userModels;
        RealmManager manager = new RealmManager(this.session);
        ArrayList<UserRepresentation> results = new ArrayList<UserRepresentation>();
        if (search != null) {
            userModels = manager.searchUsers(search, this.realm);
        } else if (last != null || first != null || email != null || username != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (last != null) {
                attributes.put("lastName", last);
            }
            if (first != null) {
                attributes.put("firstName", first);
            }
            if (email != null) {
                attributes.put("email", email);
            }
            if (username != null) {
                attributes.put("username", username);
            }
            userModels = this.realm.searchForUserByAttributes(attributes);
            for (UserModel user : userModels) {
                results.add(RealmManager.toRepresentation(user));
            }
        } else {
            userModels = this.realm.getUsers();
        }
        for (UserModel user : userModels) {
            if (!this.isUser(user)) continue;
            results.add(RealmManager.toRepresentation(user));
        }
        return results;
    }

    private boolean isUser(UserModel user) {
        return !this.realm.hasRole(user, this.realm.getRole("KEYCLOAK__IDENTITY_REQUESTER")) && !this.realm.hasRole(user, this.realm.getRole("KEYCLOAK__APPLICATION"));
    }

    @Path(value="{username}/role-mappings")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public MappingsRepresentation getRoleMappings(@PathParam(value="username") String username) {
        List applications;
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        MappingsRepresentation all = new MappingsRepresentation();
        List realmMappings = this.realm.getRoleMappings(user);
        RealmManager manager = new RealmManager(this.session);
        if (realmMappings.size() > 0) {
            ArrayList<RoleRepresentation> realmRep = new ArrayList<RoleRepresentation>();
            for (RoleModel roleModel : realmMappings) {
                realmRep.add(RealmManager.toRepresentation(roleModel));
            }
            all.setRealmMappings(realmRep);
        }
        if ((applications = this.realm.getApplications()).size() > 0) {
            HashMap<String, ApplicationMappingsRepresentation> appMappings = new HashMap<String, ApplicationMappingsRepresentation>();
            for (ApplicationModel application : applications) {
                List roleMappings = application.getRoleMappings(user);
                if (roleMappings.size() <= 0) continue;
                ApplicationMappingsRepresentation mappings = new ApplicationMappingsRepresentation();
                mappings.setApplicationId(application.getId());
                mappings.setApplication(application.getName());
                ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
                mappings.setMappings(roles);
                for (RoleModel role : roleMappings) {
                    roles.add(RealmManager.toRepresentation(role));
                }
                appMappings.put(application.getName(), mappings);
                all.setApplicationMappings(appMappings);
            }
        }
        return all;
    }

    @Path(value="{username}/role-mappings/realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getRealmRoleMappings(@PathParam(value="username") String username) {
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        List realmMappings = this.realm.getRoleMappings(user);
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        RealmManager manager = new RealmManager(this.session);
        for (RoleModel roleModel : realmMappings) {
            realmMappingsRep.add(RealmManager.toRepresentation(roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="{username}/role-mappings/realm")
    @POST
    @Consumes(value={"application/json"})
    public void addRealmRoleMappings(@PathParam(value="username") String username, List<RoleRepresentation> roles) {
        logger.debug("** addRealmRoleMappings: {0}", new Object[]{roles});
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.realm.getRoleById(role.getId());
            if (roleModel == null) {
                throw new NotFoundException();
            }
            this.realm.grantRole(user, roleModel);
        }
    }

    @Path(value="{username}/role-mappings/realm")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteRealmRoleMappings(@PathParam(value="username") String username, List<RoleRepresentation> roles) {
        logger.debug("deleteRealmRoleMappings");
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        if (roles == null) {
            List roleModels = this.realm.getRoleMappings(user);
            for (RoleModel roleModel : roleModels) {
                this.realm.deleteRoleMapping(user, roleModel);
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRoleById(role.getId());
                if (roleModel == null) {
                    throw new NotFoundException();
                }
                this.realm.deleteRoleMapping(user, roleModel);
            }
        }
    }

    @Path(value="{username}/role-mappings/applications/{app}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getApplicationRoleMappings(@PathParam(value="username") String username, @PathParam(value="app") String appName) {
        logger.debug("getApplicationRoleMappings");
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        ApplicationModel application = this.realm.getApplicationByName(appName);
        if (application == null) {
            throw new NotFoundException();
        }
        List mappings = application.getRoleMappings(user);
        ArrayList<RoleRepresentation> mapRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : mappings) {
            mapRep.add(RealmManager.toRepresentation(roleModel));
        }
        logger.debug("getApplicationRoleMappings.size() = {0}", new Object[]{mapRep.size()});
        return mapRep;
    }

    @Path(value="{username}/role-mappings/applications/{app}")
    @POST
    @Consumes(value={"application/json"})
    public void addApplicationRoleMapping(@PathParam(value="username") String username, @PathParam(value="app") String appName, List<RoleRepresentation> roles) {
        logger.debug("addApplicationRoleMapping");
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        ApplicationModel application = this.realm.getApplicationByName(appName);
        if (application == null) {
            throw new NotFoundException();
        }
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = application.getRoleById(role.getId());
            if (roleModel == null) {
                throw new NotFoundException();
            }
            application.grantRole(user, roleModel);
        }
    }

    @Path(value="{username}/role-mappings/applications/{app}")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteApplicationRoleMapping(@PathParam(value="username") String username, @PathParam(value="app") String appName, List<RoleRepresentation> roles) {
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        ApplicationModel application = this.realm.getApplicationByName(appName);
        if (application == null) {
            throw new NotFoundException();
        }
        if (roles == null) {
            List roleModels = application.getRoleMappings(user);
            for (RoleModel roleModel : roleModels) {
                application.deleteRoleMapping(user, roleModel);
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = application.getRoleById(role.getId());
                if (roleModel == null) {
                    throw new NotFoundException();
                }
                application.deleteRoleMapping(user, roleModel);
            }
        }
    }

    @Path(value="{username}/credentials")
    @PUT
    @Consumes(value={"application/json"})
    public void updateCredentials(@PathParam(value="username") String username, List<CredentialRepresentation> credentials) {
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        if (credentials == null) {
            return;
        }
        for (CredentialRepresentation rep : credentials) {
            UserCredentialModel cred = RealmManager.fromRepresentation(rep);
            this.realm.updateCredential(user, cred);
        }
    }
}

