/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.flows;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.flows.Flows;

public class OAuthFlows {
    private static final Logger log = Logger.getLogger(OAuthFlows.class);
    private RealmModel realm;
    private HttpRequest request;
    private UriInfo uriInfo;
    private AuthenticationManager authManager;
    private TokenManager tokenManager;

    OAuthFlows(RealmModel realm, HttpRequest request, UriInfo uriInfo, AuthenticationManager authManager, TokenManager tokenManager) {
        this.realm = realm;
        this.request = request;
        this.uriInfo = uriInfo;
        this.authManager = authManager;
        this.tokenManager = tokenManager;
    }

    public Response redirectAccessCode(AccessCodeEntry accessCode, String state, String redirect) {
        String code = accessCode.getCode();
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("code", new Object[]{code});
        log.debug("redirectAccessCode: state: {0}", new Object[]{state});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        location.cookie(new NewCookie[]{this.authManager.createLoginCookie(this.realm, accessCode.getUser(), this.uriInfo)});
        return location.build();
    }

    public Response redirectError(UserModel client, String error, String state, String redirect) {
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{error});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        return Response.status((int)302).location(redirectUri.build(new Object[0])).build();
    }

    public Response processAccessCode(String scopeParam, String state, String redirect, UserModel client, UserModel user) {
        RoleModel resourceRole = this.realm.getRole("KEYCLOAK__APPLICATION");
        RoleModel identityRequestRole = this.realm.getRole("KEYCLOAK__IDENTITY_REQUESTER");
        boolean isResource = this.realm.hasRole(client, resourceRole);
        if (!isResource && !this.realm.hasRole(client, identityRequestRole)) {
            return this.forwardToSecurityFailure("Login requester not allowed to request login.");
        }
        AccessCodeEntry accessCode = this.tokenManager.createAccessCode(scopeParam, state, redirect, this.realm, client, user);
        log.debug("processAccessCode: isResource: {0}", new Object[]{isResource});
        log.debug("processAccessCode: go to oauth page?: {0}", new Object[]{!isResource && (accessCode.getRealmRolesRequested().size() > 0 || accessCode.getResourceRolesRequested().size() > 0)});
        Set requiredActions = user.getRequiredActions();
        if (!requiredActions.isEmpty()) {
            accessCode.setRequiredActions(new HashSet<UserModel.RequiredAction>(requiredActions));
            accessCode.setExpiration(System.currentTimeMillis() / 1000L + (long)this.realm.getAccessCodeLifespanUserAction());
            return Flows.forms(this.realm, this.request, this.uriInfo).setAccessCode(accessCode).setUser(user).forwardToAction((UserModel.RequiredAction)user.getRequiredActions().iterator().next());
        }
        if (!(isResource || accessCode.getRealmRolesRequested().size() <= 0 && accessCode.getResourceRolesRequested().size() <= 0)) {
            accessCode.setExpiration(System.currentTimeMillis() / 1000L + (long)this.realm.getAccessCodeLifespanUserAction());
            return this.oauthGrantPage(accessCode, client);
        }
        if (redirect != null) {
            return this.redirectAccessCode(accessCode, state, redirect);
        }
        return null;
    }

    public Response oauthGrantPage(AccessCodeEntry accessCode, UserModel client) {
        this.request.setAttribute("realmRolesRequested", accessCode.getRealmRolesRequested());
        this.request.setAttribute("resourceRolesRequested", accessCode.getResourceRolesRequested());
        this.request.setAttribute("client", (Object)client);
        this.request.setAttribute("action", (Object)TokenService.processOAuthUrl(this.uriInfo).build(new Object[]{this.realm.getName()}).toString());
        this.request.setAttribute("code", (Object)accessCode.getCode());
        return Flows.forms(this.realm, this.request, this.uriInfo).setAccessCode(accessCode).forwardToOAuthGrant();
    }

    public Response forwardToSecurityFailure(String message) {
        return Flows.forms(this.realm, this.request, this.uriInfo).setError(message).forwardToErrorPage();
    }
}

