/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;

public class AccessCodeEntry {
    protected String id = UUID.randomUUID().toString() + System.currentTimeMillis();
    protected String code;
    protected String state;
    protected String redirectUri;
    protected boolean rememberMe;
    protected long expiration;
    protected RealmModel realm;
    protected AccessToken token;
    protected UserModel user;
    protected Set<UserModel.RequiredAction> requiredActions;
    protected ClientModel client;
    protected List<RoleModel> realmRolesRequested = new ArrayList<RoleModel>();
    MultivaluedMap<String, RoleModel> resourceRolesRequested = new MultivaluedHashMap();

    public boolean isExpired() {
        return this.expiration != 0L && System.currentTimeMillis() / 1000L > this.expiration;
    }

    public String getId() {
        return this.id;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void setRealm(RealmModel realm) {
        this.realm = realm;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public void setToken(AccessToken token) {
        this.token = token;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public UserModel getUser() {
        return this.user;
    }

    public void setUser(UserModel user) {
        this.user = user;
    }

    public Set<UserModel.RequiredAction> getRequiredActions() {
        return this.requiredActions;
    }

    public void setRequiredActions(Set<UserModel.RequiredAction> requiredActions) {
        this.requiredActions = requiredActions;
    }

    public List<RoleModel> getRealmRolesRequested() {
        return this.realmRolesRequested;
    }

    public MultivaluedMap<String, RoleModel> getResourceRolesRequested() {
        return this.resourceRolesRequested;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }
}

