/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.TokenIdGenerator;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.SessionStats;
import org.keycloak.representations.adapters.action.SessionStatsAction;
import org.keycloak.representations.adapters.action.UserStats;
import org.keycloak.representations.adapters.action.UserStatsAction;
import org.keycloak.services.managers.TokenManager;

public class ResourceAdminManager {
    protected static Logger logger = Logger.getLogger(ResourceAdminManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionStats getSessionStats(RealmModel realm, ApplicationModel application, boolean users) {
        ResteasyClient client = new ResteasyClientBuilder().disableTrustManager().build();
        try {
            SessionStats sessionStats = this.getSessionStats(realm, application, users, client);
            return sessionStats;
        }
        finally {
            client.close();
        }
    }

    public SessionStats getSessionStats(RealmModel realm, ApplicationModel application, boolean users, ResteasyClient client) {
        String managementUrl = application.getManagementUrl();
        if (managementUrl != null) {
            SessionStatsAction adminAction = new SessionStatsAction(TokenIdGenerator.generateId(), (int)(System.currentTimeMillis() / 1000L) + 30, application.getName());
            adminAction.setListUsers(users);
            String token = new TokenManager().encodeToken(realm, adminAction);
            logger.info("session stats for application: {0} url: {1}", new Object[]{application.getName(), managementUrl});
            Response response = client.target(managementUrl).path("k_get_session_stats").request().post(Entity.text((Object)token));
            if (response.getStatus() != 200) {
                logger.warn("Failed to get stats: " + response.getStatus());
                return null;
            }
            SessionStats stats = (SessionStats)response.readEntity(SessionStats.class);
            if (users && stats.getUsers() != null) {
                HashMap newUsers = new HashMap();
                for (Map.Entry entry : stats.getUsers().entrySet()) {
                    UserModel user = realm.getUserById((String)entry.getKey());
                    if (user == null) continue;
                    newUsers.put(user.getLoginName(), entry.getValue());
                }
                stats.setUsers(newUsers);
            }
            return stats;
        }
        logger.info("no management url.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserStats getUserStats(RealmModel realm, ApplicationModel application, UserModel user) {
        ResteasyClient client = new ResteasyClientBuilder().disableTrustManager().build();
        try {
            UserStats userStats = this.getUserStats(realm, application, user, client);
            return userStats;
        }
        finally {
            client.close();
        }
    }

    public UserStats getUserStats(RealmModel realm, ApplicationModel application, UserModel user, ResteasyClient client) {
        String managementUrl = application.getManagementUrl();
        if (managementUrl != null) {
            UserStatsAction adminAction = new UserStatsAction(TokenIdGenerator.generateId(), (int)(System.currentTimeMillis() / 1000L) + 30, application.getName(), user.getId());
            String token = new TokenManager().encodeToken(realm, adminAction);
            logger.info("session stats for application: {0} url: {1}", new Object[]{application.getName(), managementUrl});
            Response response = client.target(managementUrl).path("k_get_user_stats").request().post(Entity.text((Object)token));
            if (response.getStatus() != 200) {
                logger.warn("Failed to get stats: " + response.getStatus());
                return null;
            }
            UserStats stats = (UserStats)response.readEntity(UserStats.class);
            return stats;
        }
        logger.info("no management url.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutUser(RealmModel realm, UserModel user) {
        ResteasyClient client = new ResteasyClientBuilder().disableTrustManager().build();
        try {
            List resources = realm.getApplications();
            logger.debug("logging out {0} resources ", new Object[]{resources.size()});
            for (ApplicationModel resource : resources) {
                this.logoutApplication(realm, resource, user.getId(), client, 0);
            }
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutAll(RealmModel realm) {
        ResteasyClient client = new ResteasyClientBuilder().disableTrustManager().build();
        try {
            realm.setNotBefore((int)(System.currentTimeMillis() / 1000L));
            List resources = realm.getApplications();
            logger.debug("logging out {0} resources ", new Object[]{resources.size()});
            for (ApplicationModel resource : resources) {
                this.logoutApplication(realm, resource, null, client, realm.getNotBefore());
            }
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutApplication(RealmModel realm, ApplicationModel resource, String user) {
        ResteasyClient client = new ResteasyClientBuilder().disableTrustManager().build();
        try {
            resource.setNotBefore((int)(System.currentTimeMillis() / 1000L));
            this.logoutApplication(realm, resource, user, client, resource.getNotBefore());
        }
        finally {
            client.close();
        }
    }

    protected boolean logoutApplication(RealmModel realm, ApplicationModel resource, String user, ResteasyClient client, int notBefore) {
        String managementUrl = resource.getManagementUrl();
        if (managementUrl != null) {
            LogoutAction adminAction = new LogoutAction(TokenIdGenerator.generateId(), (int)(System.currentTimeMillis() / 1000L) + 30, resource.getName(), user, notBefore);
            String token = new TokenManager().encodeToken(realm, adminAction);
            logger.info("logout user: {0} resource: {1} url: {2}", new Object[]{user, resource.getName(), managementUrl});
            Response response = client.target(managementUrl).path("k_logout").request().post(Entity.text((Object)token));
            boolean success = response.getStatus() == 204;
            response.close();
            logger.info("logout success.");
            return success;
        }
        logger.info("Can't logout" + resource.getName() + " no mgmt url.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRealmRevocationPolicy(RealmModel realm) {
        ResteasyClient client = new ResteasyClientBuilder().disableTrustManager().build();
        try {
            for (ApplicationModel application : realm.getApplications()) {
                this.pushRevocationPolicy(realm, application, realm.getNotBefore(), client);
            }
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushApplicationRevocationPolicy(RealmModel realm, ApplicationModel application) {
        ResteasyClient client = new ResteasyClientBuilder().disableTrustManager().build();
        try {
            this.pushRevocationPolicy(realm, application, application.getNotBefore(), client);
        }
        finally {
            client.close();
        }
    }

    protected boolean pushRevocationPolicy(RealmModel realm, ApplicationModel resource, int notBefore, ResteasyClient client) {
        if (notBefore <= 0) {
            return false;
        }
        String managementUrl = resource.getManagementUrl();
        if (managementUrl != null) {
            PushNotBeforeAction adminAction = new PushNotBeforeAction(TokenIdGenerator.generateId(), (int)(System.currentTimeMillis() / 1000L) + 30, resource.getName(), notBefore);
            String token = new TokenManager().encodeToken(realm, adminAction);
            logger.info("pushRevocation resource: {0} url: {1}", new Object[]{resource.getName(), managementUrl});
            Response response = client.target(managementUrl).path("k_push_not_before").request().post(Entity.text((Object)token));
            boolean success = response.getStatus() == 204;
            response.close();
            logger.info("pushRevocation success.");
            return success;
        }
        logger.info("no management URL for application: " + resource.getName());
        return false;
    }
}

