/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.ClientModel;

public class Cors {
    public static final long DEFAULT_MAX_AGE = TimeUnit.HOURS.toSeconds(1L);
    public static final String DEFAULT_ALLOW_METHODS = "GET, OPTIONS";
    public static final String ORIGIN = "Origin";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private HttpRequest request;
    private Response.ResponseBuilder response;
    private Set<String> allowedOrigins;
    private String[] allowedMethods;
    private boolean preflight;
    private boolean auth;

    public Cors(HttpRequest request, Response.ResponseBuilder response) {
        this.request = request;
        this.response = response;
    }

    public static Cors add(HttpRequest request, Response.ResponseBuilder response) {
        return new Cors(request, response);
    }

    public Cors preflight() {
        this.preflight = true;
        return this;
    }

    public Cors auth() {
        this.auth = true;
        return this;
    }

    public Cors allowedOrigins(ClientModel client) {
        if (client != null) {
            this.allowedOrigins = client.getWebOrigins();
        }
        return this;
    }

    public Cors allowedMethods(String ... allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public Response build() {
        String origin = this.request.getHttpHeaders().getHeaderString(ORIGIN);
        if (origin == null) {
            return this.response.build();
        }
        if (!(this.preflight || this.allowedOrigins != null && this.allowedOrigins.contains(origin))) {
            return this.response.build();
        }
        this.response.header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
        if (this.allowedMethods != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.allowedMethods.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.allowedMethods[i]);
            }
            this.response.header(ACCESS_CONTROL_ALLOW_METHODS, (Object)sb.toString());
        } else {
            this.response.header(ACCESS_CONTROL_ALLOW_METHODS, (Object)DEFAULT_ALLOW_METHODS);
        }
        this.response.header(ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)Boolean.toString(this.auth));
        if (this.auth) {
            this.response.header(ACCESS_CONTROL_ALLOW_HEADERS, (Object)"Authorization");
        }
        this.response.header(ACCESS_CONTROL_MAX_AGE, (Object)DEFAULT_MAX_AGE);
        return this.response.build();
    }
}

