/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.PublicRealmResource;
import org.keycloak.services.resources.TokenService;

@Path(value="/realms")
public class RealmsResource {
    protected static Logger logger = Logger.getLogger(RealmsResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;
    protected TokenManager tokenManager;
    protected SocialRequestManager socialRequestManager;

    public RealmsResource(TokenManager tokenManager, SocialRequestManager socialRequestManager) {
        this.tokenManager = tokenManager;
        this.socialRequestManager = socialRequestManager;
    }

    public static UriBuilder realmBaseUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    @Path(value="{realm}/tokens")
    public TokenService getTokenService(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        TokenService tokenService = new TokenService(realm, this.tokenManager);
        this.resourceContext.initResource((Object)tokenService);
        return tokenService;
    }

    protected RealmModel locateRealm(String name, RealmManager realmManager) {
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("Realm " + name + " not found");
        }
        return realm;
    }

    @Path(value="{realm}/account")
    public AccountService getAccountService(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        ApplicationModel application = (ApplicationModel)realm.getApplicationNameMap().get("account");
        if (application == null || !application.isEnabled()) {
            logger.debug("account management not enabled");
            throw new NotFoundException();
        }
        AccountService accountService = new AccountService(realm, application, this.tokenManager, this.socialRequestManager);
        this.resourceContext.initResource((Object)accountService);
        return accountService;
    }

    @Path(value="{realm}")
    public PublicRealmResource getRealmResource(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        PublicRealmResource realmResource = new PublicRealmResource(realm);
        this.resourceContext.initResource((Object)realmResource);
        return realmResource;
    }
}

