/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthFlows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.social.AuthCallback;
import org.keycloak.social.RequestDetails;
import org.keycloak.social.SocialAccessDeniedException;
import org.keycloak.social.SocialLoader;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;

@Path(value="/social")
public class SocialResource {
    protected static Logger logger = Logger.getLogger(SocialResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    private HttpRequest request;
    @Context
    ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;
    private SocialRequestManager socialRequestManager;
    private TokenManager tokenManager;
    private AuthenticationManager authManager = new AuthenticationManager();

    public SocialResource(TokenManager tokenManager, SocialRequestManager socialRequestManager) {
        this.tokenManager = tokenManager;
        this.socialRequestManager = socialRequestManager;
    }

    @GET
    @Path(value="callback")
    public Response callback() throws URISyntaxException {
        SocialUser socialUser;
        Map<String, String[]> queryParams = this.getQueryParams();
        RequestDetails requestData = this.getRequestDetails(queryParams);
        SocialProvider provider = SocialLoader.load((String)requestData.getProviderId());
        String realmName = requestData.getClientAttribute("realm");
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        OAuthFlows oauth = Flows.oauth(realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!realm.isEnabled()) {
            return oauth.forwardToSecurityFailure("Realm not enabled.");
        }
        String clientId = (String)requestData.getClientAttributes().get("clientId");
        ClientModel client = realm.findClient(clientId);
        if (client == null) {
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        String key = (String)realm.getSocialConfig().get(requestData.getProviderId() + ".key");
        String secret = (String)realm.getSocialConfig().get(requestData.getProviderId() + ".secret");
        String callbackUri = Urls.socialCallback(this.uriInfo.getBaseUri()).toString();
        SocialProviderConfig config = new SocialProviderConfig(key, secret, callbackUri);
        AuthCallback callback = new AuthCallback(requestData.getSocialAttributes(), queryParams);
        try {
            socialUser = provider.processCallback(config, callback);
        }
        catch (SocialAccessDeniedException e) {
            MultivaluedHashMap queryParms = new MultivaluedHashMap();
            queryParms.putSingle((Object)"client_id", (Object)requestData.getClientAttribute("clientId"));
            queryParms.putSingle((Object)"state", (Object)requestData.getClientAttribute("state"));
            queryParms.putSingle((Object)"scope", (Object)requestData.getClientAttribute("scope"));
            queryParms.putSingle((Object)"redirect_uri", (Object)requestData.getClientAttribute("redirectUri"));
            queryParms.putSingle((Object)"response_type", (Object)requestData.getClientAttribute("responseType"));
            return Flows.forms(realm, this.request, this.uriInfo).setQueryParams((MultivaluedMap)queryParms).setWarning("Access denied").createLogin();
        }
        catch (SocialProviderException e) {
            logger.warn("Failed to process social callback", (Throwable)e);
            return oauth.forwardToSecurityFailure("Failed to process social callback");
        }
        SocialLinkModel socialLink = new SocialLinkModel(provider.getId(), socialUser.getId(), socialUser.getUsername());
        UserModel user = realm.getUserBySocialLink(socialLink);
        String userId = requestData.getClientAttribute("userId");
        if (userId != null) {
            UserModel authenticatedUser = realm.getUserById(userId);
            if (user != null) {
                return oauth.forwardToSecurityFailure("This social account is already linked to other user");
            }
            if (!authenticatedUser.isEnabled()) {
                return oauth.forwardToSecurityFailure("User is disabled");
            }
            if (!realm.hasRole(authenticatedUser, realm.getApplicationByName("account").getRole("manage-account"))) {
                return oauth.forwardToSecurityFailure("Insufficient permissions to link social account");
            }
            realm.addSocialLink(authenticatedUser, socialLink);
            logger.debug("Social provider " + provider.getId() + " linked with user " + authenticatedUser.getLoginName());
            String redirectUri = (String)requestData.getClientAttributes().get("redirectUri");
            if (redirectUri == null) {
                return oauth.forwardToSecurityFailure("Unknown redirectUri");
            }
            return Response.status((Response.Status)Response.Status.FOUND).location(UriBuilder.fromUri((String)redirectUri).build(new Object[0])).build();
        }
        if (user == null) {
            if (!realm.isRegistrationAllowed()) {
                return oauth.forwardToSecurityFailure("Registration not allowed");
            }
            user = realm.addUser(KeycloakModelUtils.generateId());
            user.setEnabled(true);
            user.setFirstName(socialUser.getFirstName());
            user.setLastName(socialUser.getLastName());
            user.setEmail(socialUser.getEmail());
            if (realm.isUpdateProfileOnInitialSocialLogin()) {
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
            }
            realm.addSocialLink(user, socialLink);
        }
        if (!user.isEnabled()) {
            return oauth.forwardToSecurityFailure("Your account is not enabled.");
        }
        String scope = (String)requestData.getClientAttributes().get("scope");
        String state = (String)requestData.getClientAttributes().get("state");
        String redirectUri = (String)requestData.getClientAttributes().get("redirectUri");
        return oauth.processAccessCode(scope, state, redirectUri, client, user);
    }

    @GET
    @Path(value="{realm}/login")
    public Response redirectToProviderAuth(@PathParam(value="realm") String realmName, @QueryParam(value="provider_id") String providerId, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scope, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="response_type") String responseType) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        SocialProvider provider = SocialLoader.load((String)providerId);
        if (provider == null) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Social provider not found").createErrorPage();
        }
        ClientModel client = realm.findClient(clientId);
        if (client == null) {
            logger.warn("Unknown login requester: " + clientId);
            return Flows.forms(realm, this.request, this.uriInfo).setError("Unknown login requester.").createErrorPage();
        }
        if (!client.isEnabled()) {
            logger.warn("Login requester not enabled.");
            return Flows.forms(realm, this.request, this.uriInfo).setError("Login requester not enabled.").createErrorPage();
        }
        if ((redirectUri = TokenService.verifyRedirectUri(redirectUri, client)) == null) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Invalid redirect_uri.").createErrorPage();
        }
        try {
            return Flows.social(this.socialRequestManager, realm, this.uriInfo, provider).putClientAttribute("realm", realmName).putClientAttribute("clientId", clientId).putClientAttribute("scope", scope).putClientAttribute("state", state).putClientAttribute("redirectUri", redirectUri).putClientAttribute("responseType", responseType).redirectToSocialProvider();
        }
        catch (Throwable t) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Failed to redirect to social auth").createErrorPage();
        }
    }

    private RequestDetails getRequestDetails(Map<String, String[]> queryParams) {
        String requestId = null;
        if (queryParams.containsKey("state")) {
            requestId = queryParams.get("state")[0];
        } else if (queryParams.containsKey("oauth_token")) {
            requestId = queryParams.get("oauth_token")[0];
        } else if (queryParams.containsKey("denied")) {
            requestId = queryParams.get("denied")[0];
        }
        if (requestId != null && this.socialRequestManager.isRequestId(requestId)) {
            return this.socialRequestManager.retrieveData(requestId);
        }
        return null;
    }

    private Map<String, String[]> getQueryParams() {
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        for (Map.Entry e : this.uriInfo.getQueryParameters().entrySet()) {
            queryParams.put((String)e.getKey(), ((List)e.getValue()).toArray(new String[((List)e.getValue()).size()]));
        }
        return queryParams;
    }
}

