/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.services.managers.OAuthClientManager;
import org.keycloak.services.resources.admin.OAuthClientResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RealmAuth;

public class OAuthClientsResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    protected KeycloakSession session;
    @Context
    protected ResourceContext resourceContext;
    private RealmAuth auth;

    public OAuthClientsResource(RealmModel realm, RealmAuth auth, KeycloakSession session) {
        this.auth = auth;
        this.realm = realm;
        this.session = session;
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<OAuthClientRepresentation> getOAuthClients() {
        ArrayList<OAuthClientRepresentation> rep = new ArrayList<OAuthClientRepresentation>();
        List oauthModels = this.realm.getOAuthClients();
        boolean view = this.auth.hasView();
        for (OAuthClientModel oauth : oauthModels) {
            if (view) {
                rep.add(OAuthClientManager.toRepresentation(oauth));
                continue;
            }
            OAuthClientRepresentation client = new OAuthClientRepresentation();
            client.setName(oauth.getClientId());
            rep.add(client);
        }
        return rep;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createOAuthClient(@Context UriInfo uriInfo, OAuthClientRepresentation rep) {
        this.auth.requireManage();
        OAuthClientManager resourceManager = new OAuthClientManager(this.realm);
        OAuthClientModel oauth = resourceManager.create(rep);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(oauth.getId()).build(new Object[0])).build();
    }

    @Path(value="{id}")
    public OAuthClientResource getOAuthClient(@PathParam(value="id") String id) {
        this.auth.requireView();
        OAuthClientModel oauth = this.realm.getOAuthClientById(id);
        if (oauth == null) {
            throw new NotFoundException();
        }
        OAuthClientResource oAuthClientResource = new OAuthClientResource(this.realm, this.auth, oauth, this.session);
        this.resourceContext.initResource((Object)oAuthClientResource);
        return oAuthClientResource;
    }
}

