/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.representations.adapters.action.SessionStats;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.admin.ApplicationsResource;
import org.keycloak.services.resources.admin.OAuthClientsResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleByIdResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.UsersResource;

public class RealmAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmAuth auth;
    protected RealmModel realm;
    private TokenManager tokenManager;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;

    public RealmAdminResource(RealmAuth auth, RealmModel realm, TokenManager tokenManager) {
        this.auth = auth;
        this.realm = realm;
        this.tokenManager = tokenManager;
        auth.init(RealmAuth.Resource.REALM);
    }

    @Path(value="applications")
    public ApplicationsResource getApplications() {
        ApplicationsResource applicationsResource = new ApplicationsResource(this.realm, this.auth);
        this.resourceContext.initResource((Object)applicationsResource);
        return applicationsResource;
    }

    @Path(value="oauth-clients")
    public OAuthClientsResource getOAuthClients() {
        OAuthClientsResource oauth = new OAuthClientsResource(this.realm, this.auth, this.session);
        this.resourceContext.initResource((Object)oauth);
        return oauth;
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.realm, this.auth, (RoleContainerModel)this.realm);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RealmRepresentation getRealm() {
        if (this.auth.hasView()) {
            return ModelToRepresentation.toRepresentation(this.realm);
        }
        this.auth.requireAny();
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(this.realm.getName());
        return rep;
    }

    @PUT
    @Consumes(value={"application/json"})
    public void updateRealm(RealmRepresentation rep) {
        this.auth.requireManage();
        logger.debug("updating realm: " + this.realm.getName());
        new RealmManager(this.session).updateRealm(rep, this.realm);
    }

    @DELETE
    public void deleteRealm() {
        this.auth.requireManage();
        if (!new RealmManager(this.session).removeRealm(this.realm)) {
            throw new NotFoundException();
        }
    }

    @Path(value="users")
    public UsersResource users() {
        UsersResource users = new UsersResource(this.realm, this.auth, this.tokenManager);
        this.resourceContext.initResource((Object)users);
        return users;
    }

    @Path(value="roles-by-id")
    public RoleByIdResource rolesById() {
        RoleByIdResource resource = new RoleByIdResource(this.realm, this.auth);
        this.resourceContext.initResource((Object)resource);
        return resource;
    }

    @Path(value="push-revocation")
    @POST
    public void pushRevocation() {
        this.auth.requireManage();
        new ResourceAdminManager().pushRealmRevocationPolicy(this.realm);
    }

    @Path(value="logout-all")
    @POST
    public void logoutAll() {
        this.auth.requireManage();
        new ResourceAdminManager().logoutAll(this.realm);
    }

    @Path(value="session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, SessionStats> getSessionStats() {
        logger.info("session-stats");
        this.auth.requireView();
        HashMap<String, SessionStats> stats = new HashMap<String, SessionStats>();
        for (ApplicationModel applicationModel : this.realm.getApplications()) {
            if (applicationModel.getManagementUrl() == null) continue;
            SessionStats appStats = new ResourceAdminManager().getSessionStats(this.realm, applicationModel, false);
            stats.put(applicationModel.getName(), appStats);
        }
        return stats;
    }
}

